/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.eums.ScoreStatusType;
import com.tydic.nbchat.user.api.bo.eums.TradeBusiCodeDefine;
import com.tydic.nbchat.user.api.bo.eums.TradePayType;
import com.tydic.nbchat.user.api.bo.eums.TradeType;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceDeductReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserTradeResult;
import com.tydic.nbchat.user.core.busi.ScoreBalanceService;
import com.tydic.nbchat.user.core.busi.UserMakeEventSender;
import com.tydic.nbchat.user.core.busi.UserVipService;
import com.tydic.nbchat.user.core.service.TenantBalanceNotificationCheckService;
import com.tydic.nbchat.user.mapper.CommonMapper;
import com.tydic.nbchat.user.mapper.NbchatUserBalanceMapper;
import com.tydic.nbchat.user.mapper.NbchatUserBillDetailMapper;
import com.tydic.nbchat.user.mapper.NbchatUserBillRecordMapper;
import com.tydic.nbchat.user.mapper.NbchatUserScoreDetailMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserBalance;
import com.tydic.nbchat.user.mapper.po.NbchatUserBillDetail;
import com.tydic.nbchat.user.mapper.po.NbchatUserBillRecord;
import com.tydic.nbchat.user.mapper.po.NbchatUserScoreDetail;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScoreDeductService {
    private static final Logger log = LoggerFactory.getLogger(ScoreDeductService.class);
    @Resource
    private NbchatUserScoreDetailMapper nbchatUserScoreDetailMapper;
    @Resource
    private NbchatUserBalanceMapper nbchatUserBalanceMapper;
    @Resource
    private NbchatUserBillRecordMapper nbchatUserBillRecordMapper;
    @Resource
    private NbchatUserBillDetailMapper nbchatUserBillDetailMapper;
    @Resource
    CommonMapper commonMapper;
    private final ScoreBalanceService scoreBalanceService;
    private final UserVipService userVipService;
    private final UserMakeEventSender userMakeEventSender;
    private final TenantBalanceNotificationCheckService tenantBalanceNotificationCheckService;

    public ScoreDeductService(ScoreBalanceService scoreBalanceService, UserVipService userVipService, UserMakeEventSender userMakeEventSender, TenantBalanceNotificationCheckService tenantBalanceNotificationCheckService) {
        this.scoreBalanceService = scoreBalanceService;
        this.userVipService = userVipService;
        this.userMakeEventSender = userMakeEventSender;
        this.tenantBalanceNotificationCheckService = tenantBalanceNotificationCheckService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public Rsp<UserTradeResult> deduct(UserBalanceDeductReqBO deduct) {
        NbchatUserBalance balance;
        String accountUid = deduct.getUserId();
        if (TradePayType.ENTERPRISE.getCode().equals(deduct.getPayType())) {
            accountUid = deduct.getTenantCode();
        }
        String tradeId = IdWorker.nextAutoIdStr();
        Integer score = deduct.getScore();
        String remark = deduct.getRemark();
        if (score == null) {
            boolean isVip;
            score = TradeBusiCodeDefine.countScore((String)deduct.getBizCode(), (int)deduct.getAmount());
            if (TradeBusiCodeDefine.PPT_CREATION.getCode().equals(deduct.getBizCode()) && (isVip = this.userVipService.isVip(deduct.getTenantCode(), deduct.getUserId()))) {
                score = 0;
                remark = "\u4f1a\u5458\u9650\u514d";
            }
        }
        if (StringUtils.isBlank((CharSequence)remark)) {
            remark = "\u7b97\u529b\u70b9\u6d88\u8d39";
            if (TradePayType.ENTERPRISE.getCode().equals(deduct.getPayType())) {
                remark = "\u7b97\u529b\u70b9\u6d88\u8d39(\u4f01\u4e1a\u652f\u4ed8)";
            }
        }
        if ((balance = this.nbchatUserBalanceMapper.selectByUserId(deduct.getTenantCode(), accountUid)) == null) return BaseRspUtils.createErrorRsp((String)"\u4ea4\u6613\u5931\u8d25\uff1a\u8d26\u6237\u4e0d\u5b58\u5728");
        if (score > 0 && score > balance.getScore()) {
            int count;
            if (!"00000000".equals(deduct.getTenantCode())) return BaseRspUtils.createErrorRsp((String)"1000", (String)"\u7b97\u529b\u70b9\u6d88\u8d39\uff1a\u4f59\u989d\u4e0d\u8db3");
            if (TradeBusiCodeDefine.VIDEO_CREATION.getCode().equals(deduct.getBizCode()) && deduct.getAmount() <= 30) {
                count = this.commonMapper.queryVideoCount(deduct.getUserId());
                if (count > 1) return BaseRspUtils.createErrorRsp((String)"1000", (String)"\u7b97\u529b\u70b9\u6d88\u8d39\uff1a\u4f59\u989d\u4e0d\u8db3");
                log.info("\u751f\u6210\u89c6\u9891-\u7b97\u529b\u70b9\u6d88\u8d39-\u7528\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u7b2c\u4e00\u6b21\u4f7f\u7528\uff0c\u76f4\u63a5\u6263\u5149:{}", (Object)deduct);
                score = balance.getScore();
            }
            if (TradeBusiCodeDefine.AI_PPT_CREATION.getCode().equals(deduct.getBizCode())) {
                count = this.commonMapper.queryPPTCount(deduct.getUserId());
                if (count != 0) return BaseRspUtils.createErrorRsp((String)"1000", (String)"\u7b97\u529b\u70b9\u6d88\u8d39\uff1a\u4f59\u989d\u4e0d\u8db3");
                log.info("\u751f\u6210aippt-\u7b97\u529b\u70b9\u6d88\u8d39-\u7528\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u7b2c\u4e00\u6b21\u4f7f\u7528\uff0c\u76f4\u63a5\u6263\u5149:{}", (Object)deduct);
                score = balance.getScore();
            }
        }
        List details = this.nbchatUserScoreDetailMapper.selectAvailableScore(deduct.getTenantCode(), accountUid);
        Integer totalScore = 0;
        if (details.isEmpty()) {
            log.warn("\u7b97\u529b\u70b9\u6d88\u8d39-\u7528\u6237\u4f59\u989d\u660e\u7ec6\u4e3a\u7a7a:{}", (Object)deduct);
        } else {
            totalScore = details.stream().map(NbchatUserScoreDetail::getScore).reduce(0, Integer::sum);
        }
        if (score > 0 && !Objects.equals(balance.getScore(), totalScore)) {
            log.error("\u7b97\u529b\u70b9\u6d88\u8d39-\u7528\u6237\u4f59\u989d\u660e\u7ec6\u5bf9\u8d26\u5f02\u5e38:{}|{}, balance = {}, detailSum = {}", new Object[]{deduct, details, balance.getScore(), totalScore});
        }
        if (!"00000000".equals(deduct.getTenantCode())) {
            this.tenantBalanceNotificationCheckService.checkAndSendNotification(deduct, totalScore);
        }
        if (score > 0 && score > totalScore) {
            log.warn("\u7b97\u529b\u70b9\u6d88\u8d39-\u7528\u6237\u4f59\u989d\u4e0d\u8db3:{}|{}, balance = {}, detailSum = {}", new Object[]{deduct, details, balance.getScore(), totalScore});
            return BaseRspUtils.createErrorRsp((String)"1000", (String)"\u7b97\u529b\u70b9\u6d88\u8d39\uff1a\u4f59\u989d\u4e0d\u8db3");
        }
        ArrayList<NbchatUserBillDetail> list = new ArrayList<NbchatUserBillDetail>();
        Integer tmpScore = score;
        for (NbchatUserScoreDetail detail : details) {
            if (tmpScore <= 0) continue;
            NbchatUserBillDetail billDetail = new NbchatUserBillDetail();
            if (detail.getScore() >= tmpScore) {
                detail.setScore(Integer.valueOf(detail.getScore() - tmpScore));
                this.nbchatUserScoreDetailMapper.deductScore(detail.getId(), tmpScore);
                billDetail.setScore(Integer.valueOf(-tmpScore.intValue()));
                tmpScore = 0;
            } else {
                this.nbchatUserScoreDetailMapper.deductScore(detail.getId(), detail.getScore());
                tmpScore = tmpScore - detail.getScore();
                billDetail.setScore(Integer.valueOf(-detail.getScore().intValue()));
                detail.setScore(Integer.valueOf(0));
            }
            billDetail.setUserId(deduct.getUserId());
            billDetail.setTenantCode(deduct.getTenantCode());
            billDetail.setTradeId(tradeId);
            billDetail.setCreateTime(new Date());
            billDetail.setAccountId(detail.getId());
            billDetail.setBillDesc(remark);
            list.add(billDetail);
        }
        if (!list.isEmpty()) {
            this.nbchatUserBillDetailMapper.insertBatch(list);
        }
        deduct.setTradeTime(new Date());
        balance.setScore(Integer.valueOf(balance.getScore() - score));
        balance.setUpdateTime(new Date());
        this.nbchatUserBalanceMapper.updateByPrimaryKeySelective(balance);
        NbchatUserBillRecord record = new NbchatUserBillRecord();
        BeanUtils.copyProperties((Object)deduct, (Object)record);
        record.setScore(Integer.valueOf(-score.intValue()));
        record.setTradeId(tradeId);
        record.setPrice(TradeBusiCodeDefine.getPriceByCode((String)deduct.getBizCode()));
        record.setAmount(deduct.getAmount());
        record.setRemark(remark);
        this.nbchatUserBillRecordMapper.insertSelective(record);
        UserTradeResult result = new UserTradeResult();
        BeanUtils.copyProperties((Object)record, (Object)result);
        Rsp<UserBalanceBO> balanceRsp = this.scoreBalanceService.getBalance(deduct.getTenantCode(), accountUid);
        result.setBalance((UserBalanceBO)balanceRsp.getData());
        if (!TradePayType.PERSONAL.getCode().equals(deduct.getPayType())) return BaseRspUtils.createSuccessRsp((Object)result, (String)"\u4ea4\u6613\u6210\u529f");
        this.userMakeEventSender.sendScoreChangeEvent(result, ((UserBalanceBO)balanceRsp.getData()).getScore());
        return BaseRspUtils.createSuccessRsp((Object)result, (String)"\u4ea4\u6613\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public void expiredDeduct(NbchatUserScoreDetail scoreDetail) {
        NbchatUserBalance balance = this.nbchatUserBalanceMapper.selectByUserId(scoreDetail.getTenantCode(), scoreDetail.getUserId());
        if (balance == null) {
            log.error("\u7528\u6237\u79ef\u5206\u8fc7\u671f\uff0c\u7528\u6237\u4f59\u989d\u4e0d\u5b58\u5728:{}", (Object)scoreDetail);
            throw new RuntimeException("\u7528\u6237\u79ef\u5206\u8fc7\u671f\uff0c\u8d26\u6237\u4e0d\u5b58\u5728: " + scoreDetail.getTenantCode() + "|" + scoreDetail.getUserId());
        }
        log.info("\u7528\u6237\u79ef\u5206\u8fc7\u671f\uff0c\u5f00\u59cb\u6263\u51cf:{},{} - {}", new Object[]{scoreDetail.getUserId(), balance.getScore(), scoreDetail.getScore()});
        scoreDetail.setScoreStatus(ScoreStatusType.EXPIRED_ZERO.getCode());
        scoreDetail.setUpdateTime(new Date());
        this.nbchatUserScoreDetailMapper.updateByPrimaryKeySelective(scoreDetail);
        this.nbchatUserBalanceMapper.updateBalance(scoreDetail.getTenantCode(), scoreDetail.getUserId());
        String tradeId = IdWorker.nextAutoIdStr();
        NbchatUserBillRecord record = ScoreDeductService.getNbchatUserBillRecord(scoreDetail, tradeId);
        this.nbchatUserBillRecordMapper.insertSelective(record);
        NbchatUserBillDetail billDetail = new NbchatUserBillDetail();
        billDetail.setTradeId(tradeId);
        billDetail.setUserId(scoreDetail.getUserId());
        billDetail.setTenantCode(scoreDetail.getTenantCode());
        billDetail.setScore(Integer.valueOf(-Math.abs(scoreDetail.getScore())));
        billDetail.setCreateTime(new Date());
        billDetail.setAccountId(scoreDetail.getId());
        billDetail.setBillDesc("\u7b97\u529b\u70b9\u8fc7\u671f");
        this.nbchatUserBillDetailMapper.insertSelective(billDetail);
        UserTradeResult result = new UserTradeResult();
        BeanUtils.copyProperties((Object)record, (Object)result);
        this.userMakeEventSender.sendScoreChangeEvent(result, balance.getScore());
    }

    @NotNull
    private static NbchatUserBillRecord getNbchatUserBillRecord(NbchatUserScoreDetail scoreDetail, String tradeId) {
        NbchatUserBillRecord record = new NbchatUserBillRecord();
        record.setUserId(scoreDetail.getUserId());
        record.setTenantCode(scoreDetail.getTenantCode());
        record.setTradeTime(new Date());
        record.setBizCode(TradeBusiCodeDefine.DOU_EXPIRED.getCode());
        record.setBizName("-");
        record.setScore(Integer.valueOf(-Math.abs(scoreDetail.getScore())));
        record.setTradeId(tradeId);
        record.setPrice(Integer.valueOf(1));
        record.setAmount(scoreDetail.getScore());
        record.setType(TradeType.DEDUCT.getCode());
        record.setRemark("\u7b97\u529b\u70b9\u8fc7\u671f");
        return record;
    }
}

