/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.core.busi.ScoreDeductService;
import com.tydic.nbchat.user.mapper.NbchatUserScoreDetailMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserScoreDetail;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScoreExpiredCheckService {
    private static final Logger log = LoggerFactory.getLogger(ScoreExpiredCheckService.class);
    @Resource
    private NbchatUserScoreDetailMapper nbchatUserScoreDetailMapper;
    private final ScoreDeductService scoreDeductService;

    public ScoreExpiredCheckService(ScoreDeductService scoreDeductService) {
        this.scoreDeductService = scoreDeductService;
    }

    public void doScoreExpiredCheck(Date checkTime) {
        log.info("\u7528\u6237\u79ef\u5206\u8fc7\u671f\u4efb\u52a1\uff0c\u5f00\u59cb\u6267\u884c:{}", (Object)checkTime);
        List scoreDetails = this.nbchatUserScoreDetailMapper.selectExpiredScore(checkTime);
        for (NbchatUserScoreDetail scoreDetail : scoreDetails) {
            try {
                log.info("\u7528\u6237\u79ef\u5206\u8fc7\u671f\u4efb\u52a1\uff0c\u5904\u7406\u8fc7\u671f\u8d26\u6237:{}", (Object)scoreDetail);
                this.scoreDeductService.expiredDeduct(scoreDetail);
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u79ef\u5206\u8fc7\u671f\u4efb\u52a1\uff0c\u5904\u7406\u5f02\u5e38:{}", (Object)scoreDetail, (Object)e);
            }
        }
        log.info("\u7528\u6237\u79ef\u5206\u8fc7\u671f\u4efb\u52a1\uff0c\u6267\u884c\u5b8c\u6210:{}", (Object)scoreDetails.size());
    }
}

