/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.eums.ScoreStatusType;
import com.tydic.nbchat.user.api.bo.eums.TradeType;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRechargeReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserTradeResult;
import com.tydic.nbchat.user.core.busi.ScoreBalanceService;
import com.tydic.nbchat.user.core.busi.UserMakeEventSender;
import com.tydic.nbchat.user.mapper.NbchatUserBalanceMapper;
import com.tydic.nbchat.user.mapper.NbchatUserBillRecordMapper;
import com.tydic.nbchat.user.mapper.NbchatUserScoreDetailMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserBalance;
import com.tydic.nbchat.user.mapper.po.NbchatUserBillRecord;
import com.tydic.nbchat.user.mapper.po.NbchatUserScoreDetail;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScoreRechargeService {
    private static final Logger log = LoggerFactory.getLogger(ScoreRechargeService.class);
    @Resource
    private NbchatUserBalanceMapper nbchatUserBalanceMapper;
    @Resource
    private NbchatUserBillRecordMapper nbchatUserBillRecordMapper;
    @Resource
    private NbchatUserScoreDetailMapper nbchatUserScoreDetailMapper;
    private final ScoreBalanceService scoreBalanceService;
    private final UserMakeEventSender userMakeEventSender;

    public ScoreRechargeService(ScoreBalanceService scoreBalanceService, UserMakeEventSender userMakeEventSender) {
        this.scoreBalanceService = scoreBalanceService;
        this.userMakeEventSender = userMakeEventSender;
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp<UserTradeResult> recharge(UserBalanceRechargeReqBO recharge) {
        log.info("\u4f59\u989d\u5145\u503c-\u53c2\u6570: {}", (Object)recharge);
        NbchatUserBalance balance = this.nbchatUserBalanceMapper.selectByUserId(recharge.getTenantCode(), recharge.getUserId());
        if (balance != null) {
            int score = recharge.getScore();
            if (score <= 0) {
                return BaseRspUtils.createErrorRsp((String)"\u5145\u503c\u79ef\u5206\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            recharge.setTradeTime(new Date());
            balance.setScore(Integer.valueOf(balance.getScore() + score));
            balance.setUpdateTime(new Date());
            this.nbchatUserBalanceMapper.updateByPrimaryKeySelective(balance);
            NbchatUserScoreDetail scoreDetail = new NbchatUserScoreDetail();
            scoreDetail.setTenantCode(recharge.getTenantCode());
            scoreDetail.setUserId(recharge.getUserId());
            scoreDetail.setScoreType(recharge.getScoreType());
            scoreDetail.setScore(Integer.valueOf(score));
            scoreDetail.setCreateTime(new Date());
            scoreDetail.setScoreDesc(recharge.getRemark());
            scoreDetail.setExpireTime(recharge.getExpireTime());
            scoreDetail.setOrderNo(recharge.getOrderNo());
            if (StringUtils.isBlank((CharSequence)scoreDetail.getScoreDesc())) {
                scoreDetail.setScoreDesc("\u7b97\u529b\u70b9\u5145\u503c");
            }
            if (recharge.getExpireTime() == null) {
                Date date = DateTimeUtil.DateAddYear((int)1);
                scoreDetail.setExpireTime(DateTimeUtil.createTime((Date)date, (int)23, (int)59, (int)59));
            }
            scoreDetail.setScoreStatus(ScoreStatusType.VALID.getCode());
            this.nbchatUserScoreDetailMapper.insertSelective(scoreDetail);
            NbchatUserBillRecord record = new NbchatUserBillRecord();
            BeanUtils.copyProperties((Object)recharge, (Object)record);
            record.setScore(Integer.valueOf(score));
            record.setType(TradeType.RECHARGE.getCode());
            if (StringUtils.isBlank((CharSequence)record.getTradeId())) {
                record.setTradeId(IdWorker.nextAutoIdStr());
            }
            if (StringUtils.isBlank((CharSequence)record.getRemark())) {
                record.setRemark("\u7b97\u529b\u70b9\u5145\u503c");
            }
            this.nbchatUserBillRecordMapper.insertSelective(record);
            UserTradeResult result = new UserTradeResult();
            BeanUtils.copyProperties((Object)record, (Object)result);
            Rsp<UserBalanceBO> balanceRsp = this.scoreBalanceService.getBalance(recharge.getTenantCode(), recharge.getUserId());
            result.setBalance((UserBalanceBO)balanceRsp.getData());
            this.userMakeEventSender.sendScoreChangeEvent(result, balance.getScore());
            return BaseRspUtils.createSuccessRsp((Object)result, (String)"\u4ea4\u6613\u6210\u529f");
        }
        return BaseRspUtils.createErrorRsp((String)"\u5145\u503c\u5931\u8d25");
    }
}

