/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.eums.TradeBusiCodeDefine;
import com.tydic.nbchat.user.api.bo.eums.TradePayType;
import com.tydic.nbchat.user.api.bo.eums.TradeType;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRefundReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserTradeResult;
import com.tydic.nbchat.user.core.busi.ScoreBalanceService;
import com.tydic.nbchat.user.core.busi.UserMakeEventSender;
import com.tydic.nbchat.user.mapper.NbchatUserBalanceMapper;
import com.tydic.nbchat.user.mapper.NbchatUserBillDetailMapper;
import com.tydic.nbchat.user.mapper.NbchatUserBillRecordMapper;
import com.tydic.nbchat.user.mapper.NbchatUserScoreDetailMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserBillDetail;
import com.tydic.nbchat.user.mapper.po.NbchatUserBillRecord;
import com.tydic.nicc.common.nbchat.emus.MakeEventType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScoreRefundService {
    private static final Logger log = LoggerFactory.getLogger(ScoreRefundService.class);
    @Resource
    private NbchatUserBalanceMapper nbchatUserBalanceMapper;
    @Resource
    private NbchatUserBillRecordMapper nbchatUserBillRecordMapper;
    @Resource
    private NbchatUserBillDetailMapper nbchatUserBillDetailMapper;
    @Resource
    private NbchatUserScoreDetailMapper nbchatUserScoreDetailMapper;
    private final ScoreBalanceService scoreBalanceService;
    private final UserMakeEventSender userMakeEventSender;

    public ScoreRefundService(ScoreBalanceService scoreBalanceService, UserMakeEventSender userMakeEventSender) {
        this.scoreBalanceService = scoreBalanceService;
        this.userMakeEventSender = userMakeEventSender;
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp<UserTradeResult> refund(UserBalanceRefundReqBO refund) {
        log.info("\u4f59\u989d\u9000\u6b3e-\u53c2\u6570: {}", (Object)refund);
        NbchatUserBillRecord tradeOrder = this.nbchatUserBillRecordMapper.selectByTradeId(refund.getTradeId(), refund.getBizId());
        if (tradeOrder != null) {
            if (tradeOrder.getBizCode().equals(TradeBusiCodeDefine.VIDEO_CREATION.getCode())) {
                this.userMakeEventSender.sendMakeEvent(tradeOrder.getTenantCode(), tradeOrder.getUserId(), MakeEventType.MAKE_TDH.getCode(), 0, 1);
            }
            if (tradeOrder.getScore() > 0) {
                return BaseRspUtils.createErrorRsp((String)"\u9000\u6b3e\u5931\u8d25\uff1a\u4ea4\u6613\u6d41\u6c34\u5f02\u5e38");
            }
            int countRefund = this.nbchatUserBillRecordMapper.countRefundScore(refund.getBizId(), refund.getTradeId());
            int userRefundScore = 0;
            if (refund.getRefundScore() != null && refund.getRefundScore() > 0) {
                userRefundScore = refund.getRefundScore();
            }
            log.info("\u4f59\u989d\u9000\u6b3ebiz_id:{},trade_id:{}-\u5386\u53f2\u9000\u6b3e\uff1a{},\u672c\u6b21\u9000\u6b3e\uff1a{}\uff0c\u9000\u6b3e\u9650\u989d: {}", new Object[]{refund.getBizId(), refund.getTradeId(), countRefund, userRefundScore, tradeOrder.getScore()});
            if (countRefund + userRefundScore > Math.abs(tradeOrder.getScore())) {
                return BaseRspUtils.createErrorRsp((String)"\u9000\u6b3e\u5931\u8d25\uff1a\u9000\u6b3e\u79ef\u5206\u5927\u4e8e\u4ea4\u6613\u79ef\u5206");
            }
            String type = TradeType.REFUND.getCode();
            int refundScore = Math.abs(tradeOrder.getScore());
            if (refund.getRefundScore() != null && refund.getRefundScore() > 0) {
                if (refund.getRefundScore() > refundScore) {
                    return BaseRspUtils.createErrorRsp((String)"\u9000\u6b3e\u5931\u8d25\uff1a\u9000\u6b3e\u79ef\u5206\u5927\u4e8e\u4ea4\u6613\u79ef\u5206");
                }
                refundScore = refund.getRefundScore();
                type = TradeType.PART_REFUND.getCode();
            }
            log.info("\u4f59\u989d\u9000\u6b3ebiz_id:{},trade_id:{}-\u5386\u53f2\u9000\u6b3e\uff1a{},\u672c\u6b21\u9000\u6b3e\uff1a{},\u9000\u6b3e\u7c7b\u578b\uff1a{}", new Object[]{refund.getBizId(), refund.getTradeId(), countRefund, refundScore, type});
            NbchatUserBillRecord refundRecord = new NbchatUserBillRecord();
            refundRecord.setTradeId(IdWorker.nextAutoIdStr());
            refundRecord.setScore(Integer.valueOf(refundScore));
            refundRecord.setType(type);
            refundRecord.setTradeTime(new Date());
            refundRecord.setBizId(tradeOrder.getBizId());
            refundRecord.setBizCode(tradeOrder.getBizCode());
            refundRecord.setBizName(tradeOrder.getBizName());
            refundRecord.setTenantCode(tradeOrder.getTenantCode());
            refundRecord.setUserId(tradeOrder.getUserId());
            refundRecord.setPayType(tradeOrder.getPayType());
            refundRecord.setRefundTradeId(refund.getTradeId());
            if (StringUtils.isBlank((CharSequence)tradeOrder.getRemark())) {
                refundRecord.setRemark("\u7b97\u529b\u70b9\u9000\u8d39");
            } else {
                refundRecord.setRemark(refund.getRemark());
            }
            this.nbchatUserBillRecordMapper.insertSelective(refundRecord);
            log.info("\u4f59\u989d\u9000\u6b3ebiz_id:{},trade_id:{}-\u5386\u53f2\u9000\u6b3e\u6d41\u6c34:{}", new Object[]{refund.getBizId(), refund.getTradeId(), refundRecord});
            tradeOrder.setRefundTime(refundRecord.getRefundTime());
            tradeOrder.setRefundId(refundRecord.getTradeId());
            this.nbchatUserBillRecordMapper.updateByPrimaryKeySelective(tradeOrder);
            List details = this.nbchatUserBillDetailMapper.selectByTradeId(refund.getTradeId());
            if (!details.isEmpty()) {
                NbchatUserBillDetail detail = (NbchatUserBillDetail)details.get(details.size() - 1);
                this.nbchatUserScoreDetailMapper.refundScore(detail.getAccountId(), Integer.valueOf(refundScore));
                if (TradePayType.ENTERPRISE.getCode().equals(tradeOrder.getPayType())) {
                    this.nbchatUserBalanceMapper.updateBalance(tradeOrder.getTenantCode(), tradeOrder.getTenantCode());
                } else {
                    this.nbchatUserBalanceMapper.updateBalance(tradeOrder.getTenantCode(), tradeOrder.getUserId());
                }
                NbchatUserBillDetail refundDetail = ScoreRefundService.getNbchatUserBillDetail(detail, refundRecord, refundScore);
                this.nbchatUserBillDetailMapper.insertSelective(refundDetail);
            }
            UserTradeResult result = new UserTradeResult();
            BeanUtils.copyProperties((Object)refundRecord, (Object)result);
            Rsp<UserBalanceBO> balanceRsp = this.scoreBalanceService.getBalance(tradeOrder.getTenantCode(), tradeOrder.getUserId());
            result.setBalance((UserBalanceBO)balanceRsp.getData());
            this.userMakeEventSender.sendScoreChangeEvent(result, ((UserBalanceBO)balanceRsp.getData()).getScore());
            return BaseRspUtils.createSuccessRsp((Object)result, (String)"\u4ea4\u6613\u6210\u529f");
        }
        return BaseRspUtils.createErrorRsp((String)"\u9000\u6b3e\u5931\u8d25\uff1a\u67e5\u8be2\u4ea4\u6613\u6d41\u6c34\u5f02\u5e38");
    }

    @NotNull
    private static NbchatUserBillDetail getNbchatUserBillDetail(NbchatUserBillDetail detail, NbchatUserBillRecord refundRecord, int refundScore) {
        NbchatUserBillDetail refundDetail = new NbchatUserBillDetail();
        refundDetail.setCreateTime(new Date());
        refundDetail.setUserId(detail.getUserId());
        refundDetail.setTenantCode(detail.getTenantCode());
        refundDetail.setAccountId(detail.getAccountId());
        refundDetail.setTradeId(refundRecord.getTradeId());
        refundDetail.setScore(Integer.valueOf(refundScore));
        refundDetail.setBillDesc(refundRecord.getRemark());
        return refundDetail;
    }
}

