/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.account.UserUnRegAccountReqBO;
import com.tydic.nbchat.user.api.bo.eums.UserStatusType;
import com.tydic.nbchat.user.api.bo.regist.UserRegistReqBO;
import com.tydic.nbchat.user.api.bo.utils.PhoneNumberUtils;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.core.utils.PasswordHasher;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserAccountUnRegBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserAccountUnRegBusiService.class);
    @Resource
    private UserMapper userMapper;
    private final NbchatUserConfigProperties userConfigProperties;

    public UserAccountUnRegBusiService(NbchatUserConfigProperties userConfigProperties) {
        this.userConfigProperties = userConfigProperties;
    }

    public Rsp unRegUser(UserUnRegAccountReqBO reqBO) {
        log.info("\u7528\u6237\u6ce8\u9500\u8d26\u6237: {}", (Object)reqBO);
        UserPO userPO = this.userMapper.findUserByMobile(reqBO.getPhone());
        if (userPO == null) {
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        userPO.setIsDeleted(Boolean.valueOf(true));
        userPO.setUpdatedTime(new Date());
        userPO.setPhone("0" + userPO.getPhone());
        this.userMapper.updateById(userPO);
        return BaseRspUtils.createSuccessRsp((Object)"\u6ce8\u9500\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public UserPO registerUser(UserRegistReqBO registerReqBO, String id) {
        UserPO user;
        String userName = registerReqBO.getUsername();
        String password = registerReqBO.getPassword();
        String tenantCode = registerReqBO.getTenantCode();
        if (userName.length() > 20 || password.length() > 20) {
            log.warn("\u7528\u6237\u6ce8\u518c-\u7528\u6237\u540d\u5bc6\u7801\u957f\u5ea6\u8d85\u8fc7\u9650\u5236: {}|{}", (Object)userName, (Object)password);
            throw new RuntimeException("\u7528\u6237\u540d\u5bc6\u7801\u957f\u5ea6\u8d85\u8fc7\u9650\u5236");
        }
        Object realName = registerReqBO.getUserRealityName();
        String gender = registerReqBO.getGender();
        String name = registerReqBO.getName();
        if (StringUtils.isBlank((CharSequence)registerReqBO.getGender())) {
            gender = "0";
        }
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = "00000000";
        }
        if ((user = this.userMapper.findUserByUserName(userName)) != null) {
            log.warn("\u7528\u6237\u6ce8\u518c-\u6ce8\u518c\u5931\u8d25\uff0c\u7528\u6237\u5df2\u5b58\u5728: {}", (Object)userName);
            throw new RuntimeException("\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)registerReqBO.getPhone())) {
            boolean valid = PhoneNumberUtils.validPhoneNumber((String)registerReqBO.getPhone());
            if (!valid) {
                log.warn("\u7528\u6237\u6ce8\u518c-\u6ce8\u518c\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u5408\u6cd5: {}", (Object)registerReqBO.getPhone());
                throw new RuntimeException("\u624b\u673a\u53f7\u4e0d\u5408\u6cd5");
            }
            UserPO phoneUser = this.userMapper.findUserByMobile(registerReqBO.getPhone());
            if (phoneUser != null) {
                log.warn("\u7528\u6237\u6ce8\u518c-\u6ce8\u518c\u5931\u8d25\uff0c\u624b\u673a\u53f7\u5df2\u5b58\u5728: {}", (Object)registerReqBO.getPhone());
                throw new RuntimeException("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
            }
            realName = "\u7528\u6237" + registerReqBO.getPhone().substring(7);
        } else if (StringUtils.isBlank((CharSequence)realName)) {
            realName = "\u7528\u6237" + NiccCommonUtil.getRandomNumber((int)10000, (int)999999);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = realName;
        }
        UserPO userPO = new UserPO();
        userPO.setPhone(registerReqBO.getPhone());
        userPO.setUserId(id);
        userPO.setTenantCode(tenantCode);
        userPO.setAppId("00000000");
        userPO.setName(name);
        userPO.setUserName(userName);
        userPO.setRealName((String)realName);
        userPO.setPassword(password);
        userPO.setAvatar(this.userConfigProperties.getDefaultAvatar());
        userPO.setGender(gender);
        userPO.setCreatedBy(name);
        userPO.setUpdatedBy(name);
        userPO.setCreatedTime(new Date());
        userPO.setStatus(UserStatusType.NORMAL_USER.getCode());
        if (StringUtils.isNotBlank((CharSequence)registerReqBO.getTenantCode())) {
            userPO.setTenantCode(registerReqBO.getTenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)userPO.getPassword())) {
            userPO.setPassword(PasswordHasher.sha1(userPO.getPassword()));
        }
        this.userMapper.registerUser(userPO);
        return userPO;
    }
}

