/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.NbchatUserRegLoginApi;
import com.tydic.nbchat.user.api.UserLoginLimitApi;
import com.tydic.nbchat.user.api.UserSettingsApi;
import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.BindPhoneNumberReqBO;
import com.tydic.nbchat.user.api.bo.ChangePhoneNumberReqBO;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.auth.AuthUserRsp;
import com.tydic.nbchat.user.api.bo.auth.UserTokenInfo;
import com.tydic.nbchat.user.api.bo.eums.AuthType;
import com.tydic.nbchat.user.api.bo.eums.JoinTenantType;
import com.tydic.nbchat.user.api.bo.login.UserLoginReqBO;
import com.tydic.nbchat.user.api.bo.regist.UserRegistReqBO;
import com.tydic.nbchat.user.api.bo.utils.RedisKeyUtils;
import com.tydic.nbchat.user.api.bo.vip.SuYanAuthCodeReqBO;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.VerifyPhoneCodeBusiService;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.core.config.SuyanConfigProperties;
import com.tydic.nbchat.user.core.utils.EncryptionUtil;
import com.tydic.nbchat.user.core.utils.HttpRequestUtil;
import com.tydic.nbchat.user.core.utils.SuyanSignatureUtils;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.JWTUtils;
import com.tydic.nicc.framework.utils.HttpClientHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class UserAuthBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserAuthBusiService.class);
    private final UserSettingHelper userSettingHelper;
    private final NbchatUserApi nbchatUserApi;
    private final NbchatUserConfigProperties nbchatUserConfigProperties;
    private final RedisHelper redisHelper;
    private final NbchatUserRegLoginApi nbchatUserRegLoginApi;
    private final UserInfoBusiService userInfoBusiService;
    private final VerifyPhoneCodeBusiService verifyPhoneCodeBusiService;
    private final SuyanConfigProperties suyanConfigProperties;
    private final UserSettingsApi userSettingsApi;
    private final UserLoginLimitApi userLoginLimitApi;
    public static String HEADER_TOKEN_KEY = "auth-token";

    public UserAuthBusiService(UserSettingHelper userSettingHelper, NbchatUserApi nbchatUserApi, NbchatUserConfigProperties nbchatUserConfigProperties, RedisHelper redisHelper, NbchatUserRegLoginApi nbchatUserRegLoginApi, UserInfoBusiService userInfoBusiService, VerifyPhoneCodeBusiService verifyPhoneCodeBusiService, SuyanConfigProperties suyanConfigProperties, UserSettingsApi userSettingsApi, UserLoginLimitApi userLoginLimitApi) {
        this.userSettingHelper = userSettingHelper;
        this.nbchatUserApi = nbchatUserApi;
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
        this.redisHelper = redisHelper;
        this.nbchatUserRegLoginApi = nbchatUserRegLoginApi;
        this.userInfoBusiService = userInfoBusiService;
        this.verifyPhoneCodeBusiService = verifyPhoneCodeBusiService;
        this.suyanConfigProperties = suyanConfigProperties;
        this.userSettingsApi = userSettingsApi;
        this.userLoginLimitApi = userLoginLimitApi;
    }

    public Rsp changePhone(ChangePhoneNumberReqBO reqBO) {
        boolean checkCode = this.verifyPhoneCodeBusiService.verifyPhoneCode(reqBO.getPhone(), reqBO.getCode());
        if (!checkCode) {
            return BaseRspUtils.createErrorRsp((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.userInfoBusiService.updatePhone(reqBO.getUserId(), reqBO.getPhone());
        return BaseRspUtils.createSuccessRsp((Object)reqBO.getUserId(), (String)"\u624b\u673a\u53f7\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    public Rsp<AuthUserRsp> login(AuthUserReqBO authUserReqBO, HttpServletRequest request, HttpServletResponse response) {
        log.info("\u7528\u6237\u767b\u5f55-\u53c2\u6570: {}", (Object)authUserReqBO);
        Rsp loginRsp = AuthType.USER_PASS.getCode().equals(authUserReqBO.getAuthType()) ? this.loginByPassword(authUserReqBO) : this.nbchatUserApi.authUser(authUserReqBO);
        if (loginRsp.isSuccess()) {
            NbchatUserInfo userInfo = (NbchatUserInfo)loginRsp.getData();
            return this.auth(userInfo, authUserReqBO.getAuthType(), request, response);
        }
        return loginRsp;
    }

    private Rsp loginByPassword(AuthUserReqBO authUserReqBO) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{authUserReqBO.getUsername(), authUserReqBO.getPassword()})) {
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5f97\u4e3a\u7a7a\uff01");
        }
        UserLoginReqBO loginReqBO = new UserLoginReqBO();
        loginReqBO.setUsername(authUserReqBO.getUsername());
        String password = EncryptionUtil.decryptField(authUserReqBO.getPassword());
        loginReqBO.setPassword(password);
        loginReqBO.setCaptchaCode(authUserReqBO.getCaptchaCode());
        loginReqBO.setLoginIp(authUserReqBO.getLoginIp());
        loginReqBO.setLoginUa(authUserReqBO.getLoginUa());
        return this.nbchatUserRegLoginApi.login(loginReqBO);
    }

    public Rsp bindPhone(BindPhoneNumberReqBO bindPhoneNumber, HttpServletRequest request, HttpServletResponse response) {
        try {
            log.info("\u7528\u6237\u7ed1\u5b9a\u624b\u673a-\u5f00\u59cb:{}", (Object)bindPhoneNumber);
            Rsp authRsp = this.nbchatUserApi.bindPhoneNumber(bindPhoneNumber);
            log.info("\u7528\u6237\u7ed1\u5b9a\u624b\u673a-\u7ed3\u679c:{}", (Object)authRsp);
            if (authRsp.isSuccess()) {
                return this.auth((NbchatUserInfo)authRsp.getData(), bindPhoneNumber.getChannel(), request, response);
            }
            return authRsp;
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u7ed1\u5b9a\u624b\u673a-\u5f02\u5e38:{}", (Object)bindPhoneNumber, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef,\u8bf7\u7a0d\u5019\u91cd\u8bd5\uff01");
        }
    }

    public NbchatUserInfo getUserInfo(String userId, String platform) {
        return this.userInfoBusiService.getUserInfo(userId, platform);
    }

    public NbchatUserInfo getUserInfo(String userId) {
        return this.userInfoBusiService.getUserInfo(userId);
    }

    public String getAuthToken(HttpServletRequest request) {
        Cookie[] cookies;
        log.info("\u83b7\u53d6token\u8bf7\u6c42\u5934={}", (Object)HEADER_TOKEN_KEY);
        String token = request.getHeader(HEADER_TOKEN_KEY);
        if (StringUtils.isBlank((CharSequence)token) && StringUtils.isBlank((CharSequence)(token = request.getParameter(HEADER_TOKEN_KEY))) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(HEADER_TOKEN_KEY)) continue;
                token = cookie.getValue();
                break;
            }
        }
        return token;
    }

    public NbchatUserInfo loginCheck(String sessionKey, HttpServletResponse response) {
        JSONObject jsonObject = (JSONObject)this.redisHelper.get(RedisKeyUtils.getQrcodeKey((String)sessionKey));
        if (ObjectUtils.isEmpty((Object)jsonObject)) {
            return null;
        }
        NbchatUserInfo userInfo = (NbchatUserInfo)jsonObject.get((Object)"userInfo");
        if (ObjectUtils.isNotEmpty((Object)userInfo)) {
            String removedToken;
            Rsp handleResult;
            String authToken = this.authByJwt(userInfo, response);
            String vipType = "1";
            if (userInfo.getVipInfo() != null) {
                vipType = userInfo.getVipInfo().getVipType();
            }
            if ((handleResult = this.userLoginLimitApi.handleUserAuthToken(userInfo.getUserId(), vipType, AuthType.WCHAT_PC.getCode(), authToken)).isSuccess() && StringUtils.isNotBlank((CharSequence)(removedToken = (String)handleResult.getData()))) {
                UserTokenInfo removedUserInfo = new UserTokenInfo();
                removedUserInfo.setUserId(userInfo.getUserId());
                removedUserInfo.setTenantCode(userInfo.getTenantCode());
                log.info("\u540e\u53f0\u5f3a\u5236\u9000\u51fa\u767b\u5f55\u7528\u6237\uff1atenantCode={},userId={},token={}", new Object[]{userInfo.getTenantCode(), userInfo.getUserId(), removedToken});
                this.authLogout(removedUserInfo, removedToken);
            }
        }
        return userInfo;
    }

    public Rsp<NbchatUserInfo> yuwenLoginCheck(String data, HttpServletResponse response) {
        try {
            String url = UriComponentsBuilder.fromHttpUrl((String)this.nbchatUserConfigProperties.getYuewenLoginUrl()).build(new Object[]{data}).toString();
            log.info("\u7ca4\u95ee\u767b\u5f55\u68c0\u67e5-\u5f00\u59cb: {}", (Object)data);
            String res = HttpClientHelper.doGet((String)url, new HashMap(), (int)1000, (int)5000);
            log.info("\u7ca4\u95ee\u767b\u5f55\u68c0\u67e5-\u7ed3\u679c: {}|{}", (Object)data, (Object)res);
            JSONObject jsonObject = JSONObject.parseObject((String)res);
            if (!"200".equals(jsonObject.getString("code"))) {
                return BaseRspUtils.createErrorRsp((String)("\u767b\u5f55\u5931\u8d25\uff1a" + jsonObject.getString("message")));
            }
            String phone = jsonObject.getJSONObject("result").getString("mobileNo");
            Rsp<NbchatUserInfo> userInfoRsp = this.userInfoBusiService.getUserByPhone(phone);
            if (userInfoRsp.isSuccess()) {
                NbchatUserInfo userInfo = (NbchatUserInfo)userInfoRsp.getData();
                this.authByJwt(userInfo, response);
                return BaseRspUtils.createSuccessRsp((Object)userInfo, (String)"\u767b\u5f55\u6210\u529f");
            }
            return BaseRspUtils.createErrorRsp((String)"\u767b\u5f55\u5931\u8d25\uff1a\u7528\u6237\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            log.error("\u7ca4\u95ee\u767b\u5f55\u68c0\u67e5-\u5f02\u5e38: {}", (Object)data, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u767b\u5f55\u5931\u8d25\uff1a\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef,\u8bf7\u7a0d\u5019\u91cd\u8bd5\uff01");
        }
    }

    public void authLogout(UserTokenInfo userInfo, String token) {
        try {
            this.userSettingHelper.cleanUserCache(userInfo.getTenantCode(), userInfo.getUserId(), userInfo.getPlatform());
            String tokenMd5 = MD5Utils.md5Hex((byte[])token.getBytes());
            String key = "nbchat-user:token:expired:" + tokenMd5;
            long exp = TimeUnit.DAYS.toSeconds(3L);
            log.info("\u7528\u6237\u9000\u51fa\u767b\u5f55-\u6807\u8bb0token: {}", (Object)key);
            this.redisHelper.set(key, (Object)System.currentTimeMillis(), exp);
            this.userLoginLimitApi.removeUserAuthToken(userInfo.getUserId(), null, token);
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("token \u8ba1\u7b97md5\u5f02\u5e38:", (Throwable)e);
        }
    }

    public void authLogout(String userId) {
        this.userSettingHelper.removeInfo(userId);
        String cacheKey = "nbchat-user:session:" + userId;
        String sessionKey = (String)this.redisHelper.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)sessionKey)) {
            this.userSettingHelper.cleanUserCache("00000000", userId);
            String key = "nbchat-user:token:expired:" + sessionKey;
            long exp = TimeUnit.DAYS.toSeconds(3L);
            log.info("\u7528\u6237\u9000\u51fa\u767b\u5f55-\u6807\u8bb0token: {}|{}", (Object)userId, (Object)key);
            this.redisHelper.set(key, (Object)System.currentTimeMillis(), exp);
        }
    }

    private Rsp<AuthUserRsp> auth(NbchatUserInfo userInfo, String authType, HttpServletRequest request, HttpServletResponse response) {
        String removedToken;
        Rsp handleResult;
        String pageUrl = request.getParameter("pageUrl");
        pageUrl = StringUtils.isBlank((CharSequence)pageUrl) ? this.nbchatUserConfigProperties.getAuth().getMainPage() : HttpRequestUtil.urlDecode(pageUrl);
        String authToken = this.authByJwt(userInfo, response);
        String vipType = "1";
        if (userInfo.getVipInfo() != null) {
            vipType = userInfo.getVipInfo().getVipType();
        }
        if ((handleResult = this.userLoginLimitApi.handleUserAuthToken(userInfo.getUserId(), vipType, authType, authToken)).isSuccess() && StringUtils.isNotBlank((CharSequence)(removedToken = (String)handleResult.getData()))) {
            UserTokenInfo removedUserInfo = new UserTokenInfo();
            removedUserInfo.setUserId(userInfo.getUserId());
            removedUserInfo.setTenantCode(userInfo.getTenantCode());
            log.info("\u540e\u53f0\u5f3a\u5236\u9000\u51fa\u767b\u5f55\u7528\u6237\uff1atenantCode={},userId={},token={}", new Object[]{userInfo.getTenantCode(), userInfo.getUserId(), removedToken});
            this.authLogout(removedUserInfo, removedToken);
        }
        AuthUserRsp authUserRsp = AuthUserRsp.builder().msg("\u767b\u5f55\u6210\u529f\uff01").redirect(pageUrl).authToken(authToken).status(userInfo.getStatus()).build();
        this.userSettingHelper.cleanUserCache(userInfo.getTenantCode(), userInfo.getUserId());
        log.warn("\u7528\u6237\u8ba4\u8bc1-\u6b63\u5f0f\u7528\u6237\u8df3\u8f6c:{}->{}", (Object)userInfo, (Object)pageUrl);
        return BaseRspUtils.createSuccessRsp((Object)authUserRsp);
    }

    public String authByJwt(NbchatUserInfo userInfo, HttpServletResponse response) {
        String loginInfo = UserTokenInfo.of((String)userInfo.getUserId(), (String)userInfo.getTenantCode());
        Integer sessionTime = this.nbchatUserConfigProperties.getAuth().getSessionTimeout();
        String token = JWTUtils.createJwtToken((String)userInfo.getUserId(), (String)loginInfo, (Long)((long)sessionTime.intValue() * 1000L));
        Cookie cookie = new Cookie(HEADER_TOKEN_KEY, token);
        cookie.setPath("/");
        cookie.setMaxAge(sessionTime.intValue());
        try {
            String cacheKey = "nbchat-user:session:" + userInfo.getUserId();
            this.redisHelper.set(cacheKey, (Object)MD5Utils.md5Hex((byte[])token.getBytes()), (long)sessionTime.intValue());
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("token \u8ba1\u7b97md5\u5f02\u5e38:", (Throwable)e);
        }
        response.addCookie(cookie);
        return token;
    }

    public boolean refreshToken(HttpServletRequest request, HttpServletResponse response) {
        try {
            Date date;
            int expireTime = this.nbchatUserConfigProperties.getRefreshExpireTime() * 1000;
            if (expireTime <= 0) {
                return false;
            }
            String token = this.getAuthToken(request);
            if (StringUtils.isNotBlank((CharSequence)token) && token.length() > 100 && (date = JWTUtils.getExpireDate((String)token)) != null && date.getTime() - System.currentTimeMillis() < (long)expireTime) {
                String loginInfo = JWTUtils.getLoginInfo((String)token);
                log.info("\u89e6\u53d1\u81ea\u52a8\u7eed\u8d39token,token={},date={},login={}", new Object[]{token, date, loginInfo});
                UserTokenInfo tokenInfo = UserTokenInfo.parse((String)loginInfo);
                NbchatUserInfo userInfo = new NbchatUserInfo();
                userInfo.setUserId(tokenInfo.getUserId());
                userInfo.setTenantCode(tokenInfo.getTenantCode());
                String newToken = this.authByJwt(userInfo, response);
                String vipType = "1";
                if (userInfo.getVipInfo() != null) {
                    vipType = userInfo.getVipInfo().getVipType();
                }
                this.userLoginLimitApi.refreshUserAuthToken(userInfo.getUserId(), vipType, token, newToken);
                return true;
            }
        }
        catch (Exception e) {
            log.warn("\u81ea\u52a8\u7eed\u671ftoken\u5931\u8d25: {}", (Object)e.getMessage());
        }
        return false;
    }

    public Rsp<NbchatUserInfo> suyanLoginCheck(SuYanAuthCodeReqBO reqBO, HttpServletResponse response) {
        if (!this.suyanConfigProperties.isEnable()) {
            return BaseRspUtils.createErrorRsp((String)"\u767b\u5f55\u5931\u8d25\uff1a\u672a\u5f00\u542f\u514d\u767b\u5f55\uff01");
        }
        try {
            String phone;
            String error = "";
            if (!this.verifySuyanParm(reqBO, error)) {
                return BaseRspUtils.createErrorRsp((String)error);
            }
            SuyanSignatureUtils signatureUtil = new SuyanSignatureUtils(this.suyanConfigProperties.getAccessKeyId(), this.suyanConfigProperties.getAccessKeySecret());
            String validateSignature = signatureUtil.doSignature(this.suyanConfigProperties.getValidateAuthCode(), "POST", new HashMap<String, Object>());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("csa-request-id", reqBO.getRequestId());
            headers.put("csa-auth-session-id", reqBO.getAuthSessionId());
            JSONObject body = new JSONObject();
            body.put("appId", (Object)this.suyanConfigProperties.getAppId());
            body.put("appSecret", (Object)this.suyanConfigProperties.getAppSecret());
            body.put("authCode", (Object)reqBO.getAuthCode());
            long validateStart = System.currentTimeMillis();
            String validateResult = HttpClientHelper.doPost((String)(this.suyanConfigProperties.getBaseUrl() + validateSignature), headers, (Object)body, (int)5000, (int)10000);
            log.info("\u82cf\u7814\u514d\u767b\u7801\u68c0\u67e5-\u514d\u767b\u7801\u68c0\u9a8c\u7ed3\u679c: {}|\u63a5\u53e3\u8017\u65f6\uff1a{}", (Object)validateResult, (Object)(System.currentTimeMillis() - validateStart));
            if (StringUtils.isEmpty((CharSequence)validateResult)) {
                return BaseRspUtils.createErrorRsp((String)"\u767b\u5f55\u5931\u8d25\uff1a\u6821\u9a8c\u514d\u767b\u7801\u5931\u8d25\uff01");
            }
            JSONObject validateJsonObject = JSONObject.parseObject((String)validateResult);
            if (!"200".equals(validateJsonObject.getString("errorCode"))) {
                return BaseRspUtils.createErrorRsp((String)("\u767b\u5f55\u5931\u8d25\uff1a" + validateJsonObject.getString("errorMessage")));
            }
            HashMap<String, String> userHeaders = new HashMap<String, String>();
            userHeaders.put("csa-request-id", reqBO.getRequestId());
            userHeaders.put("csa-auth-session-id", reqBO.getAuthSessionId());
            String accessToken = validateJsonObject.getJSONObject("body").getString("accessToken");
            userHeaders.put("csa-access-token", accessToken);
            String userSignature = signatureUtil.doSignature(this.suyanConfigProperties.getQueryEcloudComputerUser(), "POST", new HashMap<String, Object>());
            long beginTime = System.currentTimeMillis();
            String userResult = HttpClientHelper.doPost((String)(this.suyanConfigProperties.getBaseUrl() + userSignature), userHeaders, (Object)"{}", (int)5000, (int)10000);
            log.info("\u82cf\u7814\u514d\u767b\u7801\u68c0\u67e5-\u67e5\u8be2\u4e91\u7535\u8111\u7528\u6237\u7ed3\u679c: {}|\u63a5\u53e3\u8017\u65f6\uff1a{}", (Object)userResult, (Object)(System.currentTimeMillis() - beginTime));
            if (StringUtils.isEmpty((CharSequence)userResult)) {
                return BaseRspUtils.createErrorRsp((String)"\u767b\u5f55\u5931\u8d25\uff1a\u83b7\u53d6\u4e91\u7535\u8111\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            JSONObject userJsonObject = JSONObject.parseObject((String)userResult);
            if (!"200".equals(userJsonObject.getString("errorCode"))) {
                return BaseRspUtils.createErrorRsp((String)("\u767b\u5f55\u5931\u8d25\uff1a" + userJsonObject.getString("message")));
            }
            JSONObject bodyJSONObject = userJsonObject.getJSONObject("body");
            if (bodyJSONObject.containsKey((Object)"ecloudUserMobile") && !StringUtils.isEmpty((CharSequence)(phone = bodyJSONObject.getString("ecloudUserMobile")))) {
                String ecloudUserName;
                Rsp<NbchatUserInfo> userInfoRsp = this.userInfoBusiService.getUserByPhone(phone);
                if (userInfoRsp.isSuccess()) {
                    NbchatUserInfo userInfo = (NbchatUserInfo)userInfoRsp.getData();
                    this.authByJwt(userInfo, response);
                    return BaseRspUtils.createSuccessRsp((Object)userInfo, (String)"\u767b\u5f55\u6210\u529f");
                }
                UserRegistReqBO registReqBO = new UserRegistReqBO();
                if (StringUtils.isBlank((CharSequence)registReqBO.getPassword())) {
                    registReqBO.setPassword(String.valueOf(NiccCommonUtil.generateRandomCode((int)8, (int)11)));
                }
                if (!StringUtils.isBlank((CharSequence)(ecloudUserName = bodyJSONObject.getString("ecloudUserName")))) {
                    registReqBO.setName(ecloudUserName);
                }
                registReqBO.setUsername(phone);
                registReqBO.setPhone(phone);
                registReqBO.setTenantCode("00000000");
                registReqBO.setJoinType(JoinTenantType.KE_JIAN_Bang.getCode());
                registReqBO.setPromChannel("suyan");
                registReqBO.setClientUa(reqBO.getClientUa());
                registReqBO.setClientIp(reqBO.getClientIp());
                log.info("\u82cf\u7814\u514d\u767b\u7801\u68c0\u67e5-\u624b\u673a\u53f7\u4e0d\u5b58\u5728-\u6ce8\u518c\u65b0\u7528\u6237-\u6ce8\u518c\u4fe1\u606f:{}", (Object)registReqBO);
                Rsp userRegRsp = this.nbchatUserRegLoginApi.regist(registReqBO);
                if (userRegRsp.isSuccess()) {
                    NbchatUserInfo userInfo = (NbchatUserInfo)userRegRsp.getData();
                    try {
                        this.userSettingsApi.removeUserCache(userInfo.getTenantCode(), userInfo.getUserId());
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65\u5916\u90e8\u7528\u6237\u4fe1\u606f-\u6e05\u9664\u7528\u6237\u7f13\u5b58\u5931\u8d25: {}", (Object)userInfo, (Object)e);
                    }
                    this.authByJwt(userInfo, response);
                    return BaseRspUtils.createSuccessRsp((Object)userInfo, (String)"\u767b\u5f55\u6210\u529f");
                }
            }
            return BaseRspUtils.createErrorRsp((String)"\u514d\u767b\u5f55\u5931\u8d25\uff1a\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u767b\u5f55\uff01");
        }
        catch (Exception e) {
            log.error("\u82cf\u7814\u514d\u767b\u7801\u68c0\u67e5-\u5f02\u5e38: {}", (Object)reqBO, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u767b\u5f55\u5931\u8d25\uff1a\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef,\u8bf7\u7a0d\u5019\u91cd\u8bd5\uff01");
        }
    }

    public boolean verifySuyanParm(SuYanAuthCodeReqBO reqBO, String errorMassage) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getRequestId())) {
            errorMassage = "\u8bf7\u6c42id \u4e0d\u80fd\u4e3a\u7a7a";
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAuthSessionId())) {
            errorMassage = "\u8ba4\u8bc1\u4f1a\u8bddid\u4e0d\u80fd\u4e3a\u7a7a";
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAuthCode())) {
            errorMassage = "\u514d\u767b\u7801\u4e0d\u80fd\u4e3a\u7a7a";
            return false;
        }
        return true;
    }
}

