/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.gray.SysUserGrayRelBO;
import com.tydic.nbchat.user.api.bo.mq.UserRegistContext;
import com.tydic.nbchat.user.core.busi.UserGrayService;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;

@Service
public class UserGrayExpressService {
    private static final Logger log = LoggerFactory.getLogger(UserGrayExpressService.class);
    private final RedisHelper redisHelper;
    private final UserGrayService userGrayService;

    public UserGrayExpressService(RedisHelper redisHelper, UserGrayService userGrayService) {
        this.redisHelper = redisHelper;
        this.userGrayService = userGrayService;
    }

    public void addGrayUserByExpress(UserRegistContext context) {
        Map ruleMap = this.redisHelper.hmget("nbchat-user:gray_rule");
        if (ruleMap != null && !ruleMap.isEmpty()) {
            log.info("\u6dfb\u52a0\u7070\u5ea6\u7528\u6237-\u52a0\u8f7d\u7070\u5ea6\u89c4\u5219[{}]: {}, {}", new Object[]{context.getUserId(), ruleMap, context});
            SpelExpressionParser parser = new SpelExpressionParser();
            EvaluationContext evaluationContext = UserGrayExpressService.getEvaluationContext(context);
            ruleMap.forEach((arg_0, arg_1) -> this.lambda$addGrayUserByExpress$0((ExpressionParser)parser, evaluationContext, context, arg_0, arg_1));
        }
    }

    @NotNull
    private static EvaluationContext getEvaluationContext(UserRegistContext context) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.setVariable("userId", (Object)context.getUserId());
        evaluationContext.setVariable("tenantCode", (Object)context.getTenantCode());
        evaluationContext.setVariable("phone", (Object)context.getPhone());
        evaluationContext.setVariable("joinType", (Object)context.getJoinType());
        evaluationContext.setVariable("promChannel", (Object)context.getPromChannel());
        evaluationContext.setVariable("promId", (Object)context.getPromId());
        return evaluationContext;
    }

    public static void main(String[] args) {
        String grayRule = "#userId.endsWith('0') and #tenantCode == 'default' and #phone.startsWith('1')";
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.setVariable("userId", (Object)"1234567890");
        evaluationContext.setVariable("tenantCode", (Object)"default");
        evaluationContext.setVariable("phone", (Object)"12345678901");
        boolean result = Boolean.TRUE.equals(parser.parseExpression(grayRule).getValue((EvaluationContext)evaluationContext, Boolean.class));
        System.out.println("\u7070\u5ea6\u89c4\u5219\u6d4b\u8bd5\u7ed3\u679c: " + result);
    }

    private /* synthetic */ void lambda$addGrayUserByExpress$0(ExpressionParser parser, EvaluationContext evaluationContext, UserRegistContext context, Object key, Object value) {
        String grayCode = String.valueOf(key);
        String grayRule = String.valueOf(value);
        try {
            boolean result = Boolean.TRUE.equals(parser.parseExpression(grayRule).getValue(evaluationContext, Boolean.class));
            log.info("\u6dfb\u52a0\u7070\u5ea6\u7528\u6237-\u6267\u884c\u89c4\u5219[{}]: result = {}, {} -> {}", new Object[]{result, context.getUserId(), grayCode, grayRule});
            if (result) {
                SysUserGrayRelBO request = new SysUserGrayRelBO();
                request.setTargetTenant(context.getTenantCode());
                request.setUserId(context.getUserId());
                request.setTargetUid(context.getUserId());
                request.setGrayCode(grayCode);
                request.setGrayEnable(EntityValidType.NORMAL.getCode());
                request.setStartTime(new Date());
                request.setEndTime(DateTimeUtil.DateAddYear((int)1));
                request.setRemark(grayRule);
                this.userGrayService.saveGray(request);
            }
        }
        catch (Exception e) {
            log.warn("\u6dfb\u52a0\u7070\u5ea6\u7528\u6237-\u6267\u884c\u89c4\u5219\u5f02\u5e38[{}]: {}, {}", new Object[]{context.getUserId(), grayCode, grayRule, e});
        }
    }
}

