/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.gray.SysUserGrayRelBO;
import com.tydic.nbchat.user.mapper.SysUserGrayRelMapper;
import com.tydic.nbchat.user.mapper.po.SysUserGrayRel;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class UserGrayService {
    private static final Logger log = LoggerFactory.getLogger(UserGrayService.class);
    @Resource
    SysUserGrayRelMapper sysUserGrayRelMapper;
    private final String gray_key_prefix = "nbchat-user:gray:";
    private final RedisHelper redisHelper;

    public UserGrayService(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    public RspList<SysUserGrayRelBO> grayList(SysUserGrayRelBO request) {
        SysUserGrayRel cond = new SysUserGrayRel();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        List grayRels = this.sysUserGrayRelMapper.selectAll(cond);
        ArrayList res = new ArrayList();
        NiccCommonUtil.copyList((List)grayRels, res, SysUserGrayRelBO.class);
        return BaseRspUtils.createSuccessRspList(res);
    }

    public Map<String, Object> getGrayMap(String tenantCode, String uid) {
        try {
            RspList<SysUserGrayRelBO> rspList = this.userGray(tenantCode, uid);
            return rspList.getRows().stream().collect(Collectors.toMap(SysUserGrayRelBO::getGrayCode, SysUserGrayRelBO::getGrayEnable, (existing, replacement) -> existing));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7070\u5ea6\u7528\u6237\u5173\u7cfb\u5f02\u5e38: {}|{}", new Object[]{tenantCode, uid, e});
            return Map.of();
        }
    }

    public RspList<SysUserGrayRelBO> userGray(String tenantCode, String uid) {
        String key = "nbchat-user:gray:" + tenantCode + ":" + uid;
        ArrayList list = (ArrayList)this.redisHelper.get(key);
        if (ObjectUtils.allNull((Object[])new Object[]{list})) {
            list = new ArrayList();
            List<SysUserGrayRel> grayRels = this.queryList(tenantCode, uid);
            if (CollectionUtils.isNotEmpty(grayRels)) {
                NiccCommonUtil.copyList(grayRels, list, SysUserGrayRelBO.class);
                this.redisHelper.set(key, list, 86400L);
            }
        }
        return BaseRspUtils.createSuccessRspList((List)list);
    }

    public Rsp saveGray(SysUserGrayRelBO request) {
        SysUserGrayRel po = new SysUserGrayRel();
        BeanUtils.copyProperties((Object)request, (Object)po);
        po.setUserId(request.getTargetUid());
        po.setTenantCode(request.getTargetTenant());
        po.setCreateUser(request.getUserId());
        if (ObjectUtils.isEmpty((Object)po.getId())) {
            this.sysUserGrayRelMapper.insertSelective(po);
        } else {
            this.sysUserGrayRelMapper.update(po);
        }
        this.refreshGrayCache(po.getTenantCode(), po.getUserId());
        return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private void refreshGrayCache(String tenantCode, String uid) {
        String key = "nbchat-user:gray:" + tenantCode + ":" + uid;
        this.redisHelper.del(new String[]{key});
        this.userGray(tenantCode, uid);
    }

    private List<SysUserGrayRel> queryList(String tenantCode, String uid) {
        return this.sysUserGrayRelMapper.selectEnableList(tenantCode, uid);
    }
}

