/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.UserRoleDeptApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.UserBO;
import com.tydic.nbchat.user.api.bo.role.SubSystemInfo;
import com.tydic.nbchat.user.api.bo.utils.PhoneNumberUtils;
import com.tydic.nbchat.user.core.busi.UserVipService;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoBusiService.class);
    @Resource
    private UserMapper userMapper;
    private final UserVipService userVipService;
    private final UserSettingHelper userSettingHelper;
    private final UserRoleDeptApi userRoleDeptApi;

    public UserInfoBusiService(UserVipService userVipService, UserSettingHelper userSettingHelper, UserRoleDeptApi userRoleDeptApi) {
        this.userVipService = userVipService;
        this.userSettingHelper = userSettingHelper;
        this.userRoleDeptApi = userRoleDeptApi;
    }

    public void updatePhone(String userId, String phone) {
        UserPO userPO = new UserPO();
        userPO.setUserId(userId);
        userPO.setPhone(phone);
        userPO.setUpdatedTime(new Date());
        UserPO userInfo = this.userMapper.findUserByMobile(phone);
        if (userInfo != null && !userInfo.getUserId().equals(userId)) {
            log.error("\u66f4\u65b0\u624b\u673a\u53f7\u5931\u8d25-\u624b\u673a\u53f7\u5df2\u88ab\u5176\u4ed6\u8d26\u6237\u4f7f\u7528: {}|{}", (Object)userInfo.getUserId(), (Object)phone);
            return;
        }
        this.userSettingHelper.removeInfo(userId);
        this.userMapper.updateById(userPO);
    }

    private void parserSettingPlatformTenant(NbchatUserInfo userInfo, String platform) {
        JSONObject param;
        String tenantCode;
        Map<Object, Object> settingMap = this.userSettingHelper.loadSetting(userInfo.getUserId());
        userInfo.setSettings(settingMap);
        if (StringUtils.isNotBlank((CharSequence)platform) && settingMap.containsKey(platform) && settingMap.get(platform) instanceof JSONObject && StringUtils.isNotBlank((CharSequence)(tenantCode = (param = (JSONObject)settingMap.get(platform)).getString("tenantCode")))) {
            userInfo.setTenantCode(tenantCode);
        }
    }

    private void packageUserInfo(NbchatUserInfo userInfo) {
        List<String> tenants = this.userMapper.getTenantCodeList(userInfo.getUserId());
        if (CollectionUtils.isEmpty((Collection)tenants)) {
            tenants = Collections.singletonList(userInfo.getTenantCode());
        }
        userInfo.setTenantCodeList((List)tenants);
        this.updateCurrentSubsystem(userInfo);
        this.userSettingHelper.cacheInfo(userInfo);
    }

    public NbchatUserInfo getUserInfo(String userId) {
        return this.getUserInfo(userId, "");
    }

    public void reloadUserInfo(String userId, String subsystem) {
        UserPO userPO = this.userMapper.findUserByUserId(userId);
        NbchatUserInfo userInfo = new NbchatUserInfo();
        BeanUtils.copyProperties((Object)userPO, (Object)userInfo);
        userInfo.setTenantCode(subsystem);
        userInfo.setRegTime(userPO.getCreatedTime());
        this.parserSettingPlatformTenant(userInfo, "");
        this.packageUserInfo(userInfo);
        this.userSettingHelper.cacheInfo(userInfo);
    }

    public NbchatUserInfo getUserInfo(String userId, String platform) {
        NbchatUserInfo userInfo = this.userSettingHelper.getUserInfo(userId);
        if (userInfo == null) {
            UserPO userPO = this.userMapper.findUserByUserId(userId);
            if (userPO != null) {
                userInfo = new NbchatUserInfo();
                BeanUtils.copyProperties((Object)userPO, (Object)userInfo);
                userInfo.setRegTime(userPO.getCreatedTime());
                this.parserSettingPlatformTenant(userInfo, platform);
                this.packageUserInfo(userInfo);
                return userInfo;
            }
        } else {
            this.parserSettingPlatformTenant(userInfo, platform);
            this.updateCurrentSubsystem(userInfo);
        }
        return userInfo;
    }

    private void updateCurrentSubsystem(NbchatUserInfo userInfo) {
        Rsp tmoSystem;
        LinkedHashMap<String, SubSystemInfo> systemInfoMap = new LinkedHashMap<String, SubSystemInfo>();
        if (userInfo.getTenantCodeList().contains("00000TMO") && (tmoSystem = this.userRoleDeptApi.getUserSubSysInfo(userInfo.getUserId(), "00000TMO")).isSuccess()) {
            systemInfoMap.put("00000TMO", (SubSystemInfo)tmoSystem.getData());
        }
        userInfo.setSubSystems(systemInfoMap);
        Rsp systemInfoRsp = this.userRoleDeptApi.getUserSubSysInfo(userInfo.getUserId(), userInfo.getTenantCode());
        if (systemInfoRsp.isSuccess()) {
            systemInfoMap.put(userInfo.getTenantCode(), (SubSystemInfo)systemInfoRsp.getData());
        }
        userInfo.setSubSystems(systemInfoMap);
        userInfo.setVipInfo(this.userVipService.getVipInfoBO(userInfo.getTenantCode(), userInfo.getUserId()));
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp updateById(UserBO userBO) {
        log.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f: {}", (Object)userBO);
        UserPO userPO = new UserPO();
        BeanUtils.copyProperties((Object)userBO, (Object)userPO);
        userPO.setTenantCode(userBO.getTargetTenant());
        userPO.setUpdatedTime(new Date());
        userPO.setUpdatedBy(userBO.getUserId());
        log.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f-\u67e5\u8be2\u7528\u6237\u79df\u6237");
        List tenantCodeList = this.userMapper.selectTenantCodeByUserId(userBO.getUserId());
        if (CollectionUtils.isEmpty((Collection)tenantCodeList)) {
            log.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f-\u7528\u6237\u79df\u6237\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u79df\u6237\u4e3a\u7a7a");
        }
        if (!tenantCodeList.contains(userPO.getTenantCode())) {
            log.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f-\u8be5\u7528\u6237\u4e0d\u5c5e\u4e8e\u8be5\u79df\u6237");
            return BaseRspUtils.createErrorRsp((String)"\u6ca1\u6709\u79df\u6237\u6743\u9650");
        }
        this.userMapper.updateById(userPO);
        this.userSettingHelper.removeInfo(userBO.getUserId());
        return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u66f4\u65b0\u6210\u529f");
    }

    public Rsp<NbchatUserInfo> getUserByPhone(String phone) {
        if (StringUtils.isEmpty((CharSequence)phone) || !PhoneNumberUtils.validPhoneNumber((String)phone)) {
            log.error("\u8f93\u5165\u7684\u624b\u673a\u53f7\u4e0d\u5408\u6cd5: {}", (Object)phone);
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u5408\u6cd5\u7684\u624b\u673a\u53f7");
        }
        UserPO user = this.userMapper.findUserByMobile(phone);
        if (user != null) {
            NbchatUserInfo userInfo = new NbchatUserInfo();
            BeanUtils.copyProperties((Object)user, (Object)userInfo);
            userInfo.setRegTime(user.getCreatedTime());
            this.parserSettingPlatformTenant(userInfo, "");
            this.packageUserInfo(userInfo);
            return BaseRspUtils.createSuccessRsp((Object)userInfo, (String)"\u67e5\u8be2\u6210\u529f");
        }
        return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5931\u8d25");
    }

    public NbchatUserInfo getUserBaseInfo(String userId) {
        UserPO userPO = this.userMapper.findUserByUserId(userId);
        if (userPO == null) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728: uid = " + userId);
        }
        NbchatUserInfo userInfo = new NbchatUserInfo();
        BeanUtils.copyProperties((Object)userPO, (Object)userInfo);
        return userInfo;
    }

    public RspList<NbchatUserInfo> getUserInfoList(List<String> userIdList) {
        List list = this.userMapper.selectByUserIdList(userIdList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25:\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ArrayList userInfoList = new ArrayList();
        NiccCommonUtil.copyList((List)list, userInfoList, NbchatUserInfo.class);
        return BaseRspUtils.createSuccessRspList(userInfoList);
    }
}

