/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.JoinTenantType;
import com.tydic.nbchat.user.api.bo.eums.UserVipStatusType;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRechargeReqBO;
import com.tydic.nbchat.user.core.busi.ScoreRechargeService;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nicc.common.nbchat.emus.LoginEventType;
import com.tydic.nicc.common.nbchat.msg.UserLoginEventContext;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserLoginEventService {
    private static final Logger log = LoggerFactory.getLogger(UserLoginEventService.class);
    @Resource
    private UserMapper userMapper;
    private final KKMqProducerHelper kkMqProducerHelper;
    private final UserInfoBusiService userInfoBusiService;
    private final ScoreRechargeService scoreRechargeService;

    public UserLoginEventService(KKMqProducerHelper kkMqProducerHelper, UserInfoBusiService userInfoBusiService, ScoreRechargeService scoreRechargeService) {
        this.kkMqProducerHelper = kkMqProducerHelper;
        this.userInfoBusiService = userInfoBusiService;
        this.scoreRechargeService = scoreRechargeService;
    }

    public void sengLoginSwitchTenant(String userId, String authType, String loginIp, String loginUa, String switchTenant) {
        NbchatUserInfo userInfo = this.userInfoBusiService.getUserInfo(userId);
        this.sendLoginEvent(userInfo, authType, loginIp, loginUa, "", "", switchTenant);
    }

    public void sendLoginEvent(NbchatUserInfo userInfo, String authType, String loginIp, String loginUa, String loginClient, String loginType) {
        this.sendLoginEvent(userInfo, authType, loginIp, loginUa, loginType, loginClient, "");
    }

    private void firstLoginGiveDou(NbchatUserInfo userInfo) {
        try {
            if ("00000000".equals(userInfo.getTenantCode())) {
                Date startTime = DateTimeUtil.getFirstDayOfMonth((int)0);
                startTime = DateTimeUtil.createTime((Date)startTime, (int)0, (int)0, (int)0);
                Date endTime = new Date();
                int loginCount = this.userMapper.selectLoginCount(userInfo.getUserId(), startTime, endTime);
                if (loginCount == 0) {
                    UserBalanceRechargeReqBO recharge = new UserBalanceRechargeReqBO();
                    recharge.setTenantCode(userInfo.getTenantCode());
                    recharge.setUserId(userInfo.getUserId());
                    recharge.setScore(Integer.valueOf(200));
                    Date expire = DateTimeUtil.getLastDayOfMonth((int)1);
                    expire = DateTimeUtil.createTime((Date)expire, (int)23, (int)59, (int)58);
                    recharge.setExpireTime(expire);
                    recharge.setRemark("\u6bcf\u6708\u9996\u6b21\u767b\u5f55\u8d60\u9001");
                    this.scoreRechargeService.recharge(recharge);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u767b\u5f55\u4e8b\u4ef6-\u9996\u6b21\u767b\u5f55\u8d60\u9001\u5f02\u5e38: {}", (Object)userInfo, (Object)e);
        }
    }

    public void sendLoginEvent(NbchatUserInfo userInfo, String authType, String loginIp, String loginUa, String loginType, String loginClient, String switchTenant) {
        try {
            log.info("\u7528\u6237\u767b\u5f55\u4e8b\u4ef6: {}|{}", (Object)userInfo.getTenantCode(), (Object)userInfo.getUserId());
            UserLoginEventContext context = UserLoginEventContext.builder().eventType(LoginEventType.LOGIN.getCode()).loginIp(loginIp).loginUa(loginUa).switchTenant(switchTenant).loginType(loginType).authType(authType).loginClient(JoinTenantType.getCodeByName((String)loginClient)).eventTime(new Date()).build();
            context.setTenantCode(userInfo.getTenantCode());
            context.setUserId(userInfo.getUserId());
            context.setLoginTime(new Date());
            context.setRegTime(userInfo.getRegTime());
            if (userInfo.getVipInfo() != null) {
                context.setVipStatus(userInfo.getVipInfo().getVipStatus());
                context.setVipType(userInfo.getVipInfo().getVipType());
            } else {
                context.setVipStatus(UserVipStatusType.FREE.getCode());
                context.setVipType("");
            }
            this.kkMqProducerHelper.sendMsg("NBCHAT_USER_LOGIN_EVENT", (Object)context);
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u767b\u5f55\u4e8b\u4ef6-\u6d88\u606f\u5f02\u5e38: {}", (Object)userInfo, (Object)e);
        }
    }
}

