/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserLoginLockBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserLoginLockBusiService.class);
    private final RedisHelper redisHelper;

    public UserLoginLockBusiService(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    public long addPwdErrorCount(String username) {
        String key = "nbchat-user:pwd_error_count:" + username;
        long count = this.redisHelper.incr(key, 1L);
        log.info("\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55-\u5bc6\u7801\u9519\u8bef\u8ba1\u6570:{}|{}", (Object)username, (Object)count);
        this.redisHelper.expire(key, 600L);
        if (count >= 3L) {
            this.lockAccount(username, 1800L);
        }
        return count;
    }

    public boolean hasLockAccount(String username) {
        String key = "nbchat-user:account_lock:" + username;
        return this.redisHelper.hasKey(key);
    }

    public String getLockReason(String username) {
        String key = "nbchat-user:account_lock:" + username;
        return (String)this.redisHelper.get(key);
    }

    public void lockAccount(String username, Long lockTime) {
        this.lockAccount(username, lockTime, "\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u8d26\u6237\u5df2\u9501\u5b9a");
    }

    public void lockAccount(String username, Long lockTime, String reason) {
        String key = "nbchat-user:account_lock:" + username;
        if (lockTime == null) {
            this.redisHelper.set(key, (Object)reason);
        } else {
            this.redisHelper.set(key, (Object)reason, lockTime.longValue());
        }
    }

    public void unlockAccount(String username) {
        String key = "nbchat-user:account_lock:" + username;
        this.redisHelper.del(new String[]{key});
    }
}

