/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.context.UserScoreChangeContext;
import com.tydic.nbchat.user.api.bo.trade.UserTradeResult;
import com.tydic.nbchat.user.mapper.po.NbchatUserVip;
import com.tydic.nicc.common.nbchat.msg.UserMakeEventContext;
import com.tydic.nicc.common.nbchat.msg.UserVipChangeContext;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserMakeEventSender {
    private static final Logger log = LoggerFactory.getLogger(UserMakeEventSender.class);
    private final KKMqProducerHelper kkMqProducerHelper;

    public UserMakeEventSender(KKMqProducerHelper kkMqProducerHelper) {
        this.kkMqProducerHelper = kkMqProducerHelper;
    }

    public void sendMakeEvent(String tenantCode, String userId, String eventType, Integer successCount, Integer errorCount) {
        UserMakeEventContext eventContext = UserMakeEventContext.builder().status(Integer.valueOf(1)).eventTime(new Date()).build();
        eventContext.setTenantCode(tenantCode);
        eventContext.setUserId(userId);
        eventContext.setEventType(eventType);
        eventContext.setSuccessCount(successCount);
        eventContext.setErrorCount(errorCount);
        if (errorCount != null && errorCount > 0) {
            eventContext.setStatus(Integer.valueOf(0));
        }
        try {
            log.info("\u7528\u6237\u521b\u4f5c-\u63a8\u9001\u4e8b\u4ef6\u6d88\u606f: {}", (Object)eventContext);
            this.kkMqProducerHelper.sendMsg("NBCHAT_USER_MAKE_EVENT", (Object)eventContext);
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u521b\u4f5c-\u63a8\u9001\u4e8b\u4ef6\u6d88\u606f-\u5f02\u5e38: {}", (Object)eventContext, (Object)e);
        }
    }

    public void sendVipChangeEvent(String eventType, NbchatUserVip vip, Integer cycle, Integer days) {
        UserVipChangeContext eventContext = UserVipChangeContext.builder().eventType(eventType).createTime(new Date()).cycle(cycle).days(days).vipType(vip.getVipType()).vipStatus(vip.getVipStatus()).vipStart(vip.getVipStart()).vipEnd(vip.getVipEnd()).vipDesc(vip.getVipDesc()).build();
        eventContext.setTenantCode(vip.getTenantCode());
        eventContext.setUserId(vip.getUserId());
        try {
            log.info("\u7528\u6237VIP\u53d8\u66f4-\u63a8\u9001\u4e8b\u4ef6\u6d88\u606f: {}", (Object)eventContext);
            this.kkMqProducerHelper.sendMsg("NBCHAT_USER_VIP_CHANGE", (Object)eventContext);
        }
        catch (Exception e) {
            log.error("\u7528\u6237VIP\u53d8\u66f4-\u63a8\u9001\u4e8b\u4ef6\u6d88\u606f-\u5f02\u5e38: {}", (Object)eventContext, (Object)e);
        }
    }

    public void sendScoreChangeEvent(UserTradeResult tradeResult, Integer balance) {
        try {
            UserScoreChangeContext context = new UserScoreChangeContext();
            context.setTradeId(tradeResult.getTradeId());
            context.setUserId(tradeResult.getUserId());
            context.setTenantCode(tradeResult.getTenantCode());
            context.setScoreBalance(balance);
            context.setScoreChange(tradeResult.getScore());
            log.info("\u7528\u6237\u79ef\u5206\u53d8\u66f4-\u63a8\u9001\u4e8b\u4ef6\u6d88\u606f: {}", (Object)context);
            this.kkMqProducerHelper.sendMsg("NBCHAT_USER_SCORE_CHANGE", (Object)context);
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u79ef\u5206\u53d8\u66f4-\u63a8\u9001\u4e8b\u4ef6\u6d88\u606f-\u5f02\u5e38: {}", (Object)tradeResult, (Object)e);
        }
    }
}

