/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.AuthType;
import com.tydic.nbchat.user.api.bo.login.UserLoginReqBO;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.UserLoginEventService;
import com.tydic.nbchat.user.core.busi.UserLoginLockBusiService;
import com.tydic.nbchat.user.core.config.CaptchaConfigProperties;
import com.tydic.nbchat.user.core.utils.KaptchaHelper;
import com.tydic.nbchat.user.core.utils.PasswordHasher;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class UserPasswordLoginBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserPasswordLoginBusiService.class);
    private final UserLoginLockBusiService userLoginLockBusiService;
    private final KaptchaHelper kaptchaHelper;
    private final CaptchaConfigProperties captchaConfigProperties;
    private final UserLoginEventService userLoginEventService;
    private final UserInfoBusiService userInfoBusiService;
    @Resource
    private UserMapper userMapper;

    public UserPasswordLoginBusiService(UserLoginLockBusiService userLoginLockBusiService, KaptchaHelper kaptchaHelper, CaptchaConfigProperties captchaConfigProperties, UserLoginEventService userLoginEventService, UserInfoBusiService userInfoBusiService) {
        this.userLoginLockBusiService = userLoginLockBusiService;
        this.kaptchaHelper = kaptchaHelper;
        this.captchaConfigProperties = captchaConfigProperties;
        this.userLoginEventService = userLoginEventService;
        this.userInfoBusiService = userInfoBusiService;
    }

    public Rsp passwordLogin(UserLoginReqBO loginReqBO) {
        log.info("\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55:{}", (Object)loginReqBO);
        if (this.userLoginLockBusiService.hasLockAccount(loginReqBO.getUsername())) {
            return BaseRspUtils.createErrorRsp((String)"\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        if (this.captchaConfigProperties.getEnable().booleanValue() && (StringUtils.isBlank((CharSequence)loginReqBO.getCaptchaCode()) || !this.kaptchaHelper.checkCaptchaCode(loginReqBO.getCaptchaCode()))) {
            log.info("\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55-\u9a8c\u8bc1\u7801\u9519\u8bef:{}|{}", (Object)loginReqBO.getUsername(), (Object)loginReqBO.getCaptchaCode());
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u586b\u5199\u6b63\u786e\u9a8c\u8bc1\u7801!");
        }
        UserPO user = this.userMapper.findUserByUserNamePassword(loginReqBO.getUsername(), PasswordHasher.sha1(loginReqBO.getPassword()));
        if (user == null) {
            log.info("\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55-\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef:{}|{}", (Object)loginReqBO.getUsername(), (Object)PasswordHasher.sha1(loginReqBO.getPassword()));
            long count = this.userLoginLockBusiService.addPwdErrorCount(loginReqBO.getUsername());
            if (count == 3L) {
                return BaseRspUtils.createErrorRsp((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            return BaseRspUtils.createErrorRsp((String)("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u5269\u4f59\u5c1d\u8bd5\u6b21\u6570:" + (3L - count)));
        }
        NbchatUserInfo nbchatUserInfo = new NbchatUserInfo();
        BeanUtils.copyProperties((Object)user, (Object)nbchatUserInfo);
        UserPO update = new UserPO();
        update.setUserId(user.getUserId());
        update.setUpdatedTime(new Date());
        this.userMapper.updateById(update);
        NbchatUserInfo userInfo = this.userInfoBusiService.getUserInfo(user.getUserId());
        this.userLoginEventService.sendLoginEvent(userInfo, AuthType.USER_PASS.getCode(), loginReqBO.getLoginIp(), loginReqBO.getLoginUa(), loginReqBO.getLoginClient(), "");
        this.userLoginLockBusiService.unlockAccount(loginReqBO.getUsername());
        return BaseRspUtils.createSuccessRsp((Object)userInfo, (String)"\u767b\u5f55\u6210\u529f");
    }
}

