/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.BindPhoneNumberReqBO;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.JoinTenantType;
import com.tydic.nbchat.user.api.bo.eums.UserRegSourceEnum;
import com.tydic.nbchat.user.api.bo.mq.UserRegistContext;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.VerifyPhoneCodeBusiService;
import com.tydic.nbchat.user.core.busi.WchatApiHelper;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.UserBindRecordMapper;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.WxUserMapper;
import com.tydic.nbchat.user.mapper.po.UserBindRecord;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nbchat.user.mapper.po.WxUserPO;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserPhoneBindBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserPhoneBindBusiService.class);
    private final WchatApiHelper wchatApiHelper;
    private final VerifyPhoneCodeBusiService verifyPhoneCodeBusiService;
    private final UserSettingHelper userSettingHelper;
    private final UserInfoBusiService userInfoBusiService;
    @Resource
    private WxUserMapper wxUserMapper;
    @Resource
    private UserBindRecordMapper userBindRecordMapper;
    @Resource
    private UserMapper userMapper;

    public UserPhoneBindBusiService(WchatApiHelper wchatApiHelper, VerifyPhoneCodeBusiService verifyPhoneCodeBusiService, UserSettingHelper userSettingHelper, UserInfoBusiService userInfoBusiService) {
        this.wchatApiHelper = wchatApiHelper;
        this.verifyPhoneCodeBusiService = verifyPhoneCodeBusiService;
        this.userSettingHelper = userSettingHelper;
        this.userInfoBusiService = userInfoBusiService;
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp bindPhoneByMPCode(BindPhoneNumberReqBO reqBO) {
        log.info("\u5c0f\u7a0b\u5e8f\u7ed1\u5b9a\u624b\u673a\u53f7-\u5f00\u59cb: {}", (Object)reqBO);
        String phoneNum = this.wchatApiHelper.queryPhone(reqBO.getCode());
        if (StringUtils.isEmpty((CharSequence)phoneNum)) {
            log.error("\u7ed1\u5b9a\u624b\u673a\u53f7-\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25: {}", (Object)reqBO);
            return BaseRspUtils.createErrorRsp((String)"\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25");
        }
        reqBO.setPhone(phoneNum);
        return this.bind(reqBO);
    }

    @MethodParamVerifyEnable
    @Transactional(rollbackFor={Exception.class})
    public Rsp bindPhoneNumber(BindPhoneNumberReqBO reqBO) {
        log.info("\u7ed1\u5b9a\u624b\u673a\u53f7-\u5f00\u59cb: {}", (Object)reqBO);
        if (!this.verifyPhoneCodeBusiService.verifyPhoneCode(reqBO.getPhone(), reqBO.getCode())) {
            log.warn("\u7ed1\u5b9a\u624b\u673a\u53f7-\u9a8c\u8bc1\u7801\u9519\u8bef: {}", (Object)reqBO);
            return BaseRspUtils.createErrorRsp((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return this.bind(reqBO);
    }

    public Rsp bind(BindPhoneNumberReqBO reqBO) {
        UserPO user = this.userMapper.findUserByUserId(reqBO.getUserId());
        if (StringUtils.isNotBlank((CharSequence)user.getPhone())) {
            log.info("\u7ed1\u5b9a\u624b\u673a\u53f7-\u7528\u6237\u5df2\u7ed1\u5b9a\u624b\u673a\u53f7: {}", (Object)user);
            return BaseRspUtils.createErrorRsp((String)"\u8be5\u5fae\u4fe1\u53f7\u5df2\u7ecf\u7ed1\u5b9a\u624b\u673a\u53f7");
        }
        String userId = reqBO.getUserId();
        String phone = reqBO.getPhone();
        String openId = reqBO.getOpenId();
        UserPO phoneUser = this.userMapper.findUserByMobile(phone);
        if (phoneUser == null) {
            this.updateUser(userId, phone, null, openId, reqBO.getInviteCode());
            log.info("\u7ed1\u5b9a\u624b\u673a\u53f7-\u7ed1\u5b9a\u6210\u529f: {}|{}", (Object)phone, (Object)userId);
            UserRegistContext context = new UserRegistContext();
            context.setPhone(phone);
            context.setUserId(userId);
            context.setTenantCode(user.getTenantCode());
            context.setName(user.getName());
            context.setCreatedTime(user.getCreatedTime());
            context.setJoinType(JoinTenantType.REGIST.getCode());
            context.setUserRealityName(user.getName());
            context.setPhone(phone);
            String regSource = reqBO.getClientUa().contains("kejian365") ? UserRegSourceEnum.PC_CLIENT.getCode() : (reqBO.getClientUa().contains("XWEB") ? UserRegSourceEnum.WECHAT_MINI_PROGRAM.getCode() : UserRegSourceEnum.WEB_CLIENT.getCode());
            context.setRegSource(regSource);
            context.setPromKey(reqBO.getPromKey());
            context.setPromId(reqBO.getPromId());
            context.setPromChannel(reqBO.getPromChannel());
            context.setInviteCode(reqBO.getInviteCode());
            context.setClientUa(reqBO.getClientUa());
            context.setClientIp(reqBO.getClientIp());
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRegSource())) {
                context.setJoinType(JoinTenantType.getCodeByName((String)reqBO.getRegSource()));
                log.info("\u7528\u6237\u8ba4\u8bc1-\u6ce8\u518c\u6765\u6e90: {}-\u7528\u6237\u4fe1\u606f:{}", (Object)reqBO.getRegSource(), (Object)context);
            }
            this.userSettingHelper.userRegistNotice(context);
        } else {
            if (StringUtils.isNotBlank((CharSequence)phoneUser.getUnionId())) {
                log.warn("\u7ed1\u5b9a\u624b\u673a\u53f7-\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5fae\u4fe1\u53f7: {}", (Object)phoneUser);
                return BaseRspUtils.createErrorRsp((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ecf\u7ed1\u5b9a\u5fae\u4fe1\u53f7");
            }
            if (StringUtils.isBlank((CharSequence)user.getUnionId())) {
                log.warn("\u7ed1\u5b9a\u624b\u673a\u53f7-\u5fae\u4fe1\u53f7\u672a\u7ed1\u5b9aunionId: {}", (Object)user);
            }
            log.info("\u7ed1\u5b9a\u624b\u673a\u53f7-\u5408\u5e76\u8d26\u53f7: {}->{}", (Object)userId, (Object)phoneUser.getUserId());
            this.updateUser(phoneUser.getUserId(), null, user.getUnionId(), openId, null);
            this.userMapper.deleteById(userId);
            UserBindRecord userBindRecord = new UserBindRecord();
            String id = IdWorker.nextAutoIdStr();
            userBindRecord.setId(id);
            userBindRecord.setUserId(phoneUser.getUserId());
            userBindRecord.setUserIdOld(user.getUserId());
            userBindRecord.setPhone(phone);
            userBindRecord.setTenantCode(phoneUser.getTenantCode());
            userBindRecord.setTenantCodeOld(user.getTenantCode());
            userBindRecord.setCreateTime(new Date());
            this.userBindRecordMapper.insert(userBindRecord);
            log.info("\u7ed1\u5b9a\u624b\u673a\u53f7-\u8bb0\u5f55\u7528\u6237\u7ed1\u5b9a\u624b\u673a\u53f7: {}", (Object)userBindRecord);
            this.userSettingHelper.removeInfo(userId);
            userId = phoneUser.getUserId();
        }
        NbchatUserInfo userInfo = this.userInfoBusiService.getUserInfo(userId);
        this.userSettingHelper.removeInfo(userId);
        log.info("\u7ed1\u5b9a\u624b\u673a\u53f7-\u8d26\u53f7\u5408\u5e76\u6210\u529f: {}", (Object)userInfo);
        return BaseRspUtils.createSuccessRsp((Object)userInfo, (String)"\u7ed1\u5b9a\u6210\u529f");
    }

    private void updateUser(String userId, String phone, String unionId, String openId, String inviteCode) {
        UserPO update = new UserPO();
        update.setUserId(userId);
        update.setPhone(phone);
        update.setUpdatedTime(new Date());
        update.setUnionId(unionId);
        log.info("\u7ed1\u5b9a\u624b\u673a\u53f7-\u66f4\u65b0\u7528\u6237\u8868: {}", (Object)update);
        this.userMapper.updateById(update);
        if (StringUtils.isNotBlank((CharSequence)openId)) {
            WxUserPO updateWx = new WxUserPO();
            updateWx.setUserId(userId);
            updateWx.setPhone(phone);
            updateWx.setUpdatedTime(new Date());
            updateWx.setOpenId(openId);
            log.info("\u7ed1\u5b9a\u624b\u673a\u53f7-\u66f4\u65b0\u5fae\u4fe1\u7528\u6237\u8868: {}", (Object)update);
            this.wxUserMapper.update(updateWx);
        }
    }
}

