/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.JoinTenantType;
import com.tydic.nbchat.user.api.bo.eums.UserRegSourceEnum;
import com.tydic.nbchat.user.api.bo.eums.UserStatusType;
import com.tydic.nbchat.user.api.bo.exception.UserLoginException;
import com.tydic.nbchat.user.api.bo.mq.UserRegistContext;
import com.tydic.nbchat.user.api.bo.utils.PhoneNumberUtils;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.UserLoginLockBusiService;
import com.tydic.nbchat.user.core.busi.VerifyPhoneCodeBusiService;
import com.tydic.nbchat.user.core.busi.WchatApiHelper;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserPhoneLoginBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserPhoneLoginBusiService.class);
    private final NbchatUserConfigProperties userConfigProperties;
    private final VerifyPhoneCodeBusiService verifyPhoneCodeBusiService;
    private final UserSettingHelper userSettingHelper;
    private final UserInfoBusiService userInfoBusiService;
    private final UserLoginLockBusiService userLoginLockBusiService;
    private final RedisHelper redisHelper;
    private final WchatApiHelper wchatApiHelper;
    @Resource
    private UserMapper userMapper;

    public UserPhoneLoginBusiService(NbchatUserConfigProperties userConfigProperties, VerifyPhoneCodeBusiService verifyPhoneCodeBusiService, UserSettingHelper userSettingHelper, UserInfoBusiService userInfoBusiService, UserLoginLockBusiService userLoginLockBusiService, RedisHelper redisHelper, WchatApiHelper wchatApiHelper) {
        this.userConfigProperties = userConfigProperties;
        this.verifyPhoneCodeBusiService = verifyPhoneCodeBusiService;
        this.userSettingHelper = userSettingHelper;
        this.userInfoBusiService = userInfoBusiService;
        this.userLoginLockBusiService = userLoginLockBusiService;
        this.redisHelper = redisHelper;
        this.wchatApiHelper = wchatApiHelper;
    }

    @Transactional(rollbackFor={Exception.class})
    public NbchatUserInfo mobileMpLogin(AuthUserReqBO reqBO) throws UserLoginException {
        String phone = this.wchatApiHelper.queryPhone(reqBO.getCode());
        if (StringUtils.isEmpty((CharSequence)phone)) {
            log.error("\u7ed1\u5b9a\u624b\u673a\u53f7-\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25: {}", (Object)reqBO);
            throw new UserLoginException("\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25");
        }
        reqBO.setPhone(phone);
        return this.handleRegByPhone(reqBO);
    }

    @Transactional(rollbackFor={Exception.class})
    public NbchatUserInfo mobileLogin(AuthUserReqBO reqBO) throws UserLoginException {
        String phone = reqBO.getPhone();
        String captcha = reqBO.getCode();
        String appId = reqBO.getChannel();
        String channel = reqBO.getChannel();
        log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u624b\u673a\u53f7\u767b\u5f55: {}", (Object)appId, (Object)reqBO);
        if (!PhoneNumberUtils.validPhoneNumber((String)phone)) {
            log.warn("\u7528\u6237\u8ba4\u8bc1[{}]-\u624b\u673a\u53f7\u683c\u5f0f\u9a8c\u8bc1\u5931\u8d25: {}", (Object)channel, (Object)phone);
            throw new UserLoginException("\u8bf7\u8f93\u5165\u5408\u6cd5\u7684\u624b\u673a\u53f7");
        }
        String areaCode = PhoneNumberUtils.extractAreaCode((String)phone);
        String countryName = PhoneNumberUtils.getCountryNameByAreaCode((String)areaCode);
        log.debug("\u7528\u6237\u8ba4\u8bc1[{}]-\u624b\u673a\u53f7\u533a\u57df\u8bc6\u522b: {} -> \u533a\u53f7:{}, \u5730\u533a:{}", new Object[]{channel, phone, areaCode, countryName});
        if (StringUtils.isEmpty((CharSequence)reqBO.getCode())) {
            log.warn("\u7528\u6237\u8ba4\u8bc1[{}]-\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object)channel);
            throw new UserLoginException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean checkCode = this.verifyPhoneCodeBusiService.verifyPhoneCode(phone, captcha);
        if (!checkCode) {
            log.warn("\u7528\u6237\u8ba4\u8bc1[{}]-\u9a8c\u8bc1\u7801\u9519\u8bef: {}|{}", new Object[]{appId, phone, captcha});
            throw new UserLoginException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return this.handleRegByPhone(reqBO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NbchatUserInfo handleRegByPhone(AuthUserReqBO reqBO) {
        NbchatUserInfo userInfo;
        block8: {
            String phone = reqBO.getPhone();
            String appId = reqBO.getChannel();
            String channel = reqBO.getChannel();
            String reason = this.userLoginLockBusiService.getLockReason(phone);
            if (StringUtils.isNotBlank((CharSequence)reason)) {
                log.warn("\u7528\u6237\u8ba4\u8bc1[{}]-\u8d26\u53f7\u5df2\u9501\u5b9a: {}", (Object)channel, (Object)reason);
                throw new UserLoginException(reason);
            }
            UserPO user = this.userMapper.findUserByMobile(phone);
            if (user != null) {
                log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u767b\u5f55\u6210\u529f: {}", (Object)appId, (Object)user.getUserId());
                UserPO userPO = new UserPO();
                userPO.setUserId(user.getUserId());
                userPO.setUpdatedTime(new Date());
                this.userMapper.updateById(userPO);
                String userId = user.getUserId();
                userInfo = this.userInfoBusiService.getUserInfo(userId);
                userInfo.setStatus(Integer.valueOf(2));
            } else {
                String key = "nbchat-user:reg-lock:" + phone;
                RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
                boolean locked = this.redisHelper.lock(redisLockEntity, 300L, 20L);
                try {
                    if (locked) {
                        String userId = this.registerByPhone(reqBO);
                        log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u6ce8\u518c\u6210\u529f: {}", (Object)appId, (Object)userId);
                        userInfo = this.userInfoBusiService.getUserInfo(userId);
                        userInfo.setStatus(Integer.valueOf(1));
                        break block8;
                    }
                    log.warn("\u7528\u6237\u8ba4\u8bc1[{}]-\u6ce8\u518c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4: {}", (Object)appId, (Object)phone);
                    throw new UserLoginException("\u6ce8\u518c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4!");
                }
                finally {
                    if (locked) {
                        this.redisHelper.unlock(redisLockEntity);
                    }
                }
            }
        }
        return userInfo;
    }

    private String registerByPhone(AuthUserReqBO reqBO) {
        String userId = IdWorker.nextAutoIdStr();
        String phone = reqBO.getPhone();
        String appId = reqBO.getChannel();
        log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u624b\u673a\u53f7\u4e0d\u5b58\u5728-\u76f4\u63a5\u6ce8\u518c: {}", (Object)appId, (Object)userId);
        String name = "\u7528\u6237" + phone.substring(7);
        UserPO userPO = new UserPO();
        userPO.setUserId(userId);
        userPO.setTenantCode("00000000");
        userPO.setAppId(appId);
        userPO.setPhone(phone);
        userPO.setName(name);
        userPO.setAvatar(this.userConfigProperties.getDefaultAvatar());
        userPO.setCreatedBy(name);
        userPO.setUpdatedBy(name);
        userPO.setCreatedTime(new Date());
        userPO.setStatus(UserStatusType.NORMAL_USER.getCode());
        this.userMapper.registerUser(userPO);
        UserRegistContext registContext = new UserRegistContext();
        BeanUtils.copyProperties((Object)userPO, (Object)registContext);
        registContext.setJoinType(JoinTenantType.REGIST.getCode());
        registContext.setUserRealityName(name);
        String regSource = reqBO.getLoginUa().contains("kejian365") ? UserRegSourceEnum.PC_CLIENT.getCode() : (reqBO.getLoginUa().contains("XWEB") ? UserRegSourceEnum.WECHAT_MINI_PROGRAM.getCode() : UserRegSourceEnum.WEB_CLIENT.getCode());
        registContext.setRegSource(regSource);
        registContext.setPromKey(reqBO.getPromKey());
        registContext.setPromId(reqBO.getPromId());
        registContext.setPromChannel(reqBO.getPromChannel());
        registContext.setInviteCode(reqBO.getInviteCode());
        registContext.setClientUa(reqBO.getLoginUa());
        registContext.setClientIp(reqBO.getLoginIp());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getRegSource())) {
            registContext.setJoinType(JoinTenantType.getCodeByName((String)reqBO.getRegSource()));
            log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u6ce8\u518c\u6765\u6e90: {}-\u7528\u6237\u4fe1\u606f:{}", new Object[]{appId, reqBO.getRegSource(), registContext});
        }
        this.userSettingHelper.userRegistNotice(registContext);
        return userId;
    }
}

