/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.bo.eums.FeatureType;
import com.tydic.nbchat.user.api.bo.eums.ScoreTaskType;
import com.tydic.nbchat.user.api.bo.eums.UserVipStatusType;
import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nbchat.user.api.bo.eums.VipVersionEnum;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRechargeReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserTradeResult;
import com.tydic.nbchat.user.api.bo.vip.UserVipOrderContext;
import com.tydic.nbchat.user.core.busi.ScoreAccountService;
import com.tydic.nbchat.user.core.busi.ScoreRechargeService;
import com.tydic.nbchat.user.core.busi.UserMakeEventSender;
import com.tydic.nbchat.user.core.busi.UserVipService;
import com.tydic.nbchat.user.core.busi.VipSmsNoticeService;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.NbchatUserScoreTaskMapper;
import com.tydic.nbchat.user.mapper.NbchatUserVipLogMapper;
import com.tydic.nbchat.user.mapper.SysUserVipTrialMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserScoreTask;
import com.tydic.nbchat.user.mapper.po.NbchatUserVip;
import com.tydic.nbchat.user.mapper.po.NbchatUserVipLog;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.nbchat.emus.RebateInviteEnum;
import com.tydic.nicc.common.nbchat.emus.UserOperationType;
import com.tydic.nicc.common.nbchat.emus.VipEventType;
import com.tydic.nicc.common.nbchat.msg.RebateInviteMsgContext;
import com.tydic.nicc.common.nbchat.msg.UserOperateLogContext;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserScoreRechargeTaskService {
    private static final Logger log = LoggerFactory.getLogger(UserScoreRechargeTaskService.class);
    @Value(value="${rebate.enable:true}")
    private boolean rebateEnable;
    @Resource
    private NbchatUserScoreTaskMapper nbchatUserScoreTaskMapper;
    @Resource
    private NbchatUserVipLogMapper nbchatUserVipLogMapper;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;
    @Resource
    private SysUserVipTrialMapper sysUserVipTrialMapper;
    private final ScoreRechargeService scoreRechargeService;
    private final UserVipService userVipService;
    private final UserMakeEventSender userMakeEventSender;
    private final UserSettingHelper userSettingHelper;
    private final VipSmsNoticeService vipSmsNoticeService;
    private final ScoreAccountService scoreAccountService;

    public UserScoreRechargeTaskService(ScoreRechargeService scoreRechargeService, UserVipService userVipService, UserMakeEventSender userMakeEventSender, UserSettingHelper userSettingHelper, VipSmsNoticeService vipSmsNoticeService, ScoreAccountService scoreAccountService) {
        this.scoreRechargeService = scoreRechargeService;
        this.userVipService = userVipService;
        this.userMakeEventSender = userMakeEventSender;
        this.userSettingHelper = userSettingHelper;
        this.vipSmsNoticeService = vipSmsNoticeService;
        this.scoreAccountService = scoreAccountService;
    }

    @MethodParamVerifyEnable
    @Transactional(rollbackFor={Exception.class})
    public void handleScoreRechargeTask(UserVipOrderContext context) {
        NbchatUserVip vip;
        log.info("\u7528\u6237\u5145\u503c\u8ba2\u5355[{}]\uff0c\u5f00\u59cb\u5904\u7406\u5145\u503c\u4efb\u52a1: {}", (Object)context.getOrderNo(), (Object)context);
        String oldVip = "0";
        List<NbchatUserVip> vipInfo = this.userVipService.getVipInfo(context.getTenantCode(), context.getUserId());
        if (CollectionUtils.isNotEmpty(vipInfo) && (vip = (NbchatUserVip)vipInfo.stream().filter(o -> UserVipStatusType.NORMAL.getCode().equals(o.getVipStatus())).max(Comparator.comparing(o -> Integer.valueOf(o.getVipType()))).orElse(null)) != null) {
            oldVip = vip.getVipType();
        }
        if (UserVipType.SCORE_PACKAGE.getCode().equals(context.getVipType())) {
            List<NbchatUserScoreTask> rechargeTasks = this.buildRechargeTask(context, context.getOrderTime());
            log.info("\u7528\u6237\u5145\u503c\u8ba2\u5355[{}]\uff0c\u521b\u5efa\u52a0\u6cb9\u5305\u5145\u503c\u4efb\u52a1: {}", (Object)context.getOrderNo(), rechargeTasks);
            this.nbchatUserScoreTaskMapper.insertBatch(rechargeTasks);
            NbchatUserVip vip2 = new NbchatUserVip();
            vip2.setVipStatus(UserVipStatusType.EXPIRED.getCode());
            vip2.setVipStart(context.getOrderTime());
            vip2.setVipEnd(UserScoreRechargeTaskService.getExpireTime(context.getOrderTime(), context.getCycle() * context.getDays()));
            vip2.setTenantCode(context.getTenantCode());
            vip2.setUserId(context.getUserId());
            vip2.setVipType(context.getVipType());
            this.userMakeEventSender.sendVipChangeEvent(VipEventType.DOU_RECHARGE.getCode(), vip2, context.getCycle(), context.getDays());
            context.setStartTime(context.getOrderTime());
        } else {
            NbchatUserVip userVip;
            String version = VipVersionEnum.MONTHLY.getCode();
            if (context.getCycle() >= 12) {
                version = VipVersionEnum.ANNUAL.getCode();
            }
            if (ObjectUtils.isNotEmpty((Object)(userVip = this.createNewVip(context, version)).getId())) {
                this.vipRenew(context, userVip, version);
            }
            context.setStartTime(userVip.getVipStart());
            if (UserVipType.isProfessional((String)context.getVipType())) {
                this.invalidTrial(context.getUserId());
            }
        }
        this.userVipService.getVipInfoBO(context.getTenantCode(), context.getUserId(), true);
        log.info("\u7528\u6237\u5145\u503c\u8ba2\u5355[{}]\uff0c\u5904\u7406\u5145\u503c\u4efb\u52a1\u5b8c\u6210: {}", (Object)context.getOrderNo(), (Object)context);
        this.scoreAccountService.unfreezeScore(context.getTenantCode(), context.getUserId(), context.getVipType());
        this.saveLog(context);
        if (this.rebateEnable) {
            RebateInviteMsgContext rebateInviteMsgContext = new RebateInviteMsgContext();
            rebateInviteMsgContext.setEventType(RebateInviteEnum.INVITE_PAY.getCode());
            rebateInviteMsgContext.setEventTime(new Date());
            rebateInviteMsgContext.setTenantCode(context.getTenantCode());
            rebateInviteMsgContext.setUserId(context.getUserId());
            HashMap<String, String> extParams = new HashMap<String, String>();
            extParams.put("orderNo", context.getOrderNo());
            extParams.put("vipType", context.getVipType());
            rebateInviteMsgContext.setExtParams(extParams);
            log.info("\u53d1\u9001\u9080\u8bf7\u7528\u6237\u6d88\u8d39\u4e8b\u4ef6\u6d88\u606f: {}", (Object)context);
            this.kkMqProducerHelper.sendMsg("NBCHAT_REBATE_INVITE", (Object)rebateInviteMsgContext);
        }
        JSONObject operateContent = new JSONObject();
        operateContent.put("vipType", (Object)context.getVipType());
        operateContent.put("oldVip", (Object)oldVip);
        operateContent.put("payAmount", (Object)context.getPayPrice());
        UserOperateLogContext userOperateLogContext = UserOperateLogContext.build((UserOperationType)UserOperationType.VIP_PAY, (String)context.getTenantCode(), (String)context.getUserId(), (UserOperateLogContext.BuildParams)UserOperateLogContext.BuildParams.builder().busiId(context.getOrderNo()).content(operateContent.toJSONString()).eventTime(context.getOrderTime()).build());
        try {
            log.info("\u53d1\u9001\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7\u4e8b\u4ef6\u6d88\u606f: {}", (Object)userOperateLogContext);
            this.kkMqProducerHelper.sendMsg("NBCHAT_USER_OPERATE_LOG", (Object)userOperateLogContext);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7\u4e8b\u4ef6\u6d88\u606f-\u5f02\u5e38:{}", (Object)userOperateLogContext, (Object)e);
        }
    }

    public void invalidTrial(String userId) {
        this.sysUserVipTrialMapper.deleteTrial(userId, FeatureType.VIP_VIDEO.getCode());
    }

    public NbchatUserVip createNewVip(UserVipOrderContext context, String version) {
        NbchatUserVip vipInfo = this.userVipService.getVipInfo(context.getTenantCode(), context.getUserId(), context.getVipType());
        if (ObjectUtils.isNotEmpty((Object)vipInfo)) {
            log.info("\u7528\u6237\u5145\u503c\u8ba2\u5355[{}]\uff0c\u521d\u6b21\u5145\u503c\uff0c\u4f1a\u5458\u5df2\u5b58\u5728\uff0c\u4e0d\u505a\u5904\u7406: {}", (Object)context.getOrderNo(), (Object)vipInfo);
            return vipInfo;
        }
        NbchatUserVip vip = new NbchatUserVip();
        vip.setTenantCode(context.getTenantCode());
        vip.setUserId(context.getUserId());
        vip.setVipType(context.getVipType());
        vip.setVipStart(context.getOrderTime());
        Date vipEnd = UserScoreRechargeTaskService.getExpireTime(context.getOrderTime(), context.getCycle() * context.getDays());
        vip.setVipEnd(vipEnd);
        vip.setVipStatus(UserVipStatusType.NORMAL.getCode());
        vip.setCreateTime(new Date());
        vip.setUpdateTime(new Date());
        vip.setVipDesc(UserVipType.getDescByCode((String)context.getVipType()));
        vip.setVipVersion(version);
        this.userVipService.createVip(vip);
        if (context.getScore() > 0) {
            List<NbchatUserScoreTask> rechargeTasks = this.buildRechargeTask(context, context.getOrderTime());
            log.info("\u7528\u6237\u5145\u503c\u8ba2\u5355[{}]\uff0c\u521d\u6b21\u5145\u503c\uff0c\u521b\u5efa\u5145\u503c\u4efb\u52a1: {}", (Object)context.getOrderNo(), rechargeTasks);
            this.nbchatUserScoreTaskMapper.insertBatch(rechargeTasks);
            this.userMakeEventSender.sendVipChangeEvent(VipEventType.VIP_OPEN.getCode(), vip, context.getCycle(), context.getDays());
        }
        this.vipSmsNoticeService.sendVipOpenSms(context.getUserId(), UserVipType.getNameByCode((String)context.getVipType()), vip.getVipEnd(), context.getVipType(), version);
        return vip;
    }

    public void vipRenew(UserVipOrderContext context, NbchatUserVip userVip, String version) {
        List<NbchatUserScoreTask> rechargeTasks;
        userVip.setVipStatus(UserVipStatusType.NORMAL.getCode());
        if (userVip.getVipEnd().before(new Date())) {
            Date vipEnd = UserScoreRechargeTaskService.getExpireTime(context.getOrderTime(), context.getCycle() * context.getDays());
            this.userVipService.delayVip(userVip.getId(), context.getOrderTime(), vipEnd, context.getVipType(), version);
            userVip.setVipStart(context.getOrderTime());
            userVip.setVipEnd(vipEnd);
            rechargeTasks = this.buildRechargeTask(context, context.getOrderTime());
            this.vipSmsNoticeService.sendVipOpenSms(context.getUserId(), UserVipType.getNameByCode((String)context.getVipType()), userVip.getVipEnd(), context.getVipType(), version);
        } else {
            Date vipEnd = UserScoreRechargeTaskService.getExpireTime(userVip.getVipEnd(), context.getCycle() * context.getDays());
            this.userVipService.delayVip(userVip.getId(), userVip.getVipStart(), vipEnd, context.getVipType(), version);
            this.vipSmsNoticeService.sendVipRenewSms(context.getUserId(), UserVipType.getNameByCode((String)context.getVipType()), userVip.getVipEnd(), vipEnd);
            rechargeTasks = this.buildRechargeTask(context, userVip.getVipEnd());
            userVip.setVipStart(userVip.getVipEnd());
            userVip.setVipEnd(vipEnd);
        }
        if (context.getScore() > 0) {
            log.info("\u7528\u6237\u5145\u503c\u8ba2\u5355[{}]\uff0c\u4f1a\u5458\u5ef6\u671f\uff0c\u521b\u5efa\u4f1a\u5458\u5145\u503c\u4efb\u52a1: {}", (Object)context.getOrderNo(), (Object)JSONObject.toJSONString(rechargeTasks));
            this.nbchatUserScoreTaskMapper.insertBatch(rechargeTasks);
            userVip.setVipType(context.getVipType());
            userVip.setVipDesc(UserVipType.getDescByCode((String)context.getVipType()));
            this.userMakeEventSender.sendVipChangeEvent(VipEventType.VIP_RENEW.getCode(), userVip, context.getCycle(), context.getDays());
        }
    }

    public void doTaskCheck() {
        long start = System.currentTimeMillis();
        log.info("\u7528\u6237\u79ef\u5206\u5145\u503c\u4efb\u52a1\uff0c\u5f00\u59cb\u6267\u884c: {}", (Object)new Date());
        List scoreTasks = this.nbchatUserScoreTaskMapper.selectWaitRechargeTask();
        for (NbchatUserScoreTask scoreTask : scoreTasks) {
            try {
                log.debug("\u7528\u6237\u79ef\u5206\u5145\u503c\u4efb\u52a1\uff0c\u5904\u7406\u5145\u503c\u4efb\u52a1: {}", (Object)scoreTask);
                if (ScoreTaskType.RECHARGE.getCode().equals(scoreTask.getTaskType())) {
                    UserBalanceRechargeReqBO recharge = new UserBalanceRechargeReqBO();
                    recharge.setUserId(scoreTask.getUserId());
                    recharge.setScoreType(scoreTask.getScoreType());
                    recharge.setScore(scoreTask.getScore());
                    recharge.setTenantCode(scoreTask.getTenantCode());
                    recharge.setRemark(scoreTask.getTaskDesc());
                    recharge.setExpireTime(scoreTask.getExpireTime());
                    recharge.setOrderNo(scoreTask.getOrderNo());
                    Rsp<UserTradeResult> resultRsp = this.scoreRechargeService.recharge(recharge);
                    if (resultRsp.isSuccess()) {
                        this.vipSmsNoticeService.sendDouRechargeSms(scoreTask.getUserId(), scoreTask.getScore(), scoreTask.getScoreType());
                        this.updateTaskStatus(scoreTask.getTaskId(), EntityValidType.NORMAL.getCode());
                        this.userMakeEventSender.sendScoreChangeEvent((UserTradeResult)resultRsp.getData(), ((UserTradeResult)resultRsp.getData()).getBalance().getScore());
                        continue;
                    }
                    log.error("\u7528\u6237\u79ef\u5206\u5145\u503c\u4efb\u52a1\uff0c\u5145\u503c\u5931\u8d25: {}, {}", (Object)scoreTask, resultRsp);
                    this.updateTaskStatus(scoreTask.getTaskId(), "2");
                    continue;
                }
                if (ScoreTaskType.REFUND.getCode().equals(scoreTask.getTaskType())) continue;
                log.error("\u7528\u6237\u79ef\u5206\u5145\u503c\u4efb\u52a1\uff0c\u4efb\u52a1\u7c7b\u578b\u9519\u8bef: {}", (Object)scoreTask);
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u79ef\u5206\u5145\u503c\u4efb\u52a1\uff0c\u5904\u7406\u5f02\u5e38: {}", (Object)scoreTask, (Object)e);
                this.updateTaskStatus(scoreTask.getTaskId(), "2");
            }
        }
        long end = System.currentTimeMillis();
        log.info("\u7528\u6237\u79ef\u5206\u5145\u503c\u4efb\u52a1\uff0c\u6267\u884c\u5b8c\u6210: {},{} ms", (Object)scoreTasks.size(), (Object)(end - start));
    }

    private void updateTaskStatus(Long taskId, String state) {
        NbchatUserScoreTask updateTask = new NbchatUserScoreTask();
        updateTask.setTaskId(taskId);
        updateTask.setTaskStatus(state);
        updateTask.setUpdateTime(new Date());
        this.nbchatUserScoreTaskMapper.updateByPrimaryKeySelective(updateTask);
    }

    private List<NbchatUserScoreTask> buildRechargeTask(UserVipOrderContext context, Date startTime) {
        Integer cycle = context.getCycle();
        ArrayList list = Lists.newArrayList();
        Date startDate = DateUtils.truncate((Date)startTime, (int)5);
        for (int i = 0; i < cycle; ++i) {
            Date execTime = DateUtils.addMonths((Date)startDate, (int)i);
            NbchatUserScoreTask scoreTask = new NbchatUserScoreTask();
            scoreTask.setTenantCode(context.getTenantCode());
            scoreTask.setUserId(context.getUserId());
            scoreTask.setScore(context.getScore());
            scoreTask.setOrderNo(context.getOrderNo());
            scoreTask.setTaskType(ScoreTaskType.RECHARGE.getCode());
            scoreTask.setScoreType(context.getVipType());
            if (UserVipType.SCORE_PACKAGE.getCode().equals(context.getVipType())) {
                scoreTask.setTaskDesc("\u7b97\u529b\u70b9\u5145\u503c");
                scoreTask.setExpireTime(UserScoreRechargeTaskService.getExpireTime(startTime, 1825));
            } else {
                scoreTask.setTaskDesc(UserVipType.getNameByCode((String)context.getVipType()) + "\u2014\u6bcf\u6708\u8d60\u9001\u7b97\u529b\u70b9");
                scoreTask.setExpireTime(UserScoreRechargeTaskService.getExpireTime(startTime, 90));
            }
            scoreTask.setExecTime(execTime);
            scoreTask.setTaskStatus(EntityValidType.DELETE.getCode());
            scoreTask.setCreateTime(new Date());
            list.add(scoreTask);
            startTime = DateTimeUtil.DateAdd((Date)startTime, (int)6, (int)context.getDays());
        }
        return list;
    }

    private static Date getExpireTime(Date startTime, Integer days) {
        Date date = DateTimeUtil.DateAdd((Date)startTime, (int)6, (int)days);
        return DateTimeUtil.createTime((Date)date, (int)23, (int)59, (int)58);
    }

    public void saveLog(UserVipOrderContext context) {
        log.info("\u7528\u6237\u5145\u503c\u8ba2\u5355\uff0c\u4fdd\u5b58\u4f1a\u5458\u65e5\u5fd7: {}", (Object)context);
        try {
            NbchatUserVipLog po = new NbchatUserVipLog();
            po.setUserId(context.getUserId());
            po.setTenantCode(context.getTenantCode());
            po.setVipType(context.getVipType());
            po.setValidDays(Integer.valueOf(context.getCycle() * context.getDays()));
            po.setAmount(context.getPayPrice());
            po.setStartTime(context.getStartTime());
            po.setEndTime(UserScoreRechargeTaskService.getExpireTime(po.getStartTime(), context.getCycle() * context.getDays()));
            po.setCreateTime(new Date());
            po.setTotalDou(Integer.valueOf(context.getScore() * context.getCycle()));
            po.setOrderNo(context.getOrderNo());
            this.nbchatUserVipLogMapper.insertSelective(po);
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u5145\u503c\u8ba2\u5355\uff0c\u4fdd\u5b58\u4f1a\u5458\u65e5\u5fd7\u5f02\u5e38: {}", (Object)context, (Object)e);
        }
    }
}

