/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.UserSettingsApi;
import com.tydic.nbchat.user.api.bo.UserSwitchTenantRequest;
import com.tydic.nbchat.user.api.bo.eums.SysPlatformDefine;
import com.tydic.nbchat.user.api.bo.setting.UserSettingReqBO;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.UserLoginEventService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserTenantSwitchService {
    private static final Logger log = LoggerFactory.getLogger(UserTenantSwitchService.class);
    private final UserLoginEventService userLoginEventService;
    private final UserSettingsApi userSettingsApi;
    private final UserInfoBusiService userInfoBusiService;

    public UserTenantSwitchService(UserLoginEventService userLoginEventService, UserSettingsApi userSettingsApi, UserInfoBusiService userInfoBusiService) {
        this.userLoginEventService = userLoginEventService;
        this.userSettingsApi = userSettingsApi;
        this.userInfoBusiService = userInfoBusiService;
    }

    public Rsp switchPlatformTenant(UserSwitchTenantRequest request) {
        log.info("\u7528\u6237\u5207\u6362\u5e73\u53f0\u79df\u6237: {}", (Object)request);
        if (!SysPlatformDefine.isValidCode((String)request.getPlatform())) {
            return BaseRspUtils.createErrorRsp((String)"\u5e73\u53f0\u53c2\u6570\u9519\u8bef");
        }
        JSONObject paramMap = new JSONObject();
        HashMap<String, JSONObject> settingMap = new HashMap<String, JSONObject>();
        paramMap.put("sessionKey", (Object)request.getSessionKey());
        paramMap.put("loginTime", (Object)System.currentTimeMillis());
        paramMap.put("tenantCode", (Object)request.getTargetTenant());
        settingMap.put(request.getPlatform(), paramMap);
        UserSettingReqBO reqBO = new UserSettingReqBO();
        reqBO.setUserId(request.getUserId());
        reqBO.setSettings(settingMap);
        Rsp setRsp = this.userSettingsApi.saveSettings(reqBO);
        if (setRsp.isSuccess()) {
            this.userInfoBusiService.reloadUserInfo(request.getUserId(), request.getTargetTenant());
            this.userLoginEventService.sengLoginSwitchTenant(request.getUserId(), "", request.getLoginIp(), request.getLoginUa(), request.getTargetTenant());
        }
        return setRsp;
    }
}

