/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.eums.CustomizeTypeEnum;
import com.tydic.nbchat.user.api.bo.eums.VipVersionEnum;
import com.tydic.nbchat.user.api.bo.vip.UserVipOrderContext;
import com.tydic.nbchat.user.mapper.NbchatUserVipRightsMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserVipRights;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserVipRightsService {
    private static final Logger log = LoggerFactory.getLogger(UserVipRightsService.class);
    @Resource
    NbchatUserVipRightsMapper nbchatUserVipRightsMapper;

    public Rsp addRights(UserVipOrderContext context) {
        if (!context.getCycle().equals(12)) {
            log.warn("\u975e\u5e74\u8d39\u7528\u6237\uff0c\u4e0d\u8d60\u9001\u6743\u76ca|{}", (Object)context);
            return BaseRspUtils.createSuccessRsp((Object)"\u975e\u5e74\u8d39\u7528\u6237\uff0c\u4e0d\u8d60\u9001\u6743\u76ca");
        }
        log.info("\u65b0\u589e\u7528\u6237VIP\u6743\u76ca:{}", (Object)context);
        NbchatUserVipRights po = new NbchatUserVipRights();
        po.setUserId(context.getUserId());
        po.setTenantCode(context.getTenantCode());
        po.setVipVersion(VipVersionEnum.ANNUAL.getCode());
        po.setRightsType("1");
        po.setCustomizeType(CustomizeTypeEnum._2D.getCode());
        po.setStartTime(context.getOrderTime());
        Date endTime = UserVipRightsService.getExpireTime(context.getOrderTime(), context.getCycle() * context.getDays());
        po.setEndTime(endTime);
        po.setRightsCount(Integer.valueOf(1));
        int i = this.nbchatUserVipRightsMapper.insertSelective(po);
        return BaseRspUtils.createSuccessRsp((Object)"\u65b0\u589e\u7528\u6237VIP\u6743\u76ca\u6210\u529f");
    }

    private static Date getExpireTime(Date startTime, Integer days) {
        Date date = DateTimeUtil.DateAdd((Date)startTime, (int)6, (int)days);
        return DateTimeUtil.createTime((Date)date, (int)23, (int)59, (int)58);
    }

    @Transactional
    public void checkRightsExpired() {
        log.info("\u68c0\u67e5\u7528\u6237\u6743\u76ca\u8fc7\u671f...");
        this.nbchatUserVipRightsMapper.updateExpire();
        this.nbchatUserVipRightsMapper.updateFinish();
    }
}

