/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.eums.UserVipStatusType;
import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nbchat.user.api.bo.vip.UserVipBO;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.NbchatUserVipMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserVip;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class UserVipService {
    private static final Logger log = LoggerFactory.getLogger(UserVipService.class);
    @Resource
    private NbchatUserVipMapper nbchatUserVipMapper;
    private final UserSettingHelper userSettingHelper;

    public UserVipService(UserSettingHelper userSettingHelper) {
        this.userSettingHelper = userSettingHelper;
    }

    public NbchatUserVip getVipInfo(String tenantCode, String userId, String vipType) {
        List<NbchatUserVip> vipInfo = this.getVipInfo(tenantCode, userId);
        return vipInfo.stream().filter(vip -> vip.getVipType().equals(vipType)).findFirst().orElse(null);
    }

    public List<NbchatUserVip> getVipInfo(String tenantCode, String userId) {
        List vips = this.nbchatUserVipMapper.selectByUserId(tenantCode, userId);
        for (NbchatUserVip vip : vips) {
            vip.setVipDesc(UserVipType.getDescByCode((String)vip.getVipType()));
            if (!UserVipStatusType.EXPIRED.getCode().equals(vip.getVipStatus())) continue;
            vip.setVipDesc("");
        }
        return vips;
    }

    public UserVipBO getVipInfoBO(String tenantCode, String userId) {
        return this.getVipInfoBO(tenantCode, userId, false);
    }

    public UserVipBO getVipInfoBO(String tenantCode, String userId, Boolean reload) {
        UserVipBO vipBO;
        if (reload.booleanValue()) {
            this.userSettingHelper.removeVipInfo(tenantCode, userId);
            this.userSettingHelper.removeInfo(userId);
        } else {
            vipBO = this.userSettingHelper.getVipInfo(tenantCode, userId);
            if (vipBO != null) {
                return vipBO;
            }
        }
        vipBO = new UserVipBO();
        vipBO.setVipDesc(UserVipStatusType.FREE.getDesc());
        vipBO.setVipStatus(UserVipStatusType.FREE.getCode());
        vipBO.setIsExperienced("0");
        vipBO.setIsCompany("0");
        try {
            log.info("\u67e5\u8be2\u7528\u6237\u4f1a\u5458\u4fe1\u606f: {}|{}", (Object)tenantCode, (Object)userId);
            List vipList = this.nbchatUserVipMapper.selectByUserId(tenantCode, userId);
            if (CollectionUtils.isNotEmpty((Collection)vipList)) {
                ArrayList bos = new ArrayList();
                NiccCommonUtil.copyList((List)vipList, bos, UserVipBO.class);
                vipBO.setVipList(bos);
                NbchatUserVip vip = (NbchatUserVip)vipList.get(0);
                BeanUtils.copyProperties((Object)vip, (Object)vipBO);
                vipBO.setVipStart(vip.getVipStart());
                vipBO.setVipEnd(vip.getVipEnd());
                vipBO.setVipStatus(vip.getVipStatus());
            }
            this.userSettingHelper.cacheVipInfo(tenantCode, userId, vipBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6237\u4f1a\u5458\u4fe1\u606f\u5f02\u5e38: {}|{}", new Object[]{tenantCode, userId, e});
        }
        return vipBO;
    }

    public boolean isVip(String tenantCode, String userId) {
        List vip = this.nbchatUserVipMapper.selectByUserId(tenantCode, userId);
        if (CollectionUtils.isEmpty((Collection)vip)) {
            return false;
        }
        Iterator iterator = vip.iterator();
        if (iterator.hasNext()) {
            NbchatUserVip userVip = (NbchatUserVip)iterator.next();
            return userVip.getVipStatus().equals(UserVipStatusType.NORMAL.getCode());
        }
        return false;
    }

    public void delayVip(Long vipId, Date vipStart, Date endTime, String vipType, String version) {
        NbchatUserVip vip = new NbchatUserVip();
        vip.setId(vipId);
        vip.setVipStart(vipStart);
        vip.setVipEnd(endTime);
        vip.setVipStatus(UserVipStatusType.NORMAL.getCode());
        vip.setUpdateTime(new Date());
        vip.setVipType(vipType);
        vip.setVipVersion(version);
        vip.setVipDesc(UserVipType.getDescByCode((String)vipType));
        if (vip.getVipType().equals(UserVipType.EXPERIENCE.getCode())) {
            vip.setIsExperienced(EntityValidType.NORMAL.getCode());
        }
        this.nbchatUserVipMapper.updateByPrimaryKeySelective(vip);
    }

    public void createVip(NbchatUserVip vip) {
        if (vip.getVipType().equals(UserVipType.EXPERIENCE.getCode())) {
            vip.setIsExperienced(EntityValidType.NORMAL.getCode());
        }
        this.nbchatUserVipMapper.insertSelective(vip);
    }
}

