/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.UserVipTrialApi;
import com.tydic.nbchat.user.api.bo.SysUserGiftConfBO;
import com.tydic.nbchat.user.api.bo.user.SysUserVipTrialBO;
import com.tydic.nbchat.user.mapper.SysUserGiftConfMapper;
import com.tydic.nbchat.user.mapper.SysUserVipTrialMapper;
import com.tydic.nbchat.user.mapper.po.SysUserGiftConf;
import com.tydic.nbchat.user.mapper.po.SysUserVipTrial;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserVipTrialBusiService
implements UserVipTrialApi {
    private static final Logger log = LoggerFactory.getLogger(UserVipTrialBusiService.class);
    @Resource
    SysUserVipTrialMapper sysUserVipTrialMapper;
    @Resource
    SysUserGiftConfMapper sysUserGiftConfMapper;

    public RspList info(SysUserVipTrialBO request) {
        SysUserVipTrial po = new SysUserVipTrial();
        BeanUtils.copyProperties((Object)request, (Object)po);
        List sysUserVipTrials = this.sysUserVipTrialMapper.selectAll(po);
        ArrayList res = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)sysUserVipTrials)) {
            NiccCommonUtil.copyList((List)sysUserVipTrials, res, SysUserVipTrialBO.class);
        }
        return BaseRspUtils.createSuccessRspList(res);
    }

    public Rsp addVipTrial(SysUserVipTrialBO request) {
        SysUserVipTrial po = new SysUserVipTrial();
        BeanUtils.copyProperties((Object)request, (Object)po);
        int i = this.sysUserVipTrialMapper.insertSelective(po);
        return BaseRspUtils.createSuccessRsp((Object)i);
    }

    public Rsp updateVipTrial(String userId, String featureType, Integer usedCount) {
        SysUserVipTrial po = new SysUserVipTrial();
        po.setUserId(userId);
        po.setFeatureType(featureType);
        po.setUsedCount(usedCount);
        int update = this.sysUserVipTrialMapper.update(po);
        return BaseRspUtils.createSuccessRsp(null);
    }

    public RspList queryConf(String promChannel, String userId) {
        log.info("\u67e5\u8be2\u8d60\u9001\u6743\u76ca, promChannel: {}, userId: {}", (Object)promChannel, (Object)userId);
        ArrayList res = new ArrayList();
        SysUserGiftConf po = new SysUserGiftConf();
        po.setChannelCode(promChannel);
        List confs = this.sysUserGiftConfMapper.selectValidConf(po);
        if (CollectionUtils.isEmpty((Collection)confs)) {
            return BaseRspUtils.createErrorRspList((String)"\u6ca1\u6709\u53ef\u7528\u7684\u8d60\u9001\u914d\u7f6e");
        }
        NiccCommonUtil.copyList((List)confs, res, SysUserGiftConfBO.class);
        return BaseRspUtils.createSuccessRspList(res);
    }

    public Rsp addByConf(String promChannel, String userId) {
        log.info("\u6dfb\u52a0\u8d60\u9001\u6743\u76ca, promChannel: {}, userId: {}", (Object)promChannel, (Object)userId);
        SysUserGiftConf po = new SysUserGiftConf();
        po.setChannelCode(promChannel);
        List confs = this.sysUserGiftConfMapper.selectValidConf(po);
        if (CollectionUtils.isEmpty((Collection)confs)) {
            return BaseRspUtils.createErrorRsp((String)"\u6ca1\u6709\u53ef\u7528\u7684\u8d60\u9001\u914d\u7f6e");
        }
        for (SysUserGiftConf conf : confs) {
            SysUserVipTrial trial = SysUserVipTrial.builder().userId(userId).featureType(conf.getGiftType()).totalCount(Integer.valueOf(Integer.parseInt(conf.getGiftValue()))).expireTime(conf.getExpireTime()).build();
            this.sysUserVipTrialMapper.insertSelective(trial);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6dfb\u52a0\u6210\u529f");
    }
}

