/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.AuthType;
import com.tydic.nbchat.user.api.bo.eums.UserStatusType;
import com.tydic.nbchat.user.api.bo.exception.UserLoginException;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.WchatApiHelper;
import com.tydic.nbchat.user.core.config.WchatConfigProperties;
import com.tydic.nbchat.user.core.enmus.WxChannelEnum;
import com.tydic.nbchat.user.core.vo.WxUserVO;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.WxUserMapper;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nbchat.user.mapper.po.WxUserPO;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserWchatLoginBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserWchatLoginBusiService.class);
    private final UserInfoBusiService userInfoBusiService;
    private final WchatApiHelper wchatApiHelper;
    private final WchatConfigProperties wchatConfigProperties;
    @Resource
    private WxUserMapper wxUserMapper;
    @Resource
    private UserMapper userMapper;

    public UserWchatLoginBusiService(UserInfoBusiService userInfoBusiService, WchatApiHelper wchatApiHelper, WchatConfigProperties wchatConfigProperties) {
        this.userInfoBusiService = userInfoBusiService;
        this.wchatApiHelper = wchatApiHelper;
        this.wchatConfigProperties = wchatConfigProperties;
    }

    public NbchatUserInfo wechatLogin(AuthUserReqBO authUserReqBO) throws UserLoginException {
        String userId;
        String openId;
        String unionId;
        String appId = "";
        Object nickName = "";
        String avatar = "";
        String gender = "";
        String channel = "";
        UserPO user = null;
        if (AuthType.WCHAT_PC_OFFICIAL.getCode().equals(authUserReqBO.getAuthType())) {
            user = this.userMapper.selectByUnionId(authUserReqBO.getUnionId());
            gender = "1";
            unionId = authUserReqBO.getUnionId();
            openId = authUserReqBO.getOpenId();
            if (ObjectUtils.isEmpty((Object)user)) {
                nickName = "\u7528\u6237" + NiccCommonUtil.generateRandomCode((int)1000, (int)90000);
            }
        } else {
            WchatConfigProperties.Property property = WchatApiHelper.getProperty(authUserReqBO.getAuthType(), this.wchatConfigProperties);
            String appSecret = property.getSecret();
            appId = property.getAppId();
            String code = authUserReqBO.getCode();
            channel = authUserReqBO.getChannel();
            log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u5fae\u4fe1\u7528\u6237-\u8ba4\u8bc1\u5f00\u59cb: {}", (Object)channel, (Object)authUserReqBO);
            JSONObject accessTokenJson = AuthType.WCHAT_MP_TDH.getCode().equals(authUserReqBO.getAuthType()) ? this.wchatApiHelper.getMPInfo(WxChannelEnum.WCHAT_MP_TDH.getCode(), appId, appSecret, code) : this.wchatApiHelper.getAccessToken(appId, appSecret, code);
            if (accessTokenJson != null) {
                String accessToken = accessTokenJson.getString("access_token");
                openId = accessTokenJson.getString("openid");
                unionId = accessTokenJson.getString("unionid");
                log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u5fae\u4fe1\u7528\u6237-\u83b7\u53d6token: {}", (Object)channel, (Object)accessTokenJson);
                user = this.userMapper.selectByUnionId(unionId);
                if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                    WxUserVO wxUserVO = this.wchatApiHelper.getWechatUserInfo(openId, accessToken);
                    nickName = wxUserVO.getNickname();
                    avatar = wxUserVO.getHeadimgurl();
                    gender = wxUserVO.getSex();
                }
            } else {
                throw new UserLoginException("\u5fae\u4fe1\u767b\u5f55\u5f02\u5e38\uff0c\u8ba4\u8bc1\u5931\u8d25");
            }
        }
        if (user != null) {
            log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u5fae\u4fe1\u7528\u6237-\u7528\u6237\u5df2\u5b58\u5728:{}", (Object)channel, (Object)user);
            UserPO userPO = new UserPO();
            Object updatedBy = StringUtils.isNotEmpty((CharSequence)nickName) ? nickName : user.getUpdatedBy();
            userPO.setAvatar(avatar);
            userPO.setName((String)nickName);
            userPO.setUpdatedBy((String)updatedBy);
            userPO.setUpdatedTime(new Date());
            userPO.setUserId(user.getUserId());
            this.userMapper.updateById(userPO);
            userId = user.getUserId();
        } else {
            log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u5fae\u4fe1\u7528\u6237-\u7528\u6237\u4e0d\u5b58\u5728: {}", (Object)channel, (Object)openId);
            userId = IdWorker.nextAutoIdStr();
            UserPO regUser = new UserPO();
            regUser.setUserId(userId);
            regUser.setUnionId(unionId);
            regUser.setTenantCode("00000000");
            regUser.setAppId(appId);
            regUser.setName((String)nickName);
            regUser.setAvatar(avatar);
            regUser.setGender(gender);
            regUser.setCreatedBy((String)nickName);
            regUser.setUpdatedBy((String)nickName);
            regUser.setCreatedTime(new Date());
            regUser.setUpdatedTime(new Date());
            regUser.setStatus(UserStatusType.AWAIT_USER.getCode());
            this.userMapper.registerUser(regUser);
            log.info("\u7528\u6237\u8ba4\u8bc1-\u5fae\u4fe1\u7528\u6237\u6ce8\u518c\u6210\u529f:{}", (Object)regUser);
            try {
                this.saveWchatRecord(userId, openId, unionId, appId, (String)nickName, avatar, gender);
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u8ba4\u8bc1-\u5fae\u4fe1\u7528\u6237\u6ce8\u518c\u5931\u8d25: {}", (Object)regUser, (Object)e);
            }
        }
        return this.userInfoBusiService.getUserInfo(userId);
    }

    private void saveWchatRecord(String userId, String openId, String unionId, String appId, String nickName, String avatar, String gender) {
        WxUserPO wxUserPO = new WxUserPO();
        wxUserPO.setUserId(userId);
        wxUserPO.setTenantCode("00000000");
        wxUserPO.setOpenId(openId);
        wxUserPO.setUnionId(unionId);
        wxUserPO.setAppId(appId);
        wxUserPO.setNickName(nickName);
        wxUserPO.setAvatar(avatar);
        wxUserPO.setGender(gender);
        wxUserPO.setStatus(UserStatusType.AWAIT_USER.getCode());
        wxUserPO.setCreatedBy(nickName);
        wxUserPO.setCreatedTime(new Date());
        wxUserPO.setUpdatedBy(nickName);
        wxUserPO.setChannel(WxChannelEnum.DIWEN.getCode());
        this.wxUserMapper.insertSelective(wxUserPO);
    }
}

