/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VerifyPhoneCodeBusiService {
    private static final Logger log = LoggerFactory.getLogger(VerifyPhoneCodeBusiService.class);
    private final RedisHelper redisHelper;
    private static final String VIRTUAL_PHONE_PREFIX = "nbchat-user:virtual_phone";

    public VerifyPhoneCodeBusiService(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    public boolean checkVirtualPhone(String phone) {
        String prefix = phone.substring(0, 3);
        return this.redisHelper.sHasKey(VIRTUAL_PHONE_PREFIX, (Object)prefix);
    }

    public boolean verifyPhoneCode(String phone, String code) {
        if (phone == null || code == null || phone.isEmpty() || code.isEmpty()) {
            log.warn("\u624b\u673a\u53f7\u6216\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
            return false;
        }
        String captchaKey = "nbchat-user:verify_code:" + phone;
        String storedCode = (String)this.redisHelper.get(captchaKey);
        if (storedCode == null) {
            log.info("\u624b\u673a\u53f7[{}]\u9a8c\u8bc1\u7801\u4e0d\u5b58\u5728", (Object)phone);
            return false;
        }
        String frequencyKey = "nbchat-user:verify_code_frequency:" + phone;
        Integer frequency = (Integer)this.redisHelper.get(frequencyKey);
        if (!storedCode.equals(code)) {
            log.info("\u624b\u673a\u53f7[{}]\u9a8c\u8bc1\u7801\u4e0d\u5339\u914d", (Object)phone);
            if (frequency != null && frequency > 0) {
                int newFrequency = frequency - 1;
                log.info("\u624b\u673a\u53f7[{}]\u9a8c\u8bc1\u7801\u5269\u4f59\u5c1d\u8bd5\u6b21\u6570: {}", (Object)phone, (Object)newFrequency);
                this.redisHelper.set(frequencyKey, (Object)newFrequency, 300L);
                if (newFrequency <= 0) {
                    log.info("\u624b\u673a\u53f7[{}]\u9a8c\u8bc1\u6b21\u6570\u5df2\u7528\u5b8c\uff0c\u5220\u9664\u9a8c\u8bc1\u7801", (Object)phone);
                    this.redisHelper.del(new String[]{captchaKey});
                }
            }
            return false;
        }
        log.info("\u624b\u673a\u53f7[{}]\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u6210\u529f", (Object)phone);
        this.redisHelper.del(new String[]{captchaKey});
        if (frequency != null) {
            this.redisHelper.del(new String[]{frequencyKey});
        }
        return true;
    }
}

