/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.eums.UserVipStatusType;
import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nbchat.user.core.busi.ScoreAccountService;
import com.tydic.nbchat.user.core.busi.UserMakeEventSender;
import com.tydic.nbchat.user.core.busi.VipSmsNoticeService;
import com.tydic.nbchat.user.core.config.WchatConfigProperties;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.core.wx.WxSendMsgService;
import com.tydic.nbchat.user.mapper.NbchatUserVipMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserVip;
import com.tydic.nicc.common.nbchat.emus.VipEventType;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VipExpiredCheckService {
    private static final Logger log = LoggerFactory.getLogger(VipExpiredCheckService.class);
    @Resource
    private NbchatUserVipMapper nbchatUserVipMapper;
    private final UserMakeEventSender userMakeEventSender;
    private final WxSendMsgService wxSendMsgService;
    private final VipSmsNoticeService vipSmsNoticeService;
    private final WchatConfigProperties wchatConfigProperties;
    private final ScoreAccountService scoreAccountService;
    private final UserSettingHelper userSettingHelper;

    public VipExpiredCheckService(UserMakeEventSender userMakeEventSender, WxSendMsgService wxSendMsgService, VipSmsNoticeService vipSmsNoticeService, WchatConfigProperties wchatConfigProperties, ScoreAccountService scoreAccountService, UserSettingHelper userSettingHelper) {
        this.userMakeEventSender = userMakeEventSender;
        this.wxSendMsgService = wxSendMsgService;
        this.vipSmsNoticeService = vipSmsNoticeService;
        this.wchatConfigProperties = wchatConfigProperties;
        this.scoreAccountService = scoreAccountService;
        this.userSettingHelper = userSettingHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doVipExpiredCheck(Date checkTime) {
        log.info("\u7528\u6237VIP\u8fc7\u671f\u68c0\u6d4b\uff0c\u5f00\u59cb\u6267\u884c:{}", (Object)checkTime);
        List vips = this.nbchatUserVipMapper.selectExpiredVip(checkTime);
        for (NbchatUserVip userVip : vips) {
            try {
                log.info("\u7528\u6237VIP\u8fc7\u671f\u68c0\u6d4b\uff0c\u5904\u7406\u8fc7\u671f\u8d26\u6237:{}", (Object)userVip);
                NbchatUserVip record = new NbchatUserVip();
                record.setVipStatus(UserVipStatusType.EXPIRED.getCode());
                record.setUpdateTime(new Date());
                record.setId(userVip.getId());
                this.nbchatUserVipMapper.updateByPrimaryKeySelective(record);
                userVip.setVipStatus(UserVipStatusType.EXPIRED.getCode());
                this.userMakeEventSender.sendVipChangeEvent(VipEventType.VIP_EXPIRE.getCode(), userVip, 0, 0);
                this.scoreAccountService.freezeScore(userVip.getTenantCode(), userVip.getUserId(), userVip.getVipType());
            }
            catch (Exception e) {
                log.error("\u7528\u6237VIP\u8fc7\u671f\u68c0\u6d4b\uff0c\u5904\u7406\u5f02\u5e38:{}", (Object)userVip, (Object)e);
            }
            finally {
                try {
                    this.userSettingHelper.removeVipInfo(userVip.getTenantCode(), userVip.getUserId());
                }
                catch (Exception e) {
                    log.error("\u7528\u6237VIP\u8fc7\u671f\u68c0\u6d4b\uff0c\u6e05\u9664\u7f13\u5b58\u5f02\u5e38:{}", (Object)userVip, (Object)e);
                }
            }
        }
        log.info("\u7528\u6237VIP\u8fc7\u671f\u68c0\u6d4b\uff0c\u6267\u884c\u5b8c\u6210:{}", (Object)vips.size());
    }

    public void sendVipExpiredNotice(Date checkTime) {
        log.info("\u53d1\u9001VIP\u8fc7\u671f\u901a\u77e5\uff0c\u5f00\u59cb\u6267\u884c:{}", (Object)checkTime);
        List vips = this.nbchatUserVipMapper.selectExpiredVip(checkTime);
        for (NbchatUserVip userVip : vips) {
            try {
                String vipCloseNotice = this.wchatConfigProperties.getVipCloseNotice();
                vipCloseNotice = vipCloseNotice.replace("#{vipType}", UserVipType.getNameByCode((String)userVip.getVipType()));
                vipCloseNotice = vipCloseNotice.replace("#{endDate}", DateTimeUtil.getTimeShortString((Date)userVip.getVipEnd(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                this.wxSendMsgService.sendTextMsg(userVip.getUserId(), vipCloseNotice);
                this.vipSmsNoticeService.sendVipCloseSms(userVip.getUserId(), UserVipType.getNameByCode((String)userVip.getVipType()), userVip.getVipEnd());
            }
            catch (Exception e) {
                log.error("\u53d1\u9001VIP\u8fc7\u671f\u901a\u77e5\uff0c\u5904\u7406\u5f02\u5e38:{}", (Object)userVip, (Object)e);
            }
        }
        log.info("\u53d1\u9001VIP\u8fc7\u671f\u901a\u77e5\uff0c\u6267\u884c\u5b8c\u6210:{}", (Object)vips.size());
    }
}

