/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.SendSmsRequest;
import com.tydic.nbchat.user.api.bo.eums.SmsHelperType;
import com.tydic.nbchat.user.api.bo.eums.SmsTemplateEnum;
import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nbchat.user.api.bo.eums.VipVersionEnum;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.utils.NbchatSmsProxyHelper;
import com.tydic.nbchat.user.mapper.NbchatUserVipMapper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisZsetHelper;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VipSmsNoticeService {
    private static final Logger log = LoggerFactory.getLogger(VipSmsNoticeService.class);
    private final String SMS_VIP_OPEN_CODE = "SMS_496895420";
    private final String SMS_VIP_PROFESSIONAL_OPEN_CODE = "SMS_489645300";
    private final String SMS_VIP_PROFESSIONAL_MAX_OPEN_CODE = "SMS_489795286";
    private final String SMS_VIP_CLOSE_CODE = "SMS_496855447";
    private final String SMS_VIP_RENEW_CODE = "SMS_496920454";
    private final String SMS_RECHARGE_CODE = "SMS_496725443";
    public static final String NBCHAT_USER_VIP_SMS_NOTICE_0930 = "nbchat:user:vip:sms:notice:delay_0930";
    private final RedisZsetHelper redisZsetHelper;
    private final NbchatSmsProxyHelper nbchatSmsProxyHelper;
    private final UserInfoBusiService userInfoBusiService;
    private final NbchatUserVipMapper nbchatUserVipMapper;

    public VipSmsNoticeService(RedisZsetHelper redisZsetHelper, NbchatSmsProxyHelper nbchatSmsProxyHelper, UserInfoBusiService userInfoBusiService, NbchatUserVipMapper nbchatUserVipMapper) {
        this.redisZsetHelper = redisZsetHelper;
        this.nbchatSmsProxyHelper = nbchatSmsProxyHelper;
        this.userInfoBusiService = userInfoBusiService;
        this.nbchatUserVipMapper = nbchatUserVipMapper;
    }

    private String getPhone(String userId) {
        NbchatUserInfo userInfo = this.userInfoBusiService.getUserBaseInfo(userId);
        if (StringUtils.isBlank((CharSequence)userInfo.getPhone())) {
            throw new RuntimeException("\u7528\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1\u901a\u77e5");
        }
        return userInfo.getPhone();
    }

    public void sendVipCloseSms(String userId, String vipName, Date vipEnd) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("vipName", vipName);
            paramMap.put("vipEnd", DateTimeUtil.getTimeShortString((Date)vipEnd, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
            SendSmsRequest request = SendSmsRequest.builder().signName("\u5317\u4eac\u5929\u6e90\u8fea\u79d1").templateCode("SMS_496855447").phone(this.getPhone(userId)).templateParam(paramMap).build();
            Rsp rsp = this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, request);
            log.info("\u77ed\u4fe1\u63d0\u9192\u3010\u4f1a\u5458\u5230\u671f\u3011: {}|{}", (Object)request, (Object)rsp);
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u63d0\u9192\u3010\u4f1a\u5458\u5230\u671f\u3011-\u5f02\u5e38: {}", (Object)userId, (Object)e);
        }
    }

    public void sendVipOpenSms(String userId, String vipName, Date vipEnd, String vipType, String vipVersion) {
        try {
            String templateCode = this.getVipOpenTemplateCode(vipType, vipVersion);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("vipName", vipName);
            paramMap.put("vipEnd", DateTimeUtil.getTimeShortString((Date)vipEnd, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
            SendSmsRequest request = SendSmsRequest.builder().signName("\u5317\u4eac\u5929\u6e90\u8fea\u79d1").templateCode(templateCode).phone(this.getPhone(userId)).templateParam(paramMap).build();
            Rsp rsp = this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, request);
            log.info("\u77ed\u4fe1\u63d0\u9192\u3010\u4f1a\u5458\u5f00\u901a\u3011: {}|{}", (Object)request, (Object)rsp);
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u63d0\u9192\u3010\u4f1a\u5458\u5f00\u901a\u3011-\u5f02\u5e38: {}", (Object)userId, (Object)e);
        }
    }

    private String getVipOpenTemplateCode(String vipType, String vipVersion) {
        if (StringUtils.isBlank((CharSequence)vipType) || StringUtils.isBlank((CharSequence)vipVersion)) {
            return "SMS_496895420";
        }
        if (UserVipType.PROFESSIONAL.getCode().equals(vipType) && (VipVersionEnum.MONTHLY.getCode().equals(vipVersion) || VipVersionEnum.ANNUAL.getCode().equals(vipVersion))) {
            return "SMS_489645300";
        }
        if (UserVipType.PROFESSIONAL_MAX.getCode().equals(vipType) && VipVersionEnum.MONTHLY.getCode().equals(vipVersion)) {
            return "SMS_489795286";
        }
        return "SMS_496895420";
    }

    public void sendVipRenewSms(String userId, String vipName, Date vipEnd0, Date vipEnd1) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("vipName0", vipName);
            paramMap.put("vipName1", vipName);
            paramMap.put("vipEnd0", DateTimeUtil.getTimeShortString((Date)vipEnd0, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
            paramMap.put("vipEnd1", DateTimeUtil.getTimeShortString((Date)vipEnd1, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
            SendSmsRequest request = SendSmsRequest.builder().signName("\u5317\u4eac\u5929\u6e90\u8fea\u79d1").templateCode("SMS_496920454").phone(this.getPhone(userId)).templateParam(paramMap).build();
            Rsp rsp = this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, request);
            log.info("\u77ed\u4fe1\u63d0\u9192\u3010\u4f1a\u5458\u7eed\u8d39\u3011: {}|{}", (Object)request, (Object)rsp);
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u63d0\u9192\u3010\u4f1a\u5458\u7eed\u8d39\u3011-\u5f02\u5e38: {}", (Object)userId, (Object)e);
        }
    }

    public void sendDouRechargeSms(String userId, int score, String scoreType) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("score", String.valueOf(score));
            paramMap.put("vip_type", UserVipType.getNameByCode((String)scoreType).replace("\u4f1a\u5458", ""));
            SendSmsRequest request = SendSmsRequest.builder().signName("\u5317\u4eac\u5929\u6e90\u8fea\u79d1").templateCode(SmsTemplateEnum.VIP_COMPUTE_POWER_RECHARGE.getTemplateID()).phone(this.getPhone(userId)).templateParam(paramMap).build();
            if (UserVipType.SCORE_PACKAGE.getCode().equals(scoreType)) {
                request.setTemplateCode("SMS_496725443");
                this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, request);
            } else if (this.nbchatUserVipMapper.vipIsToday(userId, scoreType) == 1) {
                request.setTemplateCode(SmsTemplateEnum.VIP_COMPUTE_POWER_RECHARGE_NOTIME.getTemplateID());
                this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, request);
            } else {
                this.redisZsetHelper.zSetAdd(NBCHAT_USER_VIP_SMS_NOTICE_0930, JSON.toJSONString((Object)request), Double.valueOf(System.currentTimeMillis()));
                log.info("\u53d1\u9001\u5ef6\u8fdf\u77ed\u4fe1\u63d0\u9192\u3010\u5145\u503c\u3011: {}", (Object)request);
            }
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u63d0\u9192\u3010\u5145\u503c\u3011-\u5f02\u5e38: {}", (Object)userId, (Object)e);
        }
    }

    public void sendDelayNotice() {
        double currentSecond = System.currentTimeMillis();
        Set strings = this.redisZsetHelper.zSetRangeByScore(NBCHAT_USER_VIP_SMS_NOTICE_0930, Double.valueOf(0.0), Double.valueOf(currentSecond));
        strings.forEach(item -> {
            SendSmsRequest request = (SendSmsRequest)JSON.parseObject((String)item, SendSmsRequest.class);
            Rsp rsp = this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, request);
            log.info("\u5ef6\u8fdf\u53d1\u9001\u77ed\u4fe1\u901a\u77e5: {}|{}", (Object)request, (Object)rsp);
        });
        this.redisZsetHelper.zSetRemoveRangeByScore(NBCHAT_USER_VIP_SMS_NOTICE_0930, Double.valueOf(0.0), Double.valueOf(currentSecond));
    }
}

