/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.bo.auth.UserWxReqeust;
import com.tydic.nbchat.user.api.bo.auth.UserWxResponse;
import com.tydic.nbchat.user.api.bo.eums.AuthType;
import com.tydic.nbchat.user.api.bo.exception.UserLoginException;
import com.tydic.nbchat.user.core.config.WchatConfigProperties;
import com.tydic.nbchat.user.core.enmus.WxChannelEnum;
import com.tydic.nbchat.user.core.vo.WxUserVO;
import com.tydic.nbchat.user.core.wx.WxAuthHelper;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WchatApiHelper {
    private static final Logger log = LoggerFactory.getLogger(WchatApiHelper.class);
    private final WxAuthHelper wxAuthHelper;
    private final RestApiHelper restApiHelper;
    private final WchatConfigProperties wchatConfigProperties;

    public WchatApiHelper(WxAuthHelper wxAuthHelper, RestApiHelper restApiHelper, WchatConfigProperties wchatConfigProperties) {
        this.wxAuthHelper = wxAuthHelper;
        this.restApiHelper = restApiHelper;
        this.wchatConfigProperties = wchatConfigProperties;
    }

    public UserWxResponse getWxInfo(UserWxReqeust reqeust) {
        log.info("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u4fe1\u606f: {}", (Object)reqeust);
        WchatConfigProperties.Property property = WchatApiHelper.getProperty(reqeust.getAuthType(), this.wchatConfigProperties);
        String appId = property.getAppId();
        String appSecret = property.getSecret();
        String code = reqeust.getCode();
        JSONObject accessTokenJson = AuthType.WCHAT_MP_TDH.getCode().equals(reqeust.getAuthType()) || AuthType.WCHAT_MP_TDH_PHONE.getCode().equals(reqeust.getAuthType()) ? this.getMPInfo(WxChannelEnum.WCHAT_MP_TDH.getCode(), appId, appSecret, code) : this.getAccessToken(appId, appSecret, code);
        if (ObjectUtils.isEmpty((Object)accessTokenJson)) {
            throw new UserLoginException("\u5fae\u4fe1\u767b\u5f55\u5f02\u5e38\uff0c\u8ba4\u8bc1\u5931\u8d25 (access_token \u83b7\u53d6\u5931\u8d25): " + String.valueOf(reqeust));
        }
        String openId = accessTokenJson.getString("openid");
        String sessionKey = accessTokenJson.getString("session_key");
        String unionId = accessTokenJson.getString("unionid");
        UserWxResponse userWxResponse = new UserWxResponse();
        userWxResponse.setOpenId(openId);
        userWxResponse.setSessionKey(sessionKey);
        userWxResponse.setUnionId(unionId);
        return userWxResponse;
    }

    static WchatConfigProperties.Property getProperty(String authType, WchatConfigProperties wchatConfigProperties) {
        WchatConfigProperties.Property property = AuthType.WCHAT.getCode().equals(authType) ? wchatConfigProperties.getChannels().get(WxChannelEnum.MOBILE.getCode()) : (AuthType.WCHAT_MP_TDH.getCode().equals(authType) || AuthType.WCHAT_MP_TDH_PHONE.getCode().equals(authType) ? wchatConfigProperties.getChannels().get(WxChannelEnum.WCHAT_MP_TDH.getCode()) : wchatConfigProperties.getChannels().get(WxChannelEnum.PC.getCode()));
        return property;
    }

    public JSONObject getAccessToken(String appId, String appSecret, String code) {
        String baseUrl = "https://api.weixin.qq.com/sns/oauth2/access_token";
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("appid", appId);
        paramMap.put("secret", appSecret);
        paramMap.put("code", code);
        paramMap.put("grant_type", "authorization_code");
        String response = this.restApiHelper.get(baseUrl, "", paramMap);
        JSONObject accessTokenJson = JSONObject.parseObject((String)response);
        if (accessTokenJson.containsKey((Object)"errcode")) {
            log.error("\u7528\u6237\u8ba4\u8bc1-\u83b7\u53d6access_token\u9519\u8bef:{}", (Object)accessTokenJson);
            return null;
        }
        return accessTokenJson;
    }

    public JSONObject getMPInfo(String channel, String appId, String appSecret, String code) {
        String accessToken = this.wxAuthHelper.getAccessToken(channel);
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            log.error("\u7528\u6237\u8ba4\u8bc1-\u83b7\u53d6access_token\u5931\u8d25:{}", (Object)channel);
            throw new UserLoginException("\u5fae\u4fe1\u767b\u5f55\u5f02\u5e38\uff0c\u8ba4\u8bc1\u5931\u8d25 (token \u83b7\u53d6\u5931\u8d25): " + channel);
        }
        String baseUrl = "https://api.weixin.qq.com/sns/jscode2session";
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("appid", appId);
        paramMap.put("secret", appSecret);
        paramMap.put("js_code", code);
        paramMap.put("grant_type", "authorization_code");
        String response = this.restApiHelper.get(baseUrl, "", paramMap);
        JSONObject session = JSONObject.parseObject((String)response);
        if (ObjectUtils.isEmpty((Object)session) || session.containsKey((Object)"errcode")) {
            throw new UserLoginException("\u5fae\u4fe1\u767b\u5f55\u5f02\u5e38\uff0c\u8ba4\u8bc1\u5931\u8d25 (session \u83b7\u53d6\u5931\u8d25): " + channel);
        }
        return session;
    }

    public String refreshAccessToken(String appId, String refreshToken) {
        log.info("\u7528\u6237\u8ba4\u8bc1-\u5237\u65b0access_token");
        String baseUrl = "https://api.weixin.qq.com/sns/oauth2/refresh_token";
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("appid", appId);
        paramMap.put("grant_type", "refresh_token");
        paramMap.put("refresh_token", refreshToken);
        String response = this.restApiHelper.get(baseUrl, "", paramMap);
        JSONObject accessTokenJson = JSONObject.parseObject((String)response);
        log.info("\u7528\u6237\u8ba4\u8bc1-\u5237\u65b0access_token\u7ed3\u679c\uff1a{}", (Object)accessTokenJson);
        if (accessTokenJson.containsKey((Object)"access_token")) {
            String accessToken = accessTokenJson.getString("access_token");
            log.info("\u7528\u6237\u8ba4\u8bc1-\u5237\u65b0access_token\u6210\u529f\uff1a{}", (Object)accessToken);
            return accessToken;
        }
        log.info("\u7528\u6237\u8ba4\u8bc1-\u5237\u65b0access_token\u5931\u8d25");
        return null;
    }

    public WxUserVO getWechatUserInfo(String openId, String accessToken) {
        String baseUrl = "https://api.weixin.qq.com/sns/userinfo";
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("access_token", accessToken);
        paramMap.put("openid", openId);
        paramMap.put("lang", "zh_CN");
        String response = this.restApiHelper.get(baseUrl, "", paramMap);
        WxUserVO user = (WxUserVO)JSON.parseObject((String)response, WxUserVO.class);
        log.info("\u7528\u6237\u8ba4\u8bc1-\u67e5\u8be2\u5fae\u4fe1\u7528\u6237\u4fe1\u606f: {}|{}", (Object)openId, (Object)user);
        return user;
    }

    public String queryPhone(String code) {
        String baseUrl = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=" + this.wxAuthHelper.getAccessToken(WxChannelEnum.WCHAT_MP_TDH.getCode());
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("code", code);
        String response = this.restApiHelper.post(baseUrl, paramMap);
        JSONObject phoneJson = JSONObject.parseObject((String)response);
        if (phoneJson.containsKey((Object)"errcode") && phoneJson.getInteger("errcode") != 0) {
            log.error("\u7528\u6237\u8ba4\u8bc1-\u83b7\u53d6\u624b\u673a\u53f7\u9519\u8bef:{}", (Object)phoneJson);
            return null;
        }
        JSONObject phoneInfo = phoneJson.getJSONObject("phone_info");
        return phoneInfo.getString("phoneNumber");
    }
}

