/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.core.config.WchatMPConfigProperties;
import com.tydic.nbchat.user.core.enmus.WxChannelEnum;
import com.tydic.nbchat.user.core.wx.WxAuthHelper;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class WxMiniProgramService {
    private static final Logger log = LoggerFactory.getLogger(WxMiniProgramService.class);
    private static final String WX_MINI_PROGRAM_QR_CODE_URL = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=";
    private final RestApiHelper restApiHelper;
    private final WxAuthHelper wxAuthHelper;
    private final WchatMPConfigProperties config;

    public WxMiniProgramService(RestApiHelper restApiHelper, WxAuthHelper wxAuthHelper, WchatMPConfigProperties config) {
        this.restApiHelper = restApiHelper;
        this.wxAuthHelper = wxAuthHelper;
        this.config = config;
    }

    public byte[] generateQrCode(String scene) {
        String url = WX_MINI_PROGRAM_QR_CODE_URL + this.wxAuthHelper.getAccessToken(WxChannelEnum.WCHAT_MP_TDH.getCode());
        JSONObject params = new JSONObject();
        params.put("scene", (Object)scene);
        params.put("page", (Object)this.config.getPage());
        params.put("check_path", (Object)this.config.getCheck_path());
        params.put("env_version", (Object)this.config.getEnv_version());
        RestTemplate restTemplate = this.restApiHelper.getRestTemplate();
        ResponseEntity response = restTemplate.postForEntity(url, (Object)params.toJSONString(), byte[].class, new Object[0]);
        if (response.getStatusCode().is2xxSuccessful() && response.getHeaders().getContentType() != null) {
            return (byte[])response.getBody();
        }
        log.error("\u751f\u6210\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\u5931\u8d25: {}", (Object)response);
        return null;
    }
}

