/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.notice.NoticeContext;
import com.tydic.nbchat.user.core.config.WchatConfigProperties;
import com.tydic.nbchat.user.core.wx.WxSendMsgService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WxOfficialNoticeService {
    private static final Logger log = LoggerFactory.getLogger(WxOfficialNoticeService.class);
    @Resource
    WchatConfigProperties wxConfigProperties;
    private final WxSendMsgService wxSendMsgService;

    public WxOfficialNoticeService(WxSendMsgService wxSendMsgService) {
        this.wxSendMsgService = wxSendMsgService;
    }

    public void sendNotice(NoticeContext context) {
        List params;
        Map<String, WchatConfigProperties.TemplateParam> paramMap = this.wxConfigProperties.getTemplates();
        if (!paramMap.containsKey(context.getTemplateType())) {
            log.error("\u6a21\u677f\u6d88\u606f\u7c7b\u578b\u4e0d\u5b58\u5728,templateType:{}", (Object)context.getTemplateType());
            return;
        }
        WchatConfigProperties.TemplateParam templateParam = paramMap.get(context.getTemplateType());
        List<String> keys = templateParam.getKeys();
        if (!this.checkParam(keys, params = context.getParams())) {
            return;
        }
        this.wxSendMsgService.sendTemplateMsg(context);
    }

    public boolean checkParam(List<String> keys, List<String> params) {
        boolean b;
        boolean bl = b = keys.size() == params.size();
        if (!b) {
            log.error("\u6a21\u677f\u6d88\u606f\u53c2\u6570\u4e0d\u5339\u914d:keys={}|params={}", keys, params);
        }
        return b;
    }
}

