/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.consumer;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.user.api.SysMsgApi;
import com.tydic.nbchat.user.api.bo.msg.MsgSendReqBO;
import com.tydic.nicc.common.nbchat.msg.SendMessageContext;
import com.tydic.nicc.mq.starter.annotation.KKMqConsumer;
import com.tydic.nicc.mq.starter.api.KKMqConsumerListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@KKMqConsumer(topic="NBCHAT_SYS_MESSAGE_RECORD_TOPIC", consumerGroup="NBCHAT_SYS_MESSAGE_RECORD_CID")
public class SysMessageRecordConsumer
implements KKMqConsumerListener<SendMessageContext> {
    private static final Logger log = LoggerFactory.getLogger(SysMessageRecordConsumer.class);
    private final SysMsgApi sysMsgApi;

    public void onMessage(SendMessageContext context) {
        log.info("\u6d88\u606f\u53d1\u9001\u76d1\u542c: {}", (Object)JSON.toJSONString((Object)context));
        if (StringUtils.isBlank((CharSequence)context.getTenantCode())) {
            context.setTenantCode("00000000");
        }
        if (StringUtils.isBlank((CharSequence)context.getSenderId())) {
            context.setSenderId("system");
        }
        try {
            MsgSendReqBO param = new MsgSendReqBO();
            param.setTargetTenantCode(context.getTenantCode());
            param.setTpCode(context.getTpCode());
            param.setTitle(context.getTitle());
            param.setSenderId(context.getSenderId());
            param.setPushData(context.getPushData());
            this.sysMsgApi.sendMessage(param);
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u53d1\u9001\u76d1\u542c-\u5f02\u5e38: {}", (Object)context, (Object)e);
        }
    }

    public SysMessageRecordConsumer(SysMsgApi sysMsgApi) {
        this.sysMsgApi = sysMsgApi;
    }
}

