/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.consumer;

import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nbchat.user.api.bo.eums.WxTemplateEnum;
import com.tydic.nbchat.user.api.bo.notice.NoticeContext;
import com.tydic.nbchat.user.api.bo.vip.UserVipOrderContext;
import com.tydic.nbchat.user.core.busi.UserScoreRechargeTaskService;
import com.tydic.nbchat.user.core.busi.WxOfficialNoticeService;
import com.tydic.nicc.mq.starter.annotation.KKMqConsumer;
import com.tydic.nicc.mq.starter.api.KKMqConsumerListener;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@KKMqConsumer(consumerGroup="NBCHAT_USER_RECHARGE_ORDER_CID", topic="NBCHAT_USER_RECHARGE_ORDER")
@Component
public class UserOrderRechargeConsumer
implements KKMqConsumerListener<UserVipOrderContext> {
    private static final Logger log = LoggerFactory.getLogger(UserOrderRechargeConsumer.class);
    private final UserScoreRechargeTaskService userScoreRechargeTaskService;
    private final WxOfficialNoticeService wxOfficialNoticeService;

    public UserOrderRechargeConsumer(UserScoreRechargeTaskService userScoreRechargeTaskService, WxOfficialNoticeService wxOfficialNoticeService) {
        this.userScoreRechargeTaskService = userScoreRechargeTaskService;
        this.wxOfficialNoticeService = wxOfficialNoticeService;
    }

    public void onMessage(UserVipOrderContext userVipOrderContext) {
        this.userScoreRechargeTaskService.handleScoreRechargeTask(userVipOrderContext);
        this.sendRechargeNotice(userVipOrderContext);
    }

    public void sendRechargeNotice(UserVipOrderContext userVipOrderContext) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(userVipOrderContext.getOrderNo());
        params.add(String.valueOf((float)userVipOrderContext.getPayPrice().intValue() / 100.0f));
        params.add(UserVipType.getNameByCode((String)userVipOrderContext.getVipType()));
        NoticeContext context = new NoticeContext();
        context.setUserId(userVipOrderContext.getUserId());
        context.setTemplateType(WxTemplateEnum.RECHARGE.getCode());
        context.setParams(params);
        this.wxOfficialNoticeService.sendNotice(context);
    }
}

