/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service;

import com.tydic.nbchat.user.api.bo.context.TenantBalanceNotificationContext;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceDeductReqBO;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.mapper.NbchatUserBalanceMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserBalance;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TenantBalanceNotificationCheckService {
    private static final Logger log = LoggerFactory.getLogger(TenantBalanceNotificationCheckService.class);
    private final KKMqProducerHelper kkMqProducerHelper;
    private final NbchatUserConfigProperties nbchatUserConfigProperties;
    private final NbchatUserBalanceMapper nbchatUserBalanceMapper;

    public TenantBalanceNotificationCheckService(KKMqProducerHelper kkMqProducerHelper, NbchatUserConfigProperties nbchatUserConfigProperties, NbchatUserBalanceMapper nbchatUserBalanceMapper) {
        this.kkMqProducerHelper = kkMqProducerHelper;
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
        this.nbchatUserBalanceMapper = nbchatUserBalanceMapper;
    }

    public void checkAndSendNotification(UserBalanceDeductReqBO deduct) {
        try {
            if (!this.nbchatUserConfigProperties.getTenantBalanceNotification().getEnable().booleanValue()) {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u529f\u80fd\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7\u901a\u77e5");
                return;
            }
            if (!this.nbchatUserConfigProperties.getTenantBalanceNotification().getCheckOnConsume().booleanValue()) {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u6263\u8d39\u65f6\u68c0\u67e5\u4f59\u989d\u529f\u80fd\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7\u901a\u77e5");
                return;
            }
            if (!"00000000".equals(deduct.getTenantCode())) {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u975e\u4f01\u4e1a\u7528\u6237\uff0c\u8df3\u8fc7\u901a\u77e5");
                return;
            }
            List<String> excludeTenants = this.nbchatUserConfigProperties.getTenantBalanceNotification().getExcludeTenants();
            if (excludeTenants.contains(deduct.getTenantCode())) {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u79df\u6237{}\u5728\u6392\u9664\u5217\u8868\u4e2d\uff0c\u8df3\u8fc7\u901a\u77e5", (Object)deduct.getTenantCode());
                return;
            }
            NbchatUserBalance balance = this.nbchatUserBalanceMapper.selectByUserId(deduct.getTenantCode(), deduct.getTenantCode());
            if (balance == null) {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u79df\u6237{}\u4f59\u989d\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u901a\u77e5", (Object)deduct.getTenantCode());
                return;
            }
            Integer threshold = this.nbchatUserConfigProperties.getTenantBalanceNotification().getBalanceThreshold();
            Integer currentBalance = balance.getScore();
            if (currentBalance != null && currentBalance < threshold) {
                log.info("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u79df\u6237{}\u4f59\u989d\u4e0d\u8db3\uff0c\u5f53\u524d\u4f59\u989d{}\uff0c\u9608\u503c{}\uff0c\u53d1\u9001\u901a\u77e5", new Object[]{deduct.getTenantCode(), currentBalance, threshold});
                this.sendTenantBalanceNotification(deduct.getTenantCode(), deduct.getScore());
            } else {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u79df\u6237{}\u4f59\u989d\u5145\u8db3\uff0c\u5f53\u524d\u4f59\u989d{}\uff0c\u9608\u503c{}\uff0c\u4e0d\u53d1\u9001\u901a\u77e5", new Object[]{deduct.getTenantCode(), currentBalance, threshold});
            }
        }
        catch (Exception e) {
            log.error("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u68c0\u67e5\u5e76\u53d1\u9001\u901a\u77e5\u5f02\u5e38\uff0c\u4f46\u4e0d\u5f71\u54cd\u6263\u8d39\u6d41\u7a0b: {}", (Object)deduct.getTenantCode(), (Object)e);
        }
    }

    public void checkAndSendNotification(UserBalanceDeductReqBO deduct, Integer currentBalance) {
        try {
            if (!this.nbchatUserConfigProperties.getTenantBalanceNotification().getEnable().booleanValue()) {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u529f\u80fd\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7\u901a\u77e5");
                return;
            }
            if (!this.nbchatUserConfigProperties.getTenantBalanceNotification().getCheckOnConsume().booleanValue()) {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u6263\u8d39\u65f6\u68c0\u67e5\u4f59\u989d\u529f\u80fd\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7\u901a\u77e5");
                return;
            }
            if ("00000000".equals(deduct.getTenantCode())) {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u975e\u4f01\u4e1a\u7528\u6237\uff0c\u8df3\u8fc7\u901a\u77e5");
                return;
            }
            List<String> excludeTenants = this.nbchatUserConfigProperties.getTenantBalanceNotification().getExcludeTenants();
            if (excludeTenants.contains(deduct.getTenantCode())) {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u79df\u6237{}\u5728\u6392\u9664\u5217\u8868\u4e2d\uff0c\u8df3\u8fc7\u901a\u77e5", (Object)deduct.getTenantCode());
                return;
            }
            Integer threshold = this.nbchatUserConfigProperties.getTenantBalanceNotification().getBalanceThreshold();
            if (currentBalance != null && currentBalance < threshold) {
                log.info("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u79df\u6237{}\u4f59\u989d\u4e0d\u8db3\uff0c\u5f53\u524d\u4f59\u989d{}\uff0c\u9608\u503c{}\uff0c\u53d1\u9001\u901a\u77e5", new Object[]{deduct.getTenantCode(), currentBalance, threshold});
                this.sendTenantBalanceNotification(deduct.getTenantCode(), deduct.getScore());
            } else {
                log.debug("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u79df\u6237{}\u4f59\u989d\u5145\u8db3\uff0c\u5f53\u524d\u4f59\u989d{}\uff0c\u9608\u503c{}\uff0c\u4e0d\u53d1\u9001\u901a\u77e5", new Object[]{deduct.getTenantCode(), currentBalance, threshold});
            }
        }
        catch (Exception e) {
            log.error("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u68c0\u67e5\u5e76\u53d1\u9001\u901a\u77e5\u5f02\u5e38\uff0c\u4f46\u4e0d\u5f71\u54cd\u6263\u8d39\u6d41\u7a0b: {}", (Object)deduct.getTenantCode(), (Object)e);
        }
    }

    private void sendTenantBalanceNotification(String tenantCode, Integer consumeScore) {
        try {
            TenantBalanceNotificationContext context = new TenantBalanceNotificationContext();
            context.setTenantCode(tenantCode);
            context.setUserId(tenantCode);
            context.setConsumeScore(consumeScore);
            context.setEventTime(new Date());
            log.info("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u53d1\u9001\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u6d88\u606f: {}", (Object)context);
            this.kkMqProducerHelper.sendMsg("NBCHAT_USER_BALANCE_WARN", (Object)context);
        }
        catch (Exception e) {
            log.error("\u3010\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u3011\u53d1\u9001\u4f01\u4e1a\u4f59\u989d\u901a\u77e5\u6d88\u606f\u5f02\u5e38\uff0c\u4f46\u4e0d\u5f71\u54cd\u6263\u8d39\u6d41\u7a0b: {}", (Object)tenantCode, (Object)e);
        }
    }
}

