/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.AuthenticationService;
import com.tydic.nbchat.user.api.bo.ShareSignReqBO;
import com.tydic.nbchat.user.core.config.WchatConfigProperties;
import com.tydic.nbchat.user.core.enmus.WxChannelEnum;
import com.tydic.nbchat.user.core.wx.WxAuthHelper;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="authentication")
public class AuthenticationImpl
implements AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationImpl.class);
    private final WchatConfigProperties wchatConfigProperties;
    private final RedisHelper redisHelper;
    private final RestApiHelper restApiHelper;
    private final WxAuthHelper wxAuthHelper;

    public AuthenticationImpl(WchatConfigProperties wchatConfigProperties, RedisHelper redisHelper, RestApiHelper restApiHelper, WxAuthHelper wxAuthHelper) {
        this.wchatConfigProperties = wchatConfigProperties;
        this.redisHelper = redisHelper;
        this.restApiHelper = restApiHelper;
        this.wxAuthHelper = wxAuthHelper;
    }

    @MethodParamVerifyEnable
    public Rsp sign(ShareSignReqBO shareSignReqBO) {
        String jsapiTicket;
        log.info("\u7b7e\u540d-\u5165\u53c2\uff1a{}", (Object)shareSignReqBO);
        String url = shareSignReqBO.getUrl();
        Object jsk = this.redisHelper.get("nbchat-user:wx_sign");
        String string = jsapiTicket = jsk == null ? null : jsk.toString();
        if (StringUtils.isEmpty((CharSequence)jsapiTicket)) {
            log.info("\u7b7e\u540d-\u83b7\u53d6access_token");
            String accessToken = this.wxAuthHelper.getAccessToken(WxChannelEnum.MOBILE.getCode());
            if (accessToken == null) {
                log.error("\u7b7e\u540d-\u83b7\u53d6access_token\u5931\u8d25");
                return BaseRspUtils.createErrorRsp((String)"\u83b7\u53d6\u7b7e\u540d\u5931\u8d25-\u83b7\u53d6access_token\u5931\u8d25");
            }
            log.info("\u7b7e\u540d-\u83b7\u53d6jsapi_ticket");
            jsapiTicket = this.getJsapiTicket(accessToken);
            if (jsapiTicket == null) {
                log.error("\u7b7e\u540d-\u83b7\u53d6jsapi_ticket\u5931\u8d25");
                return BaseRspUtils.createErrorRsp((String)"\u83b7\u53d6\u7b7e\u540d\u5931\u8d25-\u83b7\u53d6jsapi_ticket\u5931\u8d25");
            }
            log.info("\u7b7e\u540d-\u5c06jsapi_ticket\u5b58\u5165redis");
            this.redisHelper.set("nbchat-user:wx_sign", (Object)jsapiTicket, 7000L);
        }
        log.info("\u7b7e\u540d-\u8fdb\u884c\u62fc\u63a5\u5b57\u7b26\u4e32");
        String timestamp = String.valueOf(this.getCurrentTimestamp());
        String nonceStr = this.generateRandomString(16);
        StringBuilder str = new StringBuilder();
        str.append("jsapi_ticket=").append(jsapiTicket).append("&noncestr=").append(nonceStr).append("&timestamp=").append(timestamp).append("&url=").append(url);
        log.info("\u7b7e\u540d-\u62fc\u63a5\u5b57\u7b26\u4e32:{}", (Object)str);
        log.info("\u7b7e\u540d-\u8fdb\u884c\u5b57\u7b26\u4e32\u7b7e\u540d");
        String signature = this.getSHA1(str.toString());
        log.info("\u7b7e\u540d-\u7b7e\u540d\u6210\u529f:{}", (Object)signature);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", this.wchatConfigProperties.getChannels().get(WxChannelEnum.MOBILE.getCode()).getAppId());
        map.put("timestamp", timestamp);
        map.put("nonceStr", nonceStr);
        map.put("signature", signature);
        log.info("\u7b7e\u540d-\u8fd4\u56de\u6570\u636e:{}", map);
        return BaseRspUtils.createSuccessRsp(map, (String)"\u7b7e\u540d\u6210\u529f");
    }

    private String getJsapiTicket(String accessToken) {
        String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("access_token", accessToken);
        paramMap.put("type", "jsapi");
        String response = this.restApiHelper.get(url, "", paramMap);
        JSONObject accessTokenJson = JSONObject.parseObject((String)response);
        if (accessTokenJson.containsKey((Object)"ticket")) {
            String jsapiTicket = accessTokenJson.getString("ticket");
            log.info("\u7b7e\u540d-\u83b7\u53d6jsapi_ticket\u6210\u529f:{}", (Object)jsapiTicket);
            return jsapiTicket;
        }
        log.error("\u7b7e\u540d-\u83b7\u53d6jsapi_ticket\u9519\u8bef");
        return null;
    }

    public String getSHA1(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] messageDigest = md.digest(input.getBytes(StandardCharsets.UTF_8));
            return this.bytesToHex(messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u7b7e\u540d-\u83b7\u53d6SHA-1\u7b97\u6cd5\u5931\u8d25");
            throw new RuntimeException("Error: SHA-1 algorithm not found", e);
        }
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public long getCurrentTimestamp() {
        LocalDateTime now = LocalDateTime.now();
        ZonedDateTime zdt = now.atZone(ZoneId.systemDefault());
        return zdt.toInstant().getEpochSecond();
    }

    public String generateRandomString(int length) {
        String characterSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder randomString = new StringBuilder(length);
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt(characterSet.length());
            char randomChar = characterSet.charAt(randomIndex);
            randomString.append(randomChar);
        }
        return randomString.toString();
    }
}

