/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.BindInviteCodeReqBO;
import com.tydic.nbchat.user.api.bo.BindPhoneNumberReqBO;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.UserBO;
import com.tydic.nbchat.user.api.bo.eums.AuthType;
import com.tydic.nbchat.user.api.bo.eums.JoinTenantType;
import com.tydic.nbchat.user.api.bo.exception.UserLoginException;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.UserLoginEventService;
import com.tydic.nbchat.user.core.busi.UserLoginLockBusiService;
import com.tydic.nbchat.user.core.busi.UserPhoneBindBusiService;
import com.tydic.nbchat.user.core.busi.UserPhoneLoginBusiService;
import com.tydic.nbchat.user.core.busi.UserWchatLoginBusiService;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.InviteCodeMapper;
import com.tydic.nbchat.user.mapper.po.InviteCodePO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class NbchatUserApiServiceImpl
implements NbchatUserApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatUserApiServiceImpl.class);
    @Resource
    private InviteCodeMapper inviteCodeMapper;
    private final UserSettingHelper userSettingHelper;
    private final UserLoginEventService userLoginEventService;
    private final UserInfoBusiService userInfoBusiService;
    private final UserWchatLoginBusiService userWchatLoginBusiService;
    private final UserPhoneLoginBusiService userPhoneLoginBusiService;
    private final UserPhoneBindBusiService userPhoneBindBusiService;
    private final UserLoginLockBusiService userLoginLockBusiService;

    public NbchatUserApiServiceImpl(InviteCodeMapper inviteCodeMapper, UserSettingHelper userSettingHelper, UserLoginEventService userLoginEventService, UserInfoBusiService userInfoBusiService, UserWchatLoginBusiService userWchatLoginBusiService, UserPhoneLoginBusiService userPhoneLoginBusiService, UserPhoneBindBusiService userPhoneBindBusiService, UserLoginLockBusiService userLoginLockBusiService) {
        this.inviteCodeMapper = inviteCodeMapper;
        this.userSettingHelper = userSettingHelper;
        this.userLoginEventService = userLoginEventService;
        this.userInfoBusiService = userInfoBusiService;
        this.userWchatLoginBusiService = userWchatLoginBusiService;
        this.userPhoneLoginBusiService = userPhoneLoginBusiService;
        this.userPhoneBindBusiService = userPhoneBindBusiService;
        this.userLoginLockBusiService = userLoginLockBusiService;
    }

    public void cleanCache(String tenantCode, String userId) {
        this.userSettingHelper.cleanUserCache(tenantCode, userId);
    }

    public Rsp<NbchatUserInfo> getUserInfo(String userId) {
        NbchatUserInfo userInfo = this.userInfoBusiService.getUserInfo(userId);
        if (userInfo == null) {
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5931\u8d25:\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return BaseRspUtils.createSuccessRsp((Object)userInfo, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public Rsp<NbchatUserInfo> getUserInfoByPlatform(String userId, String platform) {
        try {
            NbchatUserInfo userInfo = this.userInfoBusiService.getUserInfo(userId, platform);
            if (userInfo == null) {
                return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5931\u8d25:\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            }
            return BaseRspUtils.createSuccessRsp((Object)userInfo, (String)"\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38:{}", (Object)userId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @Deprecated
    public Rsp bindInviteCode(BindInviteCodeReqBO reqBO) {
        String userId = reqBO.getUserId();
        String inviteCode = reqBO.getInviteCode();
        InviteCodePO inviteCodePO = new InviteCodePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)inviteCodePO);
        log.info("\u9a8c\u8bc1\u9080\u8bf7\u7801-\u5f00\u59cb:{}", (Object)reqBO);
        if (StringUtils.isEmpty((CharSequence)userId) || StringUtils.isEmpty((CharSequence)inviteCode)) {
            log.warn("\u9a8c\u8bc1\u9080\u8bf7\u7801-\u586b\u5199\u9080\u8bf7\u7801\u4e3a\u7a7a:{}", (Object)userId);
            return BaseRspUtils.createErrorRsp((String)"\u9080\u8bf7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InviteCodePO invite = this.inviteCodeMapper.selectInviteCode(inviteCode);
        if (invite == null) {
            log.warn("\u9a8c\u8bc1\u9080\u8bf7\u7801-\u9080\u8bf7\u7801\u4e0d\u5b58\u5728:{}", (Object)userId);
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u9080\u8bf7\u7801");
        }
        if (invite.getIsDeleted().booleanValue()) {
            log.warn("\u9a8c\u8bc1\u9080\u8bf7\u7801-\u9080\u8bf7\u7801\u5df2\u88ab\u4f7f\u7528:{}|{}", (Object)userId, (Object)inviteCode);
            return BaseRspUtils.createErrorRsp((String)"\u9080\u8bf7\u7801\u5df2\u4f7f\u7528");
        }
        NbchatUserInfo userInfo = this.userInfoBusiService.getUserBaseInfo(userId);
        if (userInfo == null) {
            log.warn("\u9a8c\u8bc1\u9080\u8bf7\u7801-\u7528\u6237\u4e0d\u5b58\u5728:{}|{}", (Object)userId, (Object)inviteCode);
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u4f7f\u7528\u5df2\u6ce8\u518c\u7684\u8d26\u53f7\u8fdb\u884c\u7ed1\u5b9a");
        }
        if (userInfo.getStatus() == 2) {
            log.warn("\u9a8c\u8bc1\u9080\u8bf7\u7801-\u91cd\u590d\u6d88\u8d39\u9080\u8bf7\u7801:{}|{}", (Object)userId, (Object)inviteCode);
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u52ff\u91cd\u590d\u586b\u5199\u9080\u8bf7\u7801");
        }
        int rowsAffected = 0;
        try {
            rowsAffected = invite.getExpTime() == null ? this.inviteCodeMapper.validateInviteCode(userId, inviteCode) : this.inviteCodeMapper.validateInviteCodeInExpTime(userId, inviteCode);
            if (rowsAffected > 0) {
                log.info("\u9a8c\u8bc1\u9080\u8bf7\u7801-\u9a8c\u8bc1\u7801\u9080\u8bf7\u7801\u6210\u529f:{}|{}", (Object)userId, (Object)inviteCode);
                this.userSettingHelper.removeInfo(userId);
                return BaseRspUtils.createSuccessRsp((Object)userId, (String)"\u9a8c\u8bc1\u9080\u8bf7\u7801\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u9080\u8bf7\u7801-\u9a8c\u8bc1\u9080\u8bf7\u7801\u5f02\u5e38:{}|{}", (Object)userId, (Object)inviteCode);
        }
        return BaseRspUtils.createErrorRsp((String)"\u9a8c\u8bc1\u9080\u8bf7\u7801\u5931\u8d25");
    }

    public Rsp<NbchatUserInfo> authUser(AuthUserReqBO authUserReqBO) {
        String type = authUserReqBO.getAuthType();
        String loginClient = authUserReqBO.getLoginClient();
        log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u5f00\u59cb: {}", (Object)type, (Object)authUserReqBO);
        NbchatUserInfo userInfo = null;
        try {
            if (AuthType.PHONE.getCode().equals(type)) {
                userInfo = this.userPhoneLoginBusiService.mobileLogin(authUserReqBO);
            } else if (AuthType.WCHAT_MP_TDH_PHONE.getCode().equals(type)) {
                loginClient = JoinTenantType.TDH_MINI_APP.getName();
                userInfo = this.userPhoneLoginBusiService.mobileMpLogin(authUserReqBO);
            } else if (AuthType.WCHAT.getCode().equals(type) || AuthType.WCHAT_PC.getCode().equals(type) || AuthType.WCHAT_PC_OFFICIAL.getCode().equals(type) || AuthType.WCHAT_MP_TDH.getCode().equals(type)) {
                log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u5fae\u4fe1\u767b\u5f55: {}", (Object)type, (Object)authUserReqBO);
                userInfo = this.userWchatLoginBusiService.wechatLogin(authUserReqBO);
                userInfo.setStatus(Integer.valueOf(2));
            } else {
                log.warn("\u7528\u6237\u8ba4\u8bc1[{}]-\u672a\u77e5\u8ba4\u8bc1\u7c7b\u578b: {}", (Object)type, (Object)authUserReqBO);
                return BaseRspUtils.createErrorRsp((String)"\u672a\u77e5\u8ba4\u8bc1\u7c7b\u578b");
            }
            if (this.userLoginLockBusiService.hasLockAccount(userInfo.getUserId())) {
                log.warn("\u7528\u6237\u8ba4\u8bc1[{}]-\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a: {}", (Object)type, (Object)userInfo.getUserId());
                return BaseRspUtils.createErrorRsp((String)"\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            log.info("\u7528\u6237\u8ba4\u8bc1[{}]-\u6210\u529f: {}", (Object)type, (Object)userInfo.getUserId());
            this.userLoginEventService.sendLoginEvent(userInfo, type, authUserReqBO.getLoginIp(), authUserReqBO.getLoginUa(), loginClient, "");
            return BaseRspUtils.createSuccessRsp((Object)userInfo, (String)"\u8ba4\u8bc1\u6210\u529f");
        }
        catch (UserLoginException e) {
            log.warn("\u7528\u6237\u8ba4\u8bc1[{}]-\u5931\u8d25: {}", (Object)type, (Object)authUserReqBO);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        catch (Exception e1) {
            log.error("\u7528\u6237\u8ba4\u8bc1[{}]-\u5f02\u5e38: {}", new Object[]{type, authUserReqBO, e1});
            return BaseRspUtils.createErrorRsp((String)"\u8ba4\u8bc1\u5931\u8d25: \u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef!");
        }
    }

    public Rsp bindPhoneNumber(BindPhoneNumberReqBO reqBO) {
        return this.userPhoneBindBusiService.bindPhoneNumber(reqBO);
    }

    public Rsp bindPhoneByMPCode(BindPhoneNumberReqBO reqBO) {
        return this.userPhoneBindBusiService.bindPhoneByMPCode(reqBO);
    }

    public Rsp updateById(UserBO userBO) {
        return this.userInfoBusiService.updateById(userBO);
    }

    public Rsp<NbchatUserInfo> getUserByPhone(String phone) {
        return this.userInfoBusiService.getUserByPhone(phone);
    }

    public RspList<NbchatUserInfo> getUserInfoList(List<String> userIdList) {
        return this.userInfoBusiService.getUserInfoList(userIdList);
    }
}

