/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.NbchatUserAssistDetailApi;
import com.tydic.nbchat.user.api.bo.NbchatUserAssisReqBo;
import com.tydic.nbchat.user.api.bo.NbchatUserAssistDetailReqBo;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.constants.UserAssistConstants;
import com.tydic.nbchat.user.api.bo.eums.AssistType;
import com.tydic.nbchat.user.api.bo.vip.UserVipOrderContext;
import com.tydic.nbchat.user.mapper.NbchatUserAssistDetailMapper;
import com.tydic.nbchat.user.mapper.NbchatUserAssistMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserAssist;
import com.tydic.nbchat.user.mapper.po.NbchatUserAssistDetail;
import com.tydic.nbchat.user.mapper.po.NbchatUserAssistResult;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class NbchatUserAssistDetailServicelmpl
implements NbchatUserAssistDetailApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatUserAssistDetailServicelmpl.class);
    private final NbchatUserAssistDetailMapper nbchatUserAssistDetailMapper;
    private final NbchatUserAssistMapper nbchatUserAssistMapper;
    private final NbchatUserApi nbchatUserApi;
    private final RedisHelper redisHelper;
    private final KKMqProducerHelper kkMqProducerHelper;

    public NbchatUserAssistDetailServicelmpl(NbchatUserAssistDetailMapper nbchatUserAssistDetailMapper, RedisHelper redisHelper, NbchatUserAssistMapper nbchatUserAssistMapper, NbchatUserApi nbchatUserApi, KKMqProducerHelper kkMqProducerHelper) {
        this.nbchatUserAssistDetailMapper = nbchatUserAssistDetailMapper;
        this.redisHelper = redisHelper;
        this.nbchatUserAssistMapper = nbchatUserAssistMapper;
        this.nbchatUserApi = nbchatUserApi;
        this.kkMqProducerHelper = kkMqProducerHelper;
    }

    public Rsp createAssist(NbchatUserAssistDetailReqBo reqBo) {
        log.info("\u751f\u6210\u9080\u8bf7\u7801: {}|{}", (Object)reqBo.getTenantCode(), (Object)reqBo.getUserId());
        NbchatUserAssist nbchatUserAssist = new NbchatUserAssist();
        nbchatUserAssist.setAssistId(IdWorker.nextAutoIdStr());
        nbchatUserAssist.setTenantCode(reqBo.getTenantCode());
        nbchatUserAssist.setUserId(reqBo.getUserId());
        nbchatUserAssist.setAssistType(AssistType.EXPERIENCE.getCode());
        nbchatUserAssist.setNeedNum(UserAssistConstants.USER_ASSIST_STATUS_INVITE);
        nbchatUserAssist.setBusiType("");
        nbchatUserAssist.setAssistStatus("0");
        nbchatUserAssist.setStartTime(new Date());
        Date endTime = DateTimeUtil.getEndTimeOfDay();
        nbchatUserAssist.setEndTime(endTime);
        this.nbchatUserAssistMapper.insert(nbchatUserAssist);
        this.cacheAssistInfo(reqBo.getUserId(), 0, "0", nbchatUserAssist.getNeedNum());
        return BaseRspUtils.createSuccessRsp((Object)nbchatUserAssist);
    }

    private void cacheAssistInfo(String userId, int assistCount, String assistStatus, int needNum) {
        String key = "nbchat-user:user_id:" + userId;
        JSONObject assistInfo = new JSONObject();
        assistInfo.put("assistCount", (Object)assistCount);
        assistInfo.put("assistStatus", (Object)assistStatus);
        assistInfo.put("needNum", (Object)needNum);
        this.redisHelper.set(key, (Object)assistInfo.toJSONString());
        this.redisHelper.expire(key, 86400L);
    }

    private boolean isNewUser(Date createTime) {
        if (createTime == null) {
            return false;
        }
        long diffHours = (System.currentTimeMillis() - createTime.getTime()) / 3600000L;
        return diffHours < 24L;
    }

    @Transactional
    public Rsp submitAssist(NbchatUserAssistDetailReqBo reqBo) {
        Rsp userRsp = this.nbchatUserApi.getUserInfo(reqBo.getUserId());
        if (!userRsp.isSuccess() || userRsp.getData() == null) {
            return BaseRspUtils.createSuccessRsp((Object)"\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        NbchatUserInfo userInfo = (NbchatUserInfo)userRsp.getData();
        if (!this.isNewUser(userInfo.getRegTime())) {
            log.info("\u8001\u7528\u6237\u4e0d\u5141\u8bb8\u52a9\u529b\uff0c\u7528\u6237ID: {}", (Object)reqBo.getUserId());
            return BaseRspUtils.createSuccessRsp((Object)"\u4ec5\u9650\u65b0\u6ce8\u518c\u7528\u6237\u53c2\u4e0e\u52a9\u529b");
        }
        NbchatUserAssistDetail existingHelp = this.nbchatUserAssistDetailMapper.selectByUserId(reqBo.getUserId());
        if (existingHelp != null) {
            return BaseRspUtils.createSuccessRsp((Object)"\u60a8\u5df2\u7ecf\u53c2\u4e0e\u8fc7\u5176\u4ed6\u52a9\u529b\u6d3b\u52a8");
        }
        NbchatUserAssist assist = this.nbchatUserAssistMapper.selectByPrimaryKey(reqBo.getAssistId());
        if (assist == null || assist.getEndTime().before(new Date())) {
            return BaseRspUtils.createSuccessRsp((Object)"\u52a9\u529b\u5df2\u8fc7\u671f\u6216\u4e0d\u5b58\u5728");
        }
        NbchatUserAssistDetail existingDetail = this.nbchatUserAssistDetailMapper.selectByUserIdAndAssistId(reqBo.getUserId(), reqBo.getAssistId());
        if (existingDetail != null) {
            return BaseRspUtils.createSuccessRsp((Object)"\u60a8\u5df2\u7ecf\u52a9\u529b\u8fc7\u4e86");
        }
        NbchatUserAssistDetail detail = new NbchatUserAssistDetail();
        detail.setTenantCode(reqBo.getTenantCode());
        detail.setUserId(reqBo.getUserId());
        detail.setAssistId(reqBo.getAssistId());
        detail.setAssistTime(new Date());
        this.nbchatUserAssistDetailMapper.insert(detail);
        int currentAssists = this.nbchatUserAssistDetailMapper.countByAssistId(reqBo.getAssistId());
        String assistStatus = assist.getAssistStatus();
        if (currentAssists >= assist.getNeedNum()) {
            Date endTime = DateTimeUtil.getEndTimeOfDay();
            assist.setEndTime(endTime);
            this.nbchatUserAssistMapper.updateByPrimaryKey(assist);
            assistStatus = "1";
        }
        this.cacheAssistInfo(assist.getUserId(), currentAssists, assistStatus, assist.getNeedNum());
        this.sendExperienceVipMessage(assist, currentAssists);
        if ("1".equals(assistStatus)) {
            return BaseRspUtils.createSuccessRsp((Object)"\u52a9\u529b\u6210\u529f\uff0c\u4f1a\u5458\u5956\u52b1\u6210\u529f\uff01");
        }
        int remainingAssists = assist.getNeedNum() - currentAssists;
        return BaseRspUtils.createSuccessRsp((Object)("\u52a9\u529b\u6210\u529f\uff0c\u8fd8\u9700\u9080\u8bf7 " + remainingAssists + " \u4eba"));
    }

    private void sendExperienceVipMessage(NbchatUserAssist assist, int days) {
        String id = IdWorker.nextAutoIdStr();
        UserVipOrderContext eventContext = UserVipOrderContext.builder().tenantCode(assist.getTenantCode()).userId(assist.getUserId()).orderNo("assist_" + id).tradeNo("assist_" + id).orderTime(new Date()).score(Integer.valueOf(0)).cycle(Integer.valueOf(1)).days(Integer.valueOf(days)).vipType(AssistType.EXPERIENCE.getCode()).payPrice(Integer.valueOf(0)).build();
        try {
            log.info("\u52a9\u529b\u4f1a\u5458\u5145\u503c-\u63a8\u9001\u4e8b\u4ef6\u6d88\u606f: {}", (Object)eventContext);
            this.kkMqProducerHelper.sendMsg("NBCHAT_USER_RECHARGE_ORDER", (Object)eventContext);
            assist.setAssistStatus("1");
            this.nbchatUserAssistMapper.updateByPrimaryKeySelective(assist);
            log.info("assistStatus \u66f4\u65b0\u6210\u529f: assistId={}, userId={}", (Object)assist.getAssistId(), (Object)assist.getUserId());
        }
        catch (Exception e) {
            log.info("\u52a9\u529b\u4f1a\u5458\u5145\u503c-\u63a8\u9001\u4e8b\u4ef6\u6d88\u606f-\u5f02\u5e38: {}", (Object)eventContext, (Object)e);
            throw new RuntimeException("\u53d1\u9001\u4f1a\u5458\u53d8\u66f4\u6d88\u606f\u5931\u8d25", e);
        }
    }

    public Rsp checkAssist(NbchatUserAssisReqBo reqBo) {
        String key = "nbchat-user:user_id:" + reqBo.getUserId();
        String cachedAssistInfo = (String)this.redisHelper.get(key);
        if (cachedAssistInfo != null) {
            try {
                JSONObject result = JSON.parseObject((String)cachedAssistInfo);
                return BaseRspUtils.createSuccessRsp((Object)result);
            }
            catch (Exception e) {
                log.info("\u89e3\u6790\u7f13\u5b58\u5931\u8d25: {}", (Object)e.getMessage());
                return BaseRspUtils.createErrorRsp((String)"\u89e3\u6790\u7f13\u5b58\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
            }
        }
        NbchatUserAssist assist = this.nbchatUserAssistMapper.selectById(reqBo.getAssistId(), reqBo.getUserId(), reqBo.getTenantCode());
        if (assist == null) {
            return BaseRspUtils.createErrorRsp((String)"\u52a9\u529b\u4fe1\u606f\u672a\u627e\u5230");
        }
        if (assist.getEndTime().before(new Date())) {
            return BaseRspUtils.createErrorRsp((String)"\u52a9\u529b\u5df2\u8fc7\u671f");
        }
        int assistCount = this.nbchatUserAssistDetailMapper.countByAssistId(reqBo.getAssistId());
        String assistStatus = assist.getAssistStatus();
        int needNum = assist.getNeedNum();
        this.cacheAssistInfo(reqBo.getUserId(), assistCount, assistStatus, needNum);
        JSONObject result = new JSONObject();
        result.put("assistStatus", (Object)assistStatus);
        result.put("assistCount", (Object)assistCount);
        result.put("needNum", (Object)needNum);
        return BaseRspUtils.createSuccessRsp((Object)result);
    }

    public Rsp getAssistInfo(NbchatUserAssisReqBo reqBo) {
        List assistDetails = this.nbchatUserAssistMapper.selectUserAssistInfo(reqBo.getUserId(), reqBo.getTenantCode());
        for (NbchatUserAssistResult detail : assistDetails) {
            String phone = detail.getPhone();
            if (phone == null || phone.length() != 11) continue;
            String hiddenPhone = phone.substring(0, 3) + "****" + phone.substring(7);
            detail.setPhone(hiddenPhone);
        }
        return BaseRspUtils.createSuccessRsp((Object)assistDetails);
    }
}

