/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.tydic.nbchat.user.api.NbchatUserRegLoginApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.JoinTenantType;
import com.tydic.nbchat.user.api.bo.eums.UserRegSourceEnum;
import com.tydic.nbchat.user.api.bo.login.UserLoginReqBO;
import com.tydic.nbchat.user.api.bo.mq.UserRegistContext;
import com.tydic.nbchat.user.api.bo.regist.UserRegistReqBO;
import com.tydic.nbchat.user.core.busi.UserAccountUnRegBusiService;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.UserPasswordLoginBusiService;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class NbchatUserRegLoginServiceImpl
implements NbchatUserRegLoginApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatUserRegLoginServiceImpl.class);
    private final UserSettingHelper userSettingHelper;
    private final UserPasswordLoginBusiService userPasswordLoginBusiService;
    private final UserAccountUnRegBusiService userAccountUnRegBusiService;
    private final UserInfoBusiService userInfoBusiService;
    private final RedisHelper redisHelper;

    public NbchatUserRegLoginServiceImpl(UserSettingHelper userSettingHelper, UserPasswordLoginBusiService userPasswordLoginBusiService, UserAccountUnRegBusiService userAccountUnRegBusiService, UserInfoBusiService userInfoBusiService, RedisHelper redisHelper) {
        this.userSettingHelper = userSettingHelper;
        this.userPasswordLoginBusiService = userPasswordLoginBusiService;
        this.userAccountUnRegBusiService = userAccountUnRegBusiService;
        this.userInfoBusiService = userInfoBusiService;
        this.redisHelper = redisHelper;
    }

    public Rsp logout(String userId) {
        this.userSettingHelper.removeInfo(userId);
        return BaseRspUtils.createSuccessRsp((Object)userId);
    }

    @MethodParamVerifyEnable
    public Rsp login(UserLoginReqBO loginReqBO) {
        return this.userPasswordLoginBusiService.passwordLogin(loginReqBO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodParamVerifyEnable
    public Rsp regist(UserRegistReqBO request) {
        String key = "nbchat-user:reg-lock:" + request.getUsername();
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(key).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity, 300L, 20L);
        try {
            if (locked) {
                log.info("\u7528\u6237\u6ce8\u518c-\u5f00\u59cb: {}", (Object)request);
                String id = IdWorker.nextAutoIdStr();
                String joinType = request.getJoinType();
                if (StringUtils.isBlank((CharSequence)joinType)) {
                    joinType = JoinTenantType.REGIST.getCode();
                }
                UserPO userPO = this.userAccountUnRegBusiService.registerUser(request, id);
                UserRegistContext registContext = new UserRegistContext();
                BeanUtils.copyProperties((Object)userPO, (Object)registContext);
                String regSource = request.getClientUa().contains("kejian365") ? UserRegSourceEnum.PC_CLIENT.getCode() : (request.getClientUa().contains("XWEB") ? UserRegSourceEnum.WECHAT_MINI_PROGRAM.getCode() : UserRegSourceEnum.WEB_CLIENT.getCode());
                registContext.setRegSource(regSource);
                registContext.setUserRealityName(userPO.getRealName());
                registContext.setJoinType(joinType);
                registContext.setPromChannel(request.getPromChannel());
                registContext.setClientUa(request.getClientUa());
                registContext.setClientIp(request.getClientIp());
                this.userSettingHelper.userRegistNotice(registContext);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                NbchatUserInfo nbchatUserInfo = this.userInfoBusiService.getUserInfo(id);
                log.info("\u7528\u6237\u6ce8\u518c-\u5b8c\u6210: {}", (Object)nbchatUserInfo);
                Rsp rsp = BaseRspUtils.createSuccessRsp((Object)nbchatUserInfo, (String)"\u6ce8\u518c\u6210\u529f");
                return rsp;
            }
            Rsp id = BaseRspUtils.createErrorRsp((String)"\u6ce8\u518c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!");
            return id;
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u6ce8\u518c-\u5f02\u5e38: {}", (Object)request, (Object)e);
            Rsp rsp = BaseRspUtils.createErrorRsp((String)("\u6ce8\u518c\u5931\u8d25: " + e.getMessage()));
            return rsp;
        }
        finally {
            this.redisHelper.unlock(redisLockEntity);
        }
    }
}

