/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.tydic.nbchat.user.api.NoticeApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.SendBatchSmsRequest;
import com.tydic.nbchat.user.api.bo.SendSmsRequest;
import com.tydic.nbchat.user.api.bo.eums.SmsHelperType;
import com.tydic.nbchat.user.api.bo.eums.SmsTemplateEnum;
import com.tydic.nbchat.user.api.bo.eums.WxTemplateEnum;
import com.tydic.nbchat.user.api.bo.notice.NoticeBO;
import com.tydic.nbchat.user.api.bo.notice.NoticeContext;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.WxOfficialNoticeService;
import com.tydic.nbchat.user.core.utils.NbchatSmsProxyHelper;
import com.tydic.nbchat.user.mapper.CommonMapper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class NoticeServiceImpl
implements NoticeApi {
    private static final Logger log = LoggerFactory.getLogger(NoticeServiceImpl.class);
    private final UserInfoBusiService userInfoBusiService;
    private final WxOfficialNoticeService wxOfficialNoticeService;
    private final NbchatSmsProxyHelper nbchatSmsProxyHelper;
    private final RedisHelper redisHelper;
    private static final String product_tdh_name = "\u6570\u5b57\u5206\u8eab\u5f62\u8c61\u5b9a\u5236";
    private static final String product_audio_name = "\u58f0\u97f3\u590d\u523b";
    private static final String customize_complete = "\u5df2\u5b9a\u5236\u5b8c\u6210";
    private static final String customize_cancel = "\u5df2\u6210\u529f\u53d6\u6d88\u5b9a\u5236";
    @Resource
    CommonMapper commonMapper;

    public NoticeServiceImpl(UserInfoBusiService userInfoBusiService, WxOfficialNoticeService wxOfficialNoticeService, NbchatSmsProxyHelper nbchatSmsProxyHelper, RedisHelper redisHelper) {
        this.userInfoBusiService = userInfoBusiService;
        this.wxOfficialNoticeService = wxOfficialNoticeService;
        this.nbchatSmsProxyHelper = nbchatSmsProxyHelper;
        this.redisHelper = redisHelper;
    }

    public void notice(NoticeBO request) throws Exception {
        Boolean flag;
        if (StringUtils.isNotEmpty((CharSequence)request.getTenantCode()) && (flag = Boolean.valueOf(this.redisHelper.sHasKey("nbchat-user:notice:gray_list", (Object)request.getTenantCode()))).booleanValue()) {
            log.info("\u79df\u6237\u5df2\u5728\u7070\u5ea6\u540d\u5355\u4e2d:{}", (Object)request.getTenantCode());
            return;
        }
        log.info("\u6536\u5230\u901a\u77e5:{}", (Object)request);
        NbchatUserInfo userInfo = this.userInfoBusiService.getUserInfo(request.getUserId());
        if (ObjectUtils.isEmpty((Object)userInfo)) {
            log.warn("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25:{}", (Object)request.getUserId());
            return;
        }
        Map dateMap = this.commonMapper.queryCustomizeRecord(request.getOrderId());
        if (request.getAction().equals((Object)NoticeBO.Action.CUSTOM) && (ObjectUtils.isEmpty((Object)dateMap) || !dateMap.containsKey("start_time") || !dateMap.containsKey("end_time"))) {
            log.warn("\u83b7\u53d6\u5b9a\u5236\u8bb0\u5f55\u5f02\u5e38-\u83b7\u53d6\u4e0d\u5230\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4:{}", (Object)request.getOrderId());
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(request.getOrderId());
        if (request.getType().equals((Object)NoticeBO.Type.TDH)) {
            params.add(product_tdh_name);
            if (request.getAction().equals((Object)NoticeBO.Action.CUSTOM)) {
                params.add(customize_complete);
                params.add(DateTimeUtil.getTimeShortString((Date)((Date)dateMap.get("start_time")), (String)"yyyy-MM-dd HH:mm:ss"));
                params.add(DateTimeUtil.getTimeShortString((Date)((Date)dateMap.get("end_time")), (String)"yyyy-MM-dd HH:mm:ss"));
                this.sendCustomNotice(userInfo, params, SmsTemplateEnum.HUMAN_CUSTOMIZATION_COMPLETED, WxTemplateEnum.CUSTOM_COMPLETE);
            }
            if (request.getAction().equals((Object)NoticeBO.Action.CANCEL)) {
                params.add(customize_cancel);
                params.add(DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.sendCustomNotice(userInfo, params, SmsTemplateEnum.HUMAN_CUSTOMIZATION_CANCEL, WxTemplateEnum.CUSTOM_CANCEL);
            }
        }
        if (request.getType().equals((Object)NoticeBO.Type.AUDIO)) {
            params.add(product_audio_name);
            if (request.getAction().equals((Object)NoticeBO.Action.CUSTOM)) {
                params.add(customize_complete);
                params.add(DateTimeUtil.getTimeShortString((Date)((Date)dateMap.get("start_time")), (String)"yyyy-MM-dd HH:mm:ss"));
                params.add(DateTimeUtil.getTimeShortString((Date)((Date)dateMap.get("end_time")), (String)"yyyy-MM-dd HH:mm:ss"));
                this.sendCustomNotice(userInfo, params, SmsTemplateEnum.VOICE_CUSTOMIZATION_COMPLETED, WxTemplateEnum.CUSTOM_COMPLETE);
            }
            if (request.getAction().equals((Object)NoticeBO.Action.CANCEL)) {
                params.add(customize_cancel);
                params.add(DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.sendCustomNotice(userInfo, params, SmsTemplateEnum.VOICE_CUSTOMIZATION_CANCEL, WxTemplateEnum.CUSTOM_CANCEL);
            }
        }
    }

    public void sendCustomNotice(NbchatUserInfo userInfo, List<String> params, SmsTemplateEnum code, WxTemplateEnum type) {
        SendSmsRequest request = SendSmsRequest.builder().signName("\u8bfe\u4ef6\u5e2e").templateCode(code.getTemplateID()).phone(userInfo.getPhone()).build();
        this.smsNotice(request);
        NoticeContext context = NoticeContext.builder().templateType(type.getCode()).userId(userInfo.getUserId()).params(params).build();
        this.officialNotice(context);
    }

    public void officialNotice(NoticeContext context) {
        log.info("\u6536\u5230\u516c\u4f17\u53f7\u901a\u77e5:{}", (Object)context);
        try {
            this.wxOfficialNoticeService.sendNotice(context);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u516c\u4f17\u53f7\u901a\u77e5\u5931\u8d25:{}", (Object)context, (Object)e);
        }
    }

    public void smsNotice(SendSmsRequest request) {
        log.info("\u6536\u5230\u77ed\u4fe1\u901a\u77e5:{}", (Object)request);
        try {
            Rsp rsp = this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, request);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u5931\u8d25:{}", (Object)request, (Object)e);
        }
    }

    public RspList<String> smsNotice(SendBatchSmsRequest request) {
        log.info("\u6536\u5230\u77ed\u4fe1\u901a\u77e5:{}", (Object)request);
        try {
            return this.nbchatSmsProxyHelper.sendBatch(SmsHelperType.ALI, request);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u5931\u8d25:{}", (Object)request, (Object)e);
            return BaseRspUtils.createErrorRspList((String)"\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u5931\u8d25");
        }
    }
}

