/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.user.api.SysMsgApi;
import com.tydic.nbchat.user.api.bo.msg.MsgActionDataBO;
import com.tydic.nbchat.user.api.bo.msg.MsgInfoBO;
import com.tydic.nbchat.user.api.bo.msg.MsgPopupRspBO;
import com.tydic.nbchat.user.api.bo.msg.MsgReqBO;
import com.tydic.nbchat.user.api.bo.msg.MsgSendReqBO;
import com.tydic.nbchat.user.api.bo.msg.MsgTempInfoBO;
import com.tydic.nbchat.user.api.bo.msg.MsgTempReqBO;
import com.tydic.nbchat.user.core.enmus.MsgDefaultParamEnum;
import com.tydic.nbchat.user.core.vo.MsgContentVO;
import com.tydic.nbchat.user.mapper.MsgParamMapper;
import com.tydic.nbchat.user.mapper.SysMsgReadMapper;
import com.tydic.nbchat.user.mapper.SysMsgRecordMapper;
import com.tydic.nbchat.user.mapper.SysMsgTemplateMapper;
import com.tydic.nbchat.user.mapper.po.SysMsgRecord;
import com.tydic.nbchat.user.mapper.po.SysMsgTemplate;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SysMsgServiceImpl
implements SysMsgApi {
    private static final Logger log = LoggerFactory.getLogger(SysMsgServiceImpl.class);
    private final RedisHelper redisHelper;
    private final MsgParamMapper msgParamMapper;
    private final SysMsgReadMapper sysMsgReadMapper;
    private final SysMsgRecordMapper sysMsgRecordMapper;
    private final SysMsgTemplateMapper sysMsgTemplateMapper;

    public Rsp<String> sendMessage(MsgSendReqBO param) {
        log.info("\u53d1\u9001\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)param));
        if (StringUtils.isNotBlank((CharSequence)param.getTitle()) && param.getTitle().length() > 200) {
            log.warn("\u6807\u9898\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e200\u4e2a\u5b57\u7b26");
            return BaseRspUtils.createErrorRsp((String)"\u6807\u9898\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e200\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isBlank((CharSequence)param.getTargetTenantCode())) {
            param.setTargetTenantCode("00000000");
        }
        if (StringUtils.isBlank((CharSequence)param.getTpCode())) {
            log.warn("\u6d88\u606f\u6a21\u7248CODE\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u6d88\u606f\u6a21\u7248CODE\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysMsgTemplate msgTemplate = this.findMsgTempByTpCode(param.getTpCode());
        if (StringUtils.isNotBlank((CharSequence)msgTemplate.getTenantCode()) && !msgTemplate.getTenantCode().equals(param.getTargetTenantCode())) {
            log.warn("\u8be5\u6d88\u606f\u6a21\u7248CODE-{} \u4e0d\u662f\u8be5\u79df\u6237CODE\u4e0b\u4f7f\u7528\u7684-{}", (Object)param.getTpCode(), (Object)param.getTargetTenantCode());
            return BaseRspUtils.createErrorRsp((String)"\u672a\u627e\u5230\u6d88\u606f\u6a21\u7248");
        }
        MsgActionDataBO actionData = (MsgActionDataBO)JSONObject.parseObject((String)msgTemplate.getActionData(), MsgActionDataBO.class);
        if (CollectionUtils.isEmpty((Collection)param.getPushData().getUsers())) {
            MsgContentVO msgContent = this.buildContent(msgTemplate.getContent(), msgTemplate.getActionType(), actionData.getParamKeys(), param.getPushData().getParams(), param.getTargetTenantCode(), null);
            msgContent.setActionData(actionData);
            this.saveMsgRecord(param, msgTemplate, null, JSON.toJSONString((Object)msgContent), 2);
            String redisKey = "nbchat-user:message:unread:%s".formatted(param.getTargetTenantCode());
            Set hashKeys = this.redisHelper.hKey(redisKey);
            if (CollectionUtils.isNotEmpty((Collection)hashKeys)) {
                hashKeys.forEach(hashKey -> this.redisHelper.hincr(redisKey, (String)hashKey, 1.0));
            }
            return BaseRspUtils.createSuccessRsp((Object)"\u6d88\u606f\u53d1\u9001\u6210\u529f");
        }
        param.getPushData().getUsers().forEach(userId -> {
            MsgContentVO msgContent = this.buildContent(msgTemplate.getContent(), msgTemplate.getActionType(), actionData.getParamKeys(), param.getPushData().getParams(), param.getTargetTenantCode(), (String)userId);
            msgContent.setActionData(actionData);
            SysMsgRecord msgInfo = this.saveMsgRecord(param, msgTemplate, (String)userId, JSON.toJSONString((Object)msgContent), 1);
            this.redisHelper.set("nbchat-user:message:info:%d".formatted(msgInfo.getId()), (Object)JSON.toJSONString((Object)msgInfo), 600L);
            this.incrUnreadMsg(param.getTargetTenantCode(), (String)userId, 1);
        });
        return BaseRspUtils.createSuccessRsp((Object)"\u6d88\u606f\u53d1\u9001\u6210\u529f");
    }

    public RspList<MsgInfoBO> msgList(MsgReqBO param) {
        log.info("\u83b7\u53d6\u6d88\u606f\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)param));
        SysMsgRecord record = new SysMsgRecord();
        record.setTenantCode(param.getTenantCode());
        record.setUserId(param.getUserId());
        record.setMsgType(param.getMsgType());
        record.setIsRead(param.getIsRead());
        try (Page page = PageHelper.startPage((int)param.getPage(), (int)param.getLimit());){
            this.sysMsgRecordMapper.selectForList(record);
            ArrayList result = new ArrayList();
            if (page.getTotal() > 0L) {
                page.forEach(o -> result.add(this.buildMessageInfoBO((SysMsgRecord)o, false)));
            }
            RspList rspList = BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
            return rspList;
        }
    }

    public Rsp<MsgInfoBO> msgInfo(MsgReqBO param) {
        log.info("\u6839\u636e\u63d0\u4f9b\u7684\u6d88\u606f\u8bf7\u6c42\u53c2\u6570\u83b7\u53d6\u5355\u6761\u6d88\u606f\u7684\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)param));
        SysMsgRecord message = this.findMsgInfoByMsgId(param.getMsgId(), param.getUserId());
        return BaseRspUtils.createSuccessRsp((Object)this.buildMessageInfoBO(message, true));
    }

    public Rsp<MsgPopupRspBO> msgPopup(MsgReqBO param) {
        log.info("\u83b7\u53d6\u6700\u65b0\u7684\u6d88\u606f\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)param));
        MsgPopupRspBO result = new MsgPopupRspBO();
        long unReadCount = this.incrUnreadMsg(param.getTenantCode(), param.getUserId(), 0);
        result.setUnReadCount(unReadCount);
        if (unReadCount == 0L) {
            return BaseRspUtils.createSuccessRsp((Object)result);
        }
        SysMsgRecord record = new SysMsgRecord();
        record.setTenantCode(param.getTenantCode());
        record.setUserId(param.getUserId());
        List popupList = this.sysMsgRecordMapper.selectForPopup(record);
        if (CollectionUtils.isNotEmpty((Collection)popupList)) {
            result.setPopupList(popupList.stream().map(message -> {
                if (message.getIsPopup() == 0) {
                    if (message.getTargetType() == 2) {
                        this.sysMsgReadMapper.updateForPopup(message.getId(), param.getUserId());
                    } else {
                        this.sysMsgRecordMapper.updateForPopup(message.getId());
                    }
                }
                return this.buildMessageInfoBO((SysMsgRecord)message, false);
            }).toList());
        }
        return BaseRspUtils.createSuccessRsp((Object)result);
    }

    public RspList<MsgTempInfoBO> msgTempList(MsgTempReqBO param) {
        log.info("\u83b7\u53d6\u6d88\u606f\u6a21\u677f\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)param));
        SysMsgTemplate record = new SysMsgTemplate();
        BeanUtils.copyProperties((Object)param, (Object)record);
        try (Page page = PageHelper.startPage((int)param.getPage(), (int)param.getLimit());){
            this.sysMsgTemplateMapper.selectForList(record);
            ArrayList result = new ArrayList();
            if (page.getTotal() > 0L) {
                NiccCommonUtil.copyList((List)page.getResult(), result, MsgTempInfoBO.class);
            }
            RspList rspList = BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
            return rspList;
        }
    }

    public Rsp<MsgTempInfoBO> msgTempInfo(MsgTempReqBO param) {
        log.info("\u6839\u636e\u63d0\u4f9b\u7684\u6d88\u606f\u6a21\u677f\u8bf7\u6c42\u53c2\u6570\u83b7\u53d6\u5355\u6761\u6d88\u606f\u6a21\u677f\u7684\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)param));
        if (StringUtils.isBlank((CharSequence)param.getTpCode())) {
            log.warn("\u6d88\u606f\u6a21\u7248CODE\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u6d88\u606f\u6a21\u7248CODE\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysMsgTemplate msgTemplate = this.findMsgTempByTpCode(param.getTpCode());
        MsgTempInfoBO result = new MsgTempInfoBO();
        BeanUtils.copyProperties((Object)msgTemplate, (Object)result);
        return BaseRspUtils.createSuccessRsp((Object)result);
    }

    public Rsp<String> msgTempSave(MsgTempInfoBO param) {
        log.info("\u4fdd\u5b58\u6d88\u606f\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)param));
        if (StringUtils.isBlank((CharSequence)param.getTpName())) {
            log.warn("\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getTpName().length() > 100) {
            log.warn("\u6a21\u677f\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100\u4e2a\u5b57\u7b26");
            return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100\u4e2a\u5b57\u7b26");
        }
        if (param.getMsgType() == null) {
            param.setMsgType(Integer.valueOf(1));
        }
        if (StringUtils.isBlank((CharSequence)param.getTitle())) {
            log.warn("\u6807\u9898\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u6807\u9898\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getTitle().length() > 200) {
            log.warn("\u6807\u9898\u6a21\u677f\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e200\u4e2a\u5b57\u7b26");
            return BaseRspUtils.createErrorRsp((String)"\u6807\u9898\u6a21\u677f\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e200\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isBlank((CharSequence)param.getContent())) {
            log.warn("\u5185\u5bb9\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u5185\u5bb9\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysMsgTemplate record = new SysMsgTemplate();
        BeanUtils.copyProperties((Object)param, (Object)record);
        if (StringUtils.isBlank((CharSequence)record.getTpCode())) {
            record.setTpCode(IdWorker.nextAutoIdStr());
            this.sysMsgTemplateMapper.insertSelective(record);
        } else {
            this.sysMsgTemplateMapper.updateSelectiveByTpCode(record);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    private long incrUnreadMsg(String tenantCode, String userId, int num) {
        String redisKey = "nbchat-user:message:unread:%s".formatted(tenantCode);
        boolean hHasKeyFlag = this.redisHelper.hHasKey(redisKey, userId);
        long unReadCount = num;
        if (!hHasKeyFlag) {
            SysMsgRecord record = new SysMsgRecord();
            record.setTenantCode(tenantCode);
            record.setUserId(userId);
            unReadCount = this.sysMsgRecordMapper.selectCountByUnRead(record);
        }
        return (long)this.redisHelper.hincr(redisKey, userId, (double)unReadCount);
    }

    private SysMsgRecord findMsgInfoByMsgId(Long msgId, String userId) {
        String redisKey = "nbchat-user:message:info:%d".formatted(msgId);
        Object msgInfoObj = this.redisHelper.get(redisKey);
        if (msgInfoObj != null) {
            return (SysMsgRecord)JSONObject.parseObject((String)((String)msgInfoObj), SysMsgRecord.class);
        }
        SysMsgRecord msgInfo = this.sysMsgRecordMapper.selectForDetail(msgId, userId);
        if (msgInfo == null) {
            log.warn("\u672a\u627e\u5230\u6d88\u606f");
            throw new DcBusinessException("\u672a\u627e\u5230\u6d88\u606f");
        }
        if (msgInfo.getIsRead() == 0) {
            if (msgInfo.getTargetType() == 2) {
                this.sysMsgReadMapper.updateForRead(msgInfo.getId(), msgInfo.getUserId());
            } else {
                this.sysMsgRecordMapper.updateForRead(msgInfo.getId());
            }
            msgInfo.setIsRead(Integer.valueOf(1));
            msgInfo.setMsgTime(new Date());
            this.incrUnreadMsg(msgInfo.getTenantCode(), msgInfo.getUserId(), -1);
        }
        this.redisHelper.set(redisKey, (Object)JSON.toJSONString((Object)msgInfo), 600L);
        return msgInfo;
    }

    private SysMsgTemplate findMsgTempByTpCode(String tpCode) {
        String redisKey = "nbchat-user:message:template:%s".formatted(tpCode);
        Object msgTempObj = this.redisHelper.get(redisKey);
        if (msgTempObj != null) {
            return (SysMsgTemplate)JSONObject.parseObject((String)((String)msgTempObj), SysMsgTemplate.class);
        }
        SysMsgTemplate msgTemplate = this.sysMsgTemplateMapper.selectByTpCode(tpCode);
        if (msgTemplate == null) {
            log.warn("\u672a\u627e\u5230\u6d88\u606f\u6a21\u7248");
            throw new DcBusinessException("\u672a\u627e\u5230\u6d88\u606f\u6a21\u7248");
        }
        this.redisHelper.set(redisKey, (Object)JSON.toJSONString((Object)msgTemplate), 86400L);
        return msgTemplate;
    }

    private MsgContentVO buildContent(String content, Integer actionType, Set<String> paramKeys, Map<String, String> params, String tenantCode, String userId) {
        MsgContentVO msgContent = new MsgContentVO();
        msgContent.setActionType(actionType);
        msgContent.setParams(params);
        HashSet<String> keys = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(paramKeys)) {
            keys.addAll(paramKeys);
        }
        if (MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                content = content.replaceAll("#" + entry.getKey(), entry.getValue());
                keys.remove(entry.getKey());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)userId) && CollectionUtils.isNotEmpty(keys)) {
            HashSet<String> tempParamKeys = new HashSet<String>();
            for (String paramKey : keys) {
                MsgDefaultParamEnum paramEnum = MsgDefaultParamEnum.getEnumByCode(paramKey);
                if (paramEnum == null) continue;
                tempParamKeys.add(paramKey);
                String paramValue = paramEnum.getFunction().apply(this.msgParamMapper, tenantCode, userId);
                if (paramValue == null) {
                    paramValue = "";
                }
                content = content.replaceAll("#" + paramKey, paramValue);
            }
            if (CollectionUtils.isNotEmpty(tempParamKeys)) {
                keys.removeAll(tempParamKeys);
            }
        }
        msgContent.setParamKeys(keys);
        msgContent.setContent(content);
        return msgContent;
    }

    private SysMsgRecord saveMsgRecord(MsgSendReqBO param, SysMsgTemplate msgTemplate, String userId, String context, Integer targetType) {
        SysMsgRecord msgRecord = new SysMsgRecord();
        msgRecord.setTenantCode(param.getTargetTenantCode());
        msgRecord.setMsgType(msgTemplate.getMsgType());
        msgRecord.setTpCode(msgTemplate.getTpCode());
        msgRecord.setTitle(StringUtils.isNotEmpty((CharSequence)param.getTitle()) ? param.getTitle() : msgTemplate.getTitle());
        msgRecord.setContent(context);
        msgRecord.setSenderId(param.getSenderId());
        msgRecord.setTargetType(targetType);
        msgRecord.setUserId(userId);
        this.sysMsgRecordMapper.insertSelective(msgRecord);
        return msgRecord;
    }

    private MsgInfoBO buildMessageInfoBO(SysMsgRecord message, boolean detailFlag) {
        MsgInfoBO data = new MsgInfoBO();
        data.setMsgId(message.getId());
        data.setTitle(message.getTitle());
        data.setIsRead(message.getIsRead());
        data.setMsgTime(message.getMsgTime());
        data.setActionType(message.getActionType());
        if (detailFlag) {
            MsgContentVO msgContent = (MsgContentVO)JSONObject.parseObject((String)message.getContent(), MsgContentVO.class);
            if (CollectionUtils.isNotEmpty(msgContent.getParamKeys())) {
                msgContent = this.buildContent(msgContent.getContent(), msgContent.getActionType(), msgContent.getParamKeys(), null, message.getTenantCode(), message.getUserId());
            }
            data.setTenantCode(message.getTenantCode());
            data.setSenderId(message.getSenderId());
            data.setUserId(message.getUserId());
            data.setMsgType(message.getMsgType());
            data.setTpCode(message.getTpCode());
            data.setContent(msgContent.getContent());
            data.setReadTime(message.getReadTime());
        }
        return data;
    }

    public SysMsgServiceImpl(RedisHelper redisHelper, MsgParamMapper msgParamMapper, SysMsgReadMapper sysMsgReadMapper, SysMsgRecordMapper sysMsgRecordMapper, SysMsgTemplateMapper sysMsgTemplateMapper) {
        this.redisHelper = redisHelper;
        this.msgParamMapper = msgParamMapper;
        this.sysMsgReadMapper = sysMsgReadMapper;
        this.sysMsgRecordMapper = sysMsgRecordMapper;
        this.sysMsgTemplateMapper = sysMsgTemplateMapper;
    }
}

