/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.tydic.nbchat.user.api.UserAccountApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.account.UserAccountUpdateReqBO;
import com.tydic.nbchat.user.core.busi.UserAuthBusiService;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.UserLoginLockBusiService;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.UserRoleAndDeptMapper;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserAccountServiceImpl
implements UserAccountApi {
    private static final Logger log = LoggerFactory.getLogger(UserAccountServiceImpl.class);
    private final UserLoginLockBusiService userLoginLockBusiService;
    private final UserAuthBusiService userAuthBusiService;
    private final UserInfoBusiService userInfoBusiService;
    private final UserSettingHelper userSettingHelper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserRoleAndDeptMapper userRoleAndDeptMapper;

    public UserAccountServiceImpl(UserLoginLockBusiService userLoginLockBusiService, UserAuthBusiService userAuthBusiService, UserInfoBusiService userInfoBusiService, UserSettingHelper userSettingHelper) {
        this.userLoginLockBusiService = userLoginLockBusiService;
        this.userAuthBusiService = userAuthBusiService;
        this.userInfoBusiService = userInfoBusiService;
        this.userSettingHelper = userSettingHelper;
    }

    public Rsp accountDisable(String userId, String reason) {
        try {
            NbchatUserInfo info = this.userInfoBusiService.getUserBaseInfo(userId);
            this.userAuthBusiService.authLogout(userId);
            this.userLoginLockBusiService.lockAccount(info.getPhone(), null, reason);
            return BaseRspUtils.createSuccessRsp((Object)userId);
        }
        catch (Exception e) {
            log.error("\u8d26\u53f7\u7981\u7528\u5931\u8d25: userId = {}", (Object)userId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u8d26\u53f7\u7981\u7528\u5931\u8d25");
        }
    }

    public Rsp accountEnable(String userId) {
        try {
            NbchatUserInfo info = this.userInfoBusiService.getUserBaseInfo(userId);
            this.userLoginLockBusiService.unlockAccount(info.getPhone());
            return BaseRspUtils.createSuccessRsp((Object)userId);
        }
        catch (Exception e) {
            log.error("\u8d26\u53f7\u89e3\u9501\u5931\u8d25: userId = {}", (Object)userId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u8d26\u53f7\u89e3\u9501\u5931\u8d25");
        }
    }

    public Rsp updateAccount(UserAccountUpdateReqBO reqBO) {
        log.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f: {}", (Object)reqBO);
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{reqBO.getUserId(), reqBO.getName(), reqBO.getAvatar()})) {
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u9519\u8bef");
        }
        UserPO userPO = new UserPO();
        userPO.setUserId(reqBO.getUserId());
        userPO.setName(reqBO.getName());
        userPO.setAvatar(reqBO.getAvatar());
        userPO.setUpdatedTime(new Date());
        userPO.setRealName(reqBO.getRealName());
        this.userMapper.updateById(userPO);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAvatarUrl()) || StringUtils.isNotBlank((CharSequence)reqBO.getRealName())) {
            this.userRoleAndDeptMapper.updateUserInTenant(reqBO.getUserId(), reqBO.getTenantCode(), reqBO.getRealName(), reqBO.getAvatarUrl());
        }
        this.userSettingHelper.cleanUserCache(reqBO.getTenantCode(), reqBO.getUserId());
        return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u66f4\u65b0\u6210\u529f");
    }
}

