/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.UserBaseInfoApi;
import com.tydic.nbchat.user.api.bo.role.UserRoleInfo;
import com.tydic.nbchat.user.api.bo.user.UserBaseInfo;
import com.tydic.nbchat.user.api.bo.user.UserDeptInfo;
import com.tydic.nbchat.user.api.bo.user.UserPostInfo;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.UserRoleAndDeptMapper;
import com.tydic.nbchat.user.mapper.po.UserDept;
import com.tydic.nbchat.user.mapper.po.UserInfoInTenant;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nbchat.user.mapper.po.UserPost;
import com.tydic.nbchat.user.mapper.po.UserRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserBaseInfoServiceImpl
implements UserBaseInfoApi {
    private static final Logger log = LoggerFactory.getLogger(UserBaseInfoServiceImpl.class);
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserRoleAndDeptMapper userRoleAndDeptMapper;
    private final RedisHelper redisHelper;

    public UserBaseInfoServiceImpl(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    public UserBaseInfo queryUserCache(String tenantCode, String uid) {
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return null;
        }
        String key = "nbchat-user:info:" + tenantCode + ":" + uid;
        try {
            UserBaseInfo userBaseInfo = (UserBaseInfo)this.redisHelper.get(key);
            if (userBaseInfo != null) {
                return userBaseInfo;
            }
        }
        catch (Exception e) {
            this.redisHelper.del(new String[]{key});
        }
        return null;
    }

    public Rsp<UserBaseInfo> getByUserId(String tenantCode, String userId) {
        UserBaseInfo baseInfo = this.queryUserCache(tenantCode, userId);
        if (ObjectUtils.isNotEmpty((Object)baseInfo)) {
            return BaseRspUtils.createSuccessRsp((Object)baseInfo);
        }
        UserPO user = this.userMapper.findUserByUserId(userId);
        if (user != null) {
            UserBaseInfo userBaseInfo = this.packageUser(user, tenantCode, userId);
            return BaseRspUtils.createSuccessRsp((Object)userBaseInfo);
        }
        return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4e0d\u5b58\u5728");
    }

    public Rsp<UserBaseInfo> getByPhone(String tenantCode, String phone) {
        UserPO user = this.userMapper.findUserByMobile(phone);
        if (user != null) {
            UserBaseInfo userBaseInfo = this.packageUser(user, tenantCode, user.getUserId());
            return BaseRspUtils.createSuccessRsp((Object)userBaseInfo);
        }
        return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4e0d\u5b58\u5728");
    }

    public void removeCache(String tenantCode, String userId) {
        String key = "nbchat-user:info:" + tenantCode + ":" + userId;
        this.redisHelper.del(new String[]{key});
    }

    public Rsp<UserBaseInfo> getByUserName(String tenantCode, String userName) {
        UserBaseInfo baseInfo = this.queryUserCache(tenantCode, userName);
        if (ObjectUtils.isNotEmpty((Object)baseInfo)) {
            return BaseRspUtils.createSuccessRsp((Object)baseInfo);
        }
        UserPO user = this.userMapper.findUserByUserName(userName);
        if (user != null) {
            UserBaseInfo userBaseInfo = this.packageUser(user, tenantCode, userName);
            return BaseRspUtils.createSuccessRsp((Object)userBaseInfo);
        }
        return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4e0d\u5b58\u5728");
    }

    private UserBaseInfo packageUser(UserPO user, String tenantCode, String uid) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = user.getTenantCode();
            UserBaseInfo baseInfo = this.queryUserCache(user.getTenantCode(), uid);
            if (ObjectUtils.isNotEmpty((Object)baseInfo)) {
                return baseInfo;
            }
        }
        String key = "nbchat-user:info:" + tenantCode + ":" + uid;
        UserBaseInfo userBaseInfo = new UserBaseInfo();
        userBaseInfo.setUserId(user.getUserId());
        userBaseInfo.setName(user.getName());
        userBaseInfo.setPhone(user.getPhone());
        userBaseInfo.setUsername(user.getUserName());
        userBaseInfo.setTenantCode(tenantCode);
        userBaseInfo.setAvatar(user.getAvatar());
        userBaseInfo.setGender(user.getGender());
        UserInfoInTenant userInfoInTenant = this.userRoleAndDeptMapper.selectUserInTenant(tenantCode, user.getUserId());
        if (userInfoInTenant != null) {
            userBaseInfo.setRealName(userInfoInTenant.getUserRealityName());
            userBaseInfo.setAvatarUrl(userInfoInTenant.getAvatar());
            userBaseInfo.setTenantName(userInfoInTenant.getTenantName());
            userBaseInfo.setGender(userInfoInTenant.getGender());
            userBaseInfo.setIdCard(userInfoInTenant.getIdCard());
            userBaseInfo.setBirthday(userInfoInTenant.getBirthday());
        } else if (StringUtils.isNotBlank((CharSequence)user.getRealName())) {
            userBaseInfo.setRealName(user.getName());
        }
        List posts = this.userRoleAndDeptMapper.selectUserPosts(tenantCode, user.getUserId());
        LinkedHashSet<Object> postList = new LinkedHashSet<Object>();
        for (UserPost post : posts) {
            UserPostInfo userPostInfo = new UserPostInfo();
            userPostInfo.setPostId(post.getPostId());
            userPostInfo.setPostName(post.getPostName());
            postList.add(userPostInfo);
        }
        userBaseInfo.setPostList(postList);
        List roles = this.userRoleAndDeptMapper.selectUserRoles(tenantCode, user.getUserId());
        LinkedHashSet<UserRoleInfo> roleList = new LinkedHashSet<UserRoleInfo>();
        for (UserRole role : roles) {
            UserRoleInfo sysRole = new UserRoleInfo();
            sysRole.setRole(role.getRole());
            sysRole.setName(role.getName());
            if (StringUtils.isNotBlank((CharSequence)role.getApiPermission()) && JSONObject.isValid((String)role.getApiPermission())) {
                sysRole.setApis(JSONObject.parseArray((String)role.getApiPermission(), String.class));
            }
            if (StringUtils.isNotBlank((CharSequence)role.getMenuPermission()) && JSONObject.isValid((String)role.getMenuPermission())) {
                sysRole.setMenus(JSONObject.parseArray((String)role.getMenuPermission(), String.class));
            }
            roleList.add(sysRole);
        }
        userBaseInfo.setRoleList(roleList);
        UserDeptInfo dept = this.getUserDept(tenantCode, user.getUserId());
        if (StringUtils.isBlank((CharSequence)dept.getDeptId())) {
            try {
                this.userRoleAndDeptMapper.insertDefaultDeptRel(tenantCode, user.getUserId());
            }
            catch (Exception e) {
                log.warn("\u6dfb\u52a0\u9ed8\u8ba4\u90e8\u95e8\u5173\u7cfb\u5931\u8d25: {}-{}|{}", new Object[]{tenantCode, user.getUserId(), e.getMessage()});
            }
            dept = this.getUserDept(tenantCode, user.getUserId());
        }
        userBaseInfo.setDept(dept);
        this.redisHelper.set(key, (Object)userBaseInfo, 600L);
        return userBaseInfo;
    }

    private UserDeptInfo getUserDept(String tenantCode, String userId) {
        List depts = this.userRoleAndDeptMapper.selectUserDepts(tenantCode, userId);
        UserDeptInfo dept = new UserDeptInfo();
        if (!depts.isEmpty()) {
            dept.setDeptId(((UserDept)depts.get(0)).getDeptId());
            dept.setDeptName(((UserDept)depts.get(0)).getDeptName());
            dept.setParentId(((UserDept)depts.get(0)).getParentId());
            dept.setAncestors(((UserDept)depts.get(0)).getAncestors());
        }
        return dept;
    }
}

