/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.tydic.nbchat.user.api.UserGrayFeatureApi;
import com.tydic.nbchat.user.core.busi.UserGrayService;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=2000)
public class UserGrayFeatureServiceImpl
implements UserGrayFeatureApi {
    private static final Logger log = LoggerFactory.getLogger(UserGrayFeatureServiceImpl.class);
    private final UserGrayService userGrayService;

    public UserGrayFeatureServiceImpl(UserGrayService userGrayService) {
        this.userGrayService = userGrayService;
    }

    public Boolean isInGray(String tenantCode, String userId, String grayCode) {
        return this.getGrayMap(tenantCode, userId).containsKey(grayCode);
    }

    public Map<String, Object> getGrayMap(String tenantCode, String userId) {
        return this.userGrayService.getGrayMap(tenantCode, userId);
    }
}

