/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.tydic.nbchat.user.api.UserInviteApi;
import com.tydic.nbchat.user.api.bo.UserInfoReqBO;
import com.tydic.nbchat.user.api.bo.invite.InviteCodeResBO;
import com.tydic.nbchat.user.core.utils.NumUtils;
import com.tydic.nbchat.user.mapper.NbchatInviteCodeMapper;
import com.tydic.nbchat.user.mapper.po.NbchatInviteCode;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserInviteServiceImpl
implements UserInviteApi {
    private static final Logger log = LoggerFactory.getLogger(UserInviteServiceImpl.class);
    @Resource
    private NbchatInviteCodeMapper nbchatInviteCodeMapper;

    public Rsp<InviteCodeResBO> getInviteCode(UserInfoReqBO param) {
        log.info("\u83b7\u53d6\u7528\u6237\u7684\u9080\u8bf7\u7801\uff1a{}", (Object)param);
        InviteCodeResBO result = new InviteCodeResBO();
        NbchatInviteCode nbchatInviteCode = this.nbchatInviteCodeMapper.selectOneByUserIdAndBizTypeAndBizId(param.getUserId(), param.getBizType(), param.getBizId());
        if (nbchatInviteCode != null) {
            result.setInviteCode(nbchatInviteCode.getInviteCode());
            return BaseRspUtils.createSuccessRsp((Object)result);
        }
        String inviteCode = NumUtils.tenTo62Hex(IdWorker.nextAutoId());
        nbchatInviteCode = new NbchatInviteCode();
        nbchatInviteCode.setId(IdWorker.nextAutoIdStr());
        nbchatInviteCode.setInviteCode(inviteCode);
        nbchatInviteCode.setBizType(param.getBizType());
        nbchatInviteCode.setBizId(param.getBizId());
        nbchatInviteCode.setCreatedBy(param.getUserId());
        this.nbchatInviteCodeMapper.insertSelective(nbchatInviteCode);
        result.setInviteCode(inviteCode);
        return BaseRspUtils.createSuccessRsp((Object)result);
    }
}

