/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.tydic.nbchat.user.api.UserLoginLimitApi;
import com.tydic.nbchat.user.api.bo.eums.AuthType;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserLoginLimitServiceImpl
implements UserLoginLimitApi {
    private static final Logger log = LoggerFactory.getLogger(UserLoginLimitServiceImpl.class);
    private final RedisHelper redisHelper;
    private final NbchatUserConfigProperties nbchatUserConfigProperties;
    private static final String DEVICE_TYPE_PC = "pc";
    private static final String DEVICE_TYPE_H5 = "h5";

    public UserLoginLimitServiceImpl(RedisHelper redisHelper, NbchatUserConfigProperties nbchatUserConfigProperties) {
        this.redisHelper = redisHelper;
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
    }

    public Rsp<String> handleUserAuthToken(String userId, String vipType, String authType, String authToken) {
        if (!this.nbchatUserConfigProperties.getUserLoginLimitEnable().booleanValue()) {
            return BaseRspUtils.createSuccessRsp(null);
        }
        log.info("#####UserLoginLimit###\u5904\u7406\u8bbe\u5907\u540c\u65f6\u767b\u5f55\u9650\u5236 Function:handleUserAuthToken ;Param-> userId={},vipType={},authType={}\uff0cauthToken={}", new Object[]{userId, vipType, authType, authToken});
        String deviceType = this.getDeviceType(authType);
        if (StringUtils.isBlank((CharSequence)userId) || StringUtils.isBlank((CharSequence)deviceType)) {
            throw new RuntimeException("\u5fc5\u586b\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        String key = "nbchat-user:token:online:" + userId + ":" + deviceType;
        if (!this.redisHelper.hasKey(key)) {
            this.addUserAuthToken(userId, deviceType, authToken);
            return BaseRspUtils.createSuccessRsp(null);
        }
        Map<String, Integer> loginLimitMap = this.nbchatUserConfigProperties.getUserLoginLimitMap();
        if (StringUtils.isBlank((CharSequence)vipType)) {
            vipType = "1";
        }
        if (!loginLimitMap.containsKey(vipType)) {
            throw new RuntimeException("\u672a\u77e5\u7684\u4f1a\u5458\u7b49\u7ea7!vi[Type=" + vipType);
        }
        Integer loginLimit = loginLimitMap.get(vipType);
        long onlineTokenNum = this.redisHelper.lGetListSize(key);
        this.addUserAuthToken(userId, deviceType, authToken);
        if (onlineTokenNum >= loginLimit.longValue()) {
            return this.removeUserAuthToken(userId, deviceType, null);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public Rsp<String> removeUserAuthToken(String userId, String deviceType, String removeToken) {
        String key;
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new RuntimeException("\u5fc5\u586b\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)deviceType) && StringUtils.isBlank((CharSequence)removeToken)) {
            throw new RuntimeException("\u8bbe\u5907\u7c7b\u578b\u548c\u9000\u51fatoken\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)removeToken) && StringUtils.isNotBlank((CharSequence)deviceType) && this.redisHelper.hasKey(key = "nbchat-user:token:online:" + userId + ":" + deviceType)) {
            Long removeAuthToken = this.redisHelper.lRemove(key, 1L, (Object)removeToken);
            String token = ((Object)removeAuthToken).toString();
            return BaseRspUtils.createSuccessRsp((Object)token);
        }
        if (StringUtils.isBlank((CharSequence)removeToken) && StringUtils.isNotBlank((CharSequence)deviceType) && this.redisHelper.hasKey(key = "nbchat-user:token:online:" + userId + ":" + deviceType)) {
            Object removeAuthToken = this.redisHelper.lLPop(key);
            String token = removeAuthToken.toString();
            return BaseRspUtils.createSuccessRsp((Object)token);
        }
        if (StringUtils.isNotBlank((CharSequence)removeToken) && StringUtils.isBlank((CharSequence)deviceType)) {
            long removeAuthTokenNum;
            long removeAuthTokenNum2;
            String pcKey = "nbchat-user:token:online:" + userId + ":pc";
            if (this.redisHelper.hasKey(pcKey) && (removeAuthTokenNum2 = this.redisHelper.lRemove(pcKey, 1L, (Object)removeToken)) > 0L) {
                return BaseRspUtils.createSuccessRsp((Object)removeToken);
            }
            String h5Key = "nbchat-user:token:online:" + userId + ":h5";
            if (this.redisHelper.hasKey(h5Key) && (removeAuthTokenNum = this.redisHelper.lRemove(h5Key, 1L, (Object)removeToken)) > 0L) {
                return BaseRspUtils.createSuccessRsp((Object)removeToken);
            }
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public Rsp<Boolean> addUserAuthToken(String userId, String deviceType, String authToken) {
        if (StringUtils.isBlank((CharSequence)userId) || StringUtils.isBlank((CharSequence)deviceType) || StringUtils.isBlank((CharSequence)authToken)) {
            throw new RuntimeException("\u5fc5\u586b\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        String key = "nbchat-user:token:online:" + userId + ":" + deviceType;
        Boolean flag = this.redisHelper.lSet(key, (Object)authToken);
        log.info("\u540e\u53f0\u8bbe\u7f6e\u5728\u7ebf\u767b\u5f55\u8bbe\u5907\u4fe1\u606f\uff1auserId={},token={}\uff0cflag={}", new Object[]{userId, authToken, flag});
        return BaseRspUtils.createSuccessRsp((Object)flag);
    }

    public Rsp<String> refreshUserAuthToken(String userId, String vipType, String removeToken, String newAuthToken) {
        Long removeAuthToken;
        Long removeAuthToken2;
        if (StringUtils.isBlank((CharSequence)removeToken) && StringUtils.isBlank((CharSequence)newAuthToken)) {
            throw new RuntimeException("\u65b0\u8001token\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        log.info("#####UserLoginLimit###\u5237\u65b0\u7528\u6237\u767b\u5f55token Function:refreshUserAuthToken ;Param-> userId={},vipType={},removeToken={}\uff0cnewAuthToken={}", new Object[]{userId, vipType, removeToken, newAuthToken});
        String pcKey = "nbchat-user:token:online:" + userId + ":pc";
        String pcDeleteToken = null;
        if (this.redisHelper.hasKey(pcKey) && StringUtils.isNotBlank((CharSequence)(pcDeleteToken = ((Object)(removeAuthToken2 = Long.valueOf(this.redisHelper.lRemove(pcKey, 1L, (Object)removeToken)))).toString()))) {
            this.addUserAuthToken(userId, DEVICE_TYPE_PC, newAuthToken);
            return BaseRspUtils.createSuccessRsp((Object)pcDeleteToken);
        }
        String h5Key = "nbchat-user:token:online:" + userId + ":h5";
        String h5DeleteToken = null;
        if (this.redisHelper.hasKey(h5Key) && StringUtils.isNotBlank((CharSequence)(h5DeleteToken = ((Object)(removeAuthToken = Long.valueOf(this.redisHelper.lRemove(h5Key, 1L, (Object)removeToken)))).toString()))) {
            this.addUserAuthToken(userId, DEVICE_TYPE_H5, newAuthToken);
            return BaseRspUtils.createSuccessRsp((Object)h5DeleteToken);
        }
        if (StringUtils.isBlank((CharSequence)pcDeleteToken) && StringUtils.isNotBlank(h5DeleteToken)) {
            this.handleUserAuthToken(userId, vipType, DEVICE_TYPE_PC, newAuthToken);
            this.handleUserAuthToken(userId, vipType, DEVICE_TYPE_H5, newAuthToken);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    private String getDeviceType(String authType) {
        if (AuthType.WCHAT_MP_TDH.getCode().equals(authType) || AuthType.WCHAT_MP_TDH_PHONE.getCode().equals(authType)) {
            return DEVICE_TYPE_H5;
        }
        return DEVICE_TYPE_PC;
    }
}

