/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.user.api.UserManageService;
import com.tydic.nbchat.user.api.bo.eums.JoinTenantType;
import com.tydic.nbchat.user.api.bo.eums.UserRegSourceEnum;
import com.tydic.nbchat.user.api.bo.manage.ImportUserInfo;
import com.tydic.nbchat.user.api.bo.manage.ImportUserRequest;
import com.tydic.nbchat.user.api.bo.manage.UpdateUserRequest;
import com.tydic.nbchat.user.api.bo.mq.UserRegistContext;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceAccountReqBO;
import com.tydic.nbchat.user.api.trade.TradeBalanceApi;
import com.tydic.nbchat.user.core.utils.PasswordHasher;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.po.UserPO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserManageServiceImpl
implements UserManageService {
    private static final Logger log = LoggerFactory.getLogger(UserManageServiceImpl.class);
    private final UserMapper userMapper;
    private final UserSettingHelper userSettingHelper;
    private final TradeBalanceApi tradeBalanceApi;

    public UserManageServiceImpl(UserMapper userMapper, UserSettingHelper userSettingHelper, TradeBalanceApi tradeBalanceApi) {
        this.userMapper = userMapper;
        this.userSettingHelper = userSettingHelper;
        this.tradeBalanceApi = tradeBalanceApi;
    }

    public Rsp updateInfo(UpdateUserRequest updateUserRequest) {
        log.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f:{}", (Object)updateUserRequest);
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{updateUserRequest.getTargetUid(), updateUserRequest.getTargetPhone()})) {
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u5f02\u5e38!");
        }
        if (StringUtils.isBlank((CharSequence)updateUserRequest.getTargetUid()) && StringUtils.isNotBlank((CharSequence)updateUserRequest.getTargetPhone())) {
            UserPO query = this.userMapper.findUserByMobile(updateUserRequest.getTargetPhone());
            if (query == null) {
                return BaseRspUtils.createErrorRsp((String)("\u672a\u67e5\u8be2\u5230\u8be5\u7528\u6237:phone = " + updateUserRequest.getTargetPhone()));
            }
            updateUserRequest.setTargetUid(query.getUserId());
        }
        UserPO update = new UserPO();
        BeanUtils.copyProperties((Object)updateUserRequest, (Object)update);
        update.setUserId(updateUserRequest.getTargetUid());
        update.setTenantCode(updateUserRequest.getTenant());
        update.setUpdatedTime(new Date());
        update.setUpdatedBy(updateUserRequest.getUserId());
        int i = this.userMapper.updateById(update);
        if (i > 0) {
            this.userSettingHelper.removeInfo(updateUserRequest.getTargetUid());
            return BaseRspUtils.createSuccessRsp((Object)"\u66f4\u65b0\u6210\u529f!");
        }
        return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25!");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp importUsers(ImportUserRequest importUserRequest) {
        log.info("\u7528\u6237\u4fe1\u606f\u5bfc\u5165-\u5f00\u59cb:{}", (Object)importUserRequest);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{importUserRequest.getUserId(), importUserRequest.getTenant()})) {
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u53c2\u6570\u5f02\u5e38\uff01");
        }
        JSONObject importDetails = new JSONObject();
        ArrayList errList = Lists.newArrayList();
        int registCount = 0;
        int updateCount = 0;
        String password = importUserRequest.getPassword();
        for (ImportUserInfo user : importUserRequest.getUsers()) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{user.getName(), user.getPhone()})) {
                errList.add(user);
                log.info("\u7528\u6237\u4fe1\u606f\u5bfc\u5165-\u8df3\u8fc7\u5f02\u5e38\u7528\u6237:{}", (Object)user);
                continue;
            }
            if (user.getPhone().length() != 11) {
                errList.add(user);
                log.info("\u7528\u6237\u4fe1\u606f\u5bfc\u5165-\u8df3\u8fc7\u624b\u673a\u53f7\u5f02\u5e38:{}", (Object)user);
                continue;
            }
            UserPO query = this.userMapper.findUserByMobile(user.getPhone());
            if (query == null) {
                String uid = IdWorker.nextAutoIdStr();
                UserPO insert = new UserPO();
                insert.setUserId(uid);
                insert.setGender("0");
                insert.setName(user.getName());
                insert.setUserName(user.getUsername());
                insert.setEmail(user.getEmail());
                insert.setTenantCode(importUserRequest.getTenant());
                insert.setUpdatedTime(new Date());
                insert.setCreatedTime(new Date());
                insert.setCreatedBy(importUserRequest.getUserId());
                insert.setIsDeleted(Boolean.valueOf(false));
                insert.setPassword(password);
                insert.setPhone(user.getPhone());
                if (StringUtils.isBlank((CharSequence)insert.getPassword())) {
                    insert.setPassword(user.getPhone().substring(5, 11));
                }
                if (StringUtils.isBlank((CharSequence)user.getUsername())) {
                    insert.setUserName(user.getPhone());
                }
                log.info("\u7528\u6237\u4fe1\u606f\u5bfc\u5165-\u6ce8\u518c\u7528\u6237:{}", (Object)insert);
                if (StringUtils.isNotBlank((CharSequence)insert.getPassword())) {
                    insert.setPassword(PasswordHasher.sha1(insert.getPassword()));
                }
                this.userMapper.registerUser(insert);
                UserRegistContext registContext = new UserRegistContext();
                BeanUtils.copyProperties((Object)insert, (Object)registContext);
                String regSource = importUserRequest.getClientUa().contains("kejian365") ? UserRegSourceEnum.PC_CLIENT.getCode() : (importUserRequest.getClientUa().contains("XWEB") ? UserRegSourceEnum.WECHAT_MINI_PROGRAM.getCode() : UserRegSourceEnum.WEB_CLIENT.getCode());
                registContext.setRegSource(regSource);
                registContext.setUserRealityName(user.getName());
                registContext.setJoinType(JoinTenantType.IMPORTS.getCode());
                registContext.setClientUa(importUserRequest.getClientUa());
                registContext.setClientIp(importUserRequest.getClientIp());
                this.userSettingHelper.userRegistNotice(registContext);
                UserBalanceAccountReqBO accountReqBO = new UserBalanceAccountReqBO();
                accountReqBO.setUserId(uid);
                accountReqBO.setTenantCode(importUserRequest.getTenant());
                this.tradeBalanceApi.createBalanceAccount(accountReqBO);
                ++registCount;
                continue;
            }
            UserPO update = new UserPO();
            update.setUserId(query.getUserId());
            update.setName(user.getName());
            update.setEmail(user.getEmail());
            update.setTenantCode(importUserRequest.getTenant());
            update.setUpdatedTime(new Date());
            update.setUpdatedBy(importUserRequest.getUserId());
            log.info("\u7528\u6237\u4fe1\u606f\u5bfc\u5165-\u66f4\u65b0\u7528\u6237:{}", (Object)update);
            this.userMapper.updateById(update);
            ++updateCount;
            this.userSettingHelper.removeInfo(query.getUserId());
        }
        importDetails.put("registCount", (Object)registCount);
        importDetails.put("updateCount", (Object)updateCount);
        importDetails.put("errorList", (Object)errList);
        return BaseRspUtils.createSuccessRsp((Object)importDetails, (String)"\u7528\u6237\u5bfc\u5165\u6210\u529f!");
    }
}

