/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.tydic.nbchat.user.api.UserBaseInfoApi;
import com.tydic.nbchat.user.api.UserRoleDeptApi;
import com.tydic.nbchat.user.api.bo.role.SubSystemInfo;
import com.tydic.nbchat.user.api.bo.role.UserRoleInfo;
import com.tydic.nbchat.user.api.bo.user.UserBaseInfo;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.UserRoleAndDeptMapper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserRoleDeptServiceImpl
implements UserRoleDeptApi {
    private static final Logger log = LoggerFactory.getLogger(UserRoleDeptServiceImpl.class);
    @Resource
    private UserRoleAndDeptMapper userRoleAndDeptMapper;
    private final UserSettingHelper userSettingHelper;
    private final UserBaseInfoApi userBaseInfoApi;

    public UserRoleDeptServiceImpl(UserSettingHelper userSettingHelper, UserBaseInfoApi userBaseInfoApi) {
        this.userSettingHelper = userSettingHelper;
        this.userBaseInfoApi = userBaseInfoApi;
    }

    public Rsp getUserSubSysInfo(String userId, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userId, tenantCode})) {
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Rsp baseInfoRsp = this.userBaseInfoApi.getByUserId(tenantCode, userId);
        if (baseInfoRsp.isSuccess()) {
            UserBaseInfo baseInfo = (UserBaseInfo)baseInfoRsp.getData();
            SubSystemInfo systemInfo = new SubSystemInfo();
            BeanUtils.copyProperties((Object)baseInfo, (Object)systemInfo);
            systemInfo.setCode(tenantCode);
            systemInfo.setDepts(Collections.singletonList(baseInfo.getDept().getDeptId()));
            systemInfo.setDept(baseInfo.getDept());
            systemInfo.setPosts(new ArrayList(baseInfo.getPostList()));
            systemInfo.setRoles(new ArrayList(baseInfo.getRoleList()));
            systemInfo.setRealName(baseInfo.getRealName());
            systemInfo.setAvatarUrl(baseInfo.getAvatarUrl());
            return BaseRspUtils.createSuccessRsp((Object)systemInfo);
        }
        return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    public Rsp switchRole(String userId, UserRoleInfo userRoleInfo) {
        log.info("\u7528\u6237\u5207\u6362\u89d2\u8272:{}", (Object)userRoleInfo);
        int result = this.userRoleAndDeptMapper.updateTmoRole("00000TMO", userId, userRoleInfo.getRole());
        this.userSettingHelper.cleanUserCache("00000TMO", userId);
        return BaseRspUtils.createSuccessRsp((Object)result, (String)"\u5207\u6362\u6210\u529f");
    }
}

