/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.user.api.UserService;
import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.SendSmsRequest;
import com.tydic.nbchat.user.api.bo.UserBO;
import com.tydic.nbchat.user.api.bo.UserQueryReqBO;
import com.tydic.nbchat.user.api.bo.UserQueryRspBO;
import com.tydic.nbchat.user.api.bo.eums.SmsHelperType;
import com.tydic.nbchat.user.api.bo.eums.SmsTemplateEnum;
import com.tydic.nbchat.user.api.bo.utils.PhoneNumberUtils;
import com.tydic.nbchat.user.core.busi.UserInfoBusiService;
import com.tydic.nbchat.user.core.busi.VerifyPhoneCodeBusiService;
import com.tydic.nbchat.user.core.utils.NbchatSmsProxyHelper;
import com.tydic.nbchat.user.core.utils.VerCodeGenerateUtils;
import com.tydic.nbchat.user.mapper.UserMapper;
import com.tydic.nbchat.user.mapper.po.UserSelectCondition;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.DesensitizationUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="userService")
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private final RedisHelper redisHelper;
    private final UserMapper userMapper;
    private final NbchatSmsProxyHelper nbchatSmsProxyHelper;
    private final UserInfoBusiService userInfoBusiService;
    private final VerifyPhoneCodeBusiService verifyPhoneCodeBusiService;

    public Rsp sendSMS(AuthUserReqBO authUserReqBO) {
        String phone = authUserReqBO.getPhone();
        String appid = authUserReqBO.getChannel();
        String key = "nbchat-user:verify_code:" + phone;
        String frequencyKey = "nbchat-user:verify_code_frequency:" + phone;
        if (StringUtils.isEmpty((CharSequence)phone) || !PhoneNumberUtils.validPhoneNumber((String)phone)) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u5408\u6cd5\u7684\u624b\u673a\u53f7");
        }
        if (this.verifyPhoneCodeBusiService.checkVirtualPhone(phone)) {
            return BaseRspUtils.createErrorRsp((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u865a\u62df\u53f7\u7801");
        }
        String verifyCode = VerCodeGenerateUtils.generateVerCode();
        String code = (String)this.redisHelper.get(key);
        if (code != null) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u52ff\u91cd\u590d\u53d1\u9001");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", verifyCode);
        SendSmsRequest sendSmsRequest = SendSmsRequest.builder().phone(phone).templateCode(SmsTemplateEnum.LOGIN.getTemplateID()).channel(appid).templateParam(map).key(key).frequencyKey(frequencyKey).code(verifyCode).build();
        return this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, sendSmsRequest);
    }

    public Rsp sendSMSApply(AuthUserReqBO authUserReqBO) {
        String phone = authUserReqBO.getPhone();
        String appid = authUserReqBO.getChannel();
        String key = "nbchat-user:tenant_apply:" + phone;
        String frequencyKey = "nbchat-user:tenant_apply_frequency:" + phone;
        if (!PhoneNumberUtils.validPhoneNumber((String)phone)) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u5408\u6cd5\u7684\u624b\u673a\u53f7");
        }
        String verifyCode = VerCodeGenerateUtils.generateVerCode();
        String code = (String)this.redisHelper.get(key);
        if (code != null) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u52ff\u91cd\u590d\u53d1\u9001");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", authUserReqBO.getKeyword());
        SendSmsRequest sendSmsRequest = SendSmsRequest.builder().phone(phone).templateCode(SmsTemplateEnum.TENANT_APPLY.getTemplateID()).channel(appid).templateParam(map).key(key).frequencyKey(frequencyKey).code(verifyCode).build();
        return this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, sendSmsRequest);
    }

    public Rsp sendSMSCommon(AuthUserReqBO request) {
        String phone = request.getPhone();
        String appid = request.getChannel();
        if (StringUtils.isEmpty((CharSequence)request.getSmsTempCode())) {
            return BaseRspUtils.createErrorRsp((String)"\u53d1\u9001\u6a21\u677f\u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)phone) || !PhoneNumberUtils.validPhoneNumber((String)phone)) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u5408\u6cd5\u7684\u624b\u673a\u53f7");
        }
        String suffix = this.getKey(request.getSmsTempCode(), phone);
        String key = "nbchat-user:notice:" + suffix;
        String frequencyKey = "nbchat-user:notice_frequency:" + suffix;
        String content = (String)this.redisHelper.get(key);
        if (content != null) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u52ff\u91cd\u590d\u53d1\u9001");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("keyword", request.getKeyword());
        SendSmsRequest sendSmsRequest = SendSmsRequest.builder().phone(phone).templateCode(request.getSmsTempCode()).channel(appid).templateParam(map).key(key).frequencyKey(frequencyKey).code(request.getKeyword()).build();
        return this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, sendSmsRequest);
    }

    public Rsp getUserByPhone(String phone) {
        return this.userInfoBusiService.getUserByPhone(phone);
    }

    public RspList<UserQueryRspBO> queryPage(UserQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f:{}", (Object)reqBO);
        UserSelectCondition condition = new UserSelectCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.userMapper.selectByCondition(condition);
        ArrayList result = Lists.newArrayList();
        NiccCommonUtil.copyList((List)page.getResult(), (List)result, UserQueryRspBO.class);
        for (UserQueryRspBO userQueryRspBO : result) {
            if (!StringUtils.isNotBlank((CharSequence)userQueryRspBO.getPhone())) continue;
            userQueryRspBO.setPhone(DesensitizationUtil.commonDisplay((String)userQueryRspBO.getPhone()));
        }
        return BaseRspUtils.createSuccessRspList((List)result);
    }

    public Rsp updateById(UserBO userBO) {
        return this.userInfoBusiService.updateById(userBO);
    }

    public UserServiceImpl(RedisHelper redisHelper, UserMapper userMapper, NbchatSmsProxyHelper nbchatSmsProxyHelper, UserInfoBusiService userInfoBusiService, VerifyPhoneCodeBusiService verifyPhoneCodeBusiService) {
        this.redisHelper = redisHelper;
        this.userMapper = userMapper;
        this.nbchatSmsProxyHelper = nbchatSmsProxyHelper;
        this.userInfoBusiService = userInfoBusiService;
        this.verifyPhoneCodeBusiService = verifyPhoneCodeBusiService;
    }
}

