/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.nbchat.user.api.UserSettingsApi;
import com.tydic.nbchat.user.api.bo.eums.UserSettingKey;
import com.tydic.nbchat.user.api.bo.setting.CheckSettingBindCodeReqBO;
import com.tydic.nbchat.user.api.bo.setting.CreateSettingBindCodeReqBO;
import com.tydic.nbchat.user.api.bo.setting.CreateSettingBindCodeRspBO;
import com.tydic.nbchat.user.api.bo.setting.UserSettingContext;
import com.tydic.nbchat.user.api.bo.setting.UserSettingFlashReqBO;
import com.tydic.nbchat.user.api.bo.setting.UserSettingReqBO;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.UserSettingsMapper;
import com.tydic.nbchat.user.mapper.po.UserSettings;
import com.tydic.nicc.common.eums.SystemCommonPropKey;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=2000)
public class UserSettingsServiceImpl
implements UserSettingsApi {
    private static final Logger log = LoggerFactory.getLogger(UserSettingsServiceImpl.class);
    @Resource
    private UserSettingsMapper userSettingsMapper;
    private final UserSettingHelper userSettingHelper;
    private final NbchatUserConfigProperties nbchatUserConfigProperties;

    public UserSettingsServiceImpl(UserSettingHelper userSettingHelper, NbchatUserConfigProperties nbchatUserConfigProperties) {
        this.userSettingHelper = userSettingHelper;
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
    }

    public Rsp updateDefaultRobot(String currentRobotType, String setRobotType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{currentRobotType, setRobotType})) {
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u5f02\u5e38\uff01");
        }
        List settings = this.userSettingsMapper.selectLikeRobotType(currentRobotType);
        ArrayList<Map> retList = new ArrayList<Map>();
        log.info("\u6279\u91cf\u66f4\u65b0\u673a\u5668\u4eba\u7c7b\u578b:{}->{}|{}", new Object[]{currentRobotType, setRobotType, settings.size()});
        for (UserSettings setting : settings) {
            try {
                Map updateMap = (Map)JSONObject.parseObject((String)setting.getCurrentSetting(), Map.class);
                updateMap.put(UserSettingKey.robotType.getKey(), setRobotType);
                setting.setCurrentSetting(JSONObject.toJSONString((Object)updateMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                this.userSettingsMapper.updateSetting(setting);
                this.userSettingHelper.updateSetting(setting.getUserId(), updateMap);
                updateMap.put(SystemCommonPropKey.userId.name(), setting.getUserId());
                retList.add(updateMap);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u673a\u5668\u4eba\u7c7b\u578b\u5f02\u5e38:{}", (Object)setting, (Object)e);
            }
        }
        return BaseRspUtils.createSuccessRsp(retList);
    }

    @Transactional(rollbackFor={Exception.class})
    @MethodParamVerifyEnable
    public Rsp saveSettings(UserSettingReqBO reqBO) {
        log.info("\u4fdd\u5b58\u7528\u6237\u8bbe\u7f6e:{}", (Object)reqBO);
        Rsp<UserSettingContext> settingContext = BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u5931\u8d25");
        if (ObjectUtils.isNotEmpty((Object)reqBO.getUserIds()) && !reqBO.getUserIds().isEmpty()) {
            for (String userId : reqBO.getUserIds()) {
                settingContext = this.saveSettings(userId, reqBO.getSettings());
            }
        } else {
            settingContext = this.saveSettings(reqBO.getUserId(), reqBO.getSettings());
        }
        return settingContext;
    }

    @MethodParamVerifyEnable
    public Rsp checkSettingBindCode(CheckSettingBindCodeReqBO reqBO) {
        return BaseRspUtils.createSuccessRsp((Object)this.userSettingHelper.checkBindCode(reqBO.getCode()));
    }

    @MethodParamVerifyEnable
    public Rsp<CreateSettingBindCodeRspBO> createSettingBindCode(CreateSettingBindCodeReqBO reqBO) {
        Map<Object, Object> map = this.userSettingHelper.loadSetting(reqBO.getUserId());
        if (map.containsKey(UserSettingKey.userSettingPermission.getKey())) {
            String code = this.userSettingHelper.createBindCode(reqBO.getExpiryTime());
            String url = UriComponentsBuilder.fromHttpUrl((String)this.nbchatUserConfigProperties.getBindSettingUrl()).build(new Object[]{code}).toString();
            CreateSettingBindCodeRspBO rspBO = CreateSettingBindCodeRspBO.builder().code(code).url(url).settings(this.nbchatUserConfigProperties.getBindSettingDefault()).build();
            return BaseRspUtils.createSuccessRsp((Object)rspBO);
        }
        return BaseRspUtils.createErrorRsp((String)"\u521b\u5efa\u5931\u8d25\uff1a\u975e\u6cd5\u6743\u9650\uff01");
    }

    private Rsp<UserSettingContext> saveSettings(String userId, Map<Object, Object> settingsObj) {
        UserSettings settings = this.userSettingsMapper.selectByUserId(userId);
        this.userSettingHelper.updateSetting(userId, settingsObj);
        Rsp<UserSettingContext> settingContext = this.loadSettings(userId);
        String settingsMap = JSONObject.toJSONString((Object)((UserSettingContext)settingContext.getData()).getSettings(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        if (settings == null) {
            UserSettings insert = new UserSettings();
            insert.setSettingId(IdWorker.nextAutoIdStr());
            insert.setUserId(userId);
            insert.setTenantCode("00000000");
            insert.setCreateTime(new Date());
            insert.setUpdateTime(new Date());
            insert.setCurrentSetting(settingsMap);
            this.userSettingsMapper.insertSelective(insert);
        } else {
            UserSettings update = new UserSettings();
            update.setUserId(userId);
            update.setCurrentSetting(settingsMap);
            this.userSettingsMapper.updateSetting(update);
        }
        this.userSettingHelper.removeInfo(userId);
        log.info("\u4fdd\u5b58\u7528\u6237\u8bbe\u7f6e-\u5f53\u524d\u8bbe\u7f6e:{}", settingContext);
        return settingContext;
    }

    public Rsp<UserSettingContext> loadSettings(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237id\u4e0d\u5f97\u4e3a\u7a7a!");
        }
        Map<Object, Object> map = this.userSettingHelper.loadSetting(userId);
        UserSettingContext settingContext = UserSettingContext.builder().userId(userId).settings(map).build();
        log.info("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e:{}", (Object)settingContext);
        return BaseRspUtils.createSuccessRsp((Object)settingContext);
    }

    public Rsp flashSettings(UserSettingFlashReqBO reqBO) {
        log.info("\u5237\u65b0\u7528\u6237\u8bbe\u7f6e:{}", (Object)reqBO);
        List userIds = reqBO.getUserIds();
        if (userIds == null || reqBO.getUserIds().isEmpty()) {
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u5f02\u5e38!");
        }
        List userSettings = this.userSettingsMapper.selectUserSettings(reqBO.getUserIds());
        int count = 0;
        for (UserSettings userSetting : userSettings) {
            Map settMap = (Map)JSONObject.parseObject((String)userSetting.getCurrentSetting(), Map.class);
            if (reqBO.getRemoveKeys() != null && !reqBO.getRemoveKeys().isEmpty()) {
                for (String removeKey : reqBO.getRemoveKeys()) {
                    settMap.remove(removeKey);
                }
                String last = userSetting.getCurrentSetting();
                String settingsMap = JSONObject.toJSONString((Object)settMap);
                userSetting.setCurrentSetting(settingsMap);
                userSetting.setUpdateTime(new Date());
                userSetting.setLastSetting(last);
                this.userSettingsMapper.updateSetting(userSetting);
                this.userSettingHelper.updateSetting(userSetting.getUserId(), settMap);
            } else {
                this.userSettingHelper.updateSetting(userSetting.getUserId(), settMap);
            }
            ++count;
        }
        return BaseRspUtils.createSuccessRsp((Object)count);
    }

    public void removeUserCache(String tenantCode, String userId) {
        this.userSettingHelper.cleanUserCache(tenantCode, userId);
    }
}

