/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.tydic.nbchat.user.api.UserBaseInfoApi;
import com.tydic.nbchat.user.api.UserSuggestionService;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.suggestion.SuggestionSaveReqBO;
import com.tydic.nbchat.user.api.bo.suggestion.UserVideoIssuesReqBo;
import com.tydic.nbchat.user.api.bo.user.UserBaseInfo;
import com.tydic.nbchat.user.core.utils.DingtalkUtil;
import com.tydic.nbchat.user.core.utils.UserSettingHelper;
import com.tydic.nbchat.user.mapper.UserSuggestionMapper;
import com.tydic.nbchat.user.mapper.po.UserSuggestion;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserSuggestionServiceImpl
implements UserSuggestionService {
    private static final Logger log = LoggerFactory.getLogger(UserSuggestionServiceImpl.class);
    @Resource
    private UserSuggestionMapper userSuggestionMapper;
    private final UserSettingHelper userSettingHelper;
    @Resource
    private UserBaseInfoApi userBaseInfoApi;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public UserSuggestionServiceImpl(UserSettingHelper userSettingHelper) {
        this.userSettingHelper = userSettingHelper;
    }

    @MethodParamVerifyEnable
    public Rsp saveSuggestion(SuggestionSaveReqBO saveReqBO) {
        UserBaseInfo userInfo;
        Rsp userRsp;
        log.info("\u4fdd\u5b58\u7528\u6237\u5efa\u8bae:{}", (Object)saveReqBO);
        if (StringUtils.isNotBlank((CharSequence)saveReqBO.getContent()) && saveReqBO.getContent().length() > 500) {
            return BaseRspUtils.createErrorRsp((String)"\u5185\u5bb9\u4e0d\u5f97\u8d85\u8fc7500\u5b57\u7b26!");
        }
        if (StringUtils.isNotBlank((CharSequence)saveReqBO.getUserId()) && (userRsp = this.userBaseInfoApi.getByUserId(saveReqBO.getTenantCode(), saveReqBO.getUserId())).isSuccess() && (userInfo = (UserBaseInfo)userRsp.getData()) != null) {
            if (StringUtils.isBlank((CharSequence)saveReqBO.getUsername())) {
                saveReqBO.setUsername(userInfo.getRealName());
            }
            if (StringUtils.isBlank((CharSequence)saveReqBO.getPhone())) {
                saveReqBO.setPhone(userInfo.getPhone());
            }
        }
        UserSuggestion suggestion = new UserSuggestion();
        BeanUtils.copyProperties((Object)saveReqBO, (Object)suggestion);
        suggestion.setCreateTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)saveReqBO.getAttachmentList())) {
            String attachment = JSONArray.toJSONString((Object)saveReqBO.getAttachmentList());
            suggestion.setAttachment(attachment);
        } else {
            suggestion.setAttachment("[]");
        }
        if (("2".equals(saveReqBO.getPageSource()) || "3".equals(saveReqBO.getPageSource())) && StringUtils.isNotBlank((CharSequence)saveReqBO.getBusiId())) {
            UserSuggestion existing = this.userSuggestionMapper.selectByBusiId(saveReqBO.getBusiId());
            if (existing != null) {
                suggestion.setSuggestId(existing.getSuggestId());
                this.userSuggestionMapper.updateSuggestion(suggestion);
            } else {
                this.userSuggestionMapper.insertSelective(suggestion);
            }
        } else {
            this.userSuggestionMapper.insertSelective(suggestion);
        }
        this.sendDingNotification(saveReqBO);
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f!");
    }

    private void sendDingNotification(SuggestionSaveReqBO reqBO) {
        try {
            NbchatUserInfo userInfo;
            StringBuilder message = new StringBuilder();
            boolean isIssueReport = "2".equals(reqBO.getPageSource()) || "3".equals(reqBO.getPageSource());
            String title = isIssueReport ? "\u3010\u95ee\u9898\u4e0a\u62a5\u3011" : "\u3010\u7528\u6237\u610f\u89c1\u53cd\u9988\u6570\u636e\u3011";
            message.append(title).append("\n").append("\u7c7b\u578b\uff1a").append(reqBO.getIssueTypeName()).append("\n").append("\u4ea7\u54c1\u6a21\u5757\uff1a").append(reqBO.getProductModuleName()).append("\n").append("\u95ee\u9898\u4e0a\u62a5\u5185\u5bb9\uff1a").append(reqBO.getContent()).append("\n");
            StringBuilder accessUrls = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)reqBO.getAttachmentList())) {
                reqBO.getAttachmentList().forEach(attachment -> accessUrls.append(attachment.getAccessUrl()).append("\n"));
            } else {
                accessUrls.append("\n");
            }
            message.append("\u4e0a\u4f20\u622a\u56fe\u6216\u89c6\u9891\uff1a").append((CharSequence)accessUrls).append("\u59d3\u540d\uff1a").append(reqBO.getUsername()).append("\n").append("\u8054\u7cfb\u65b9\u5f0f\uff1a").append(reqBO.getPhone());
            if ("2".equals(reqBO.getPageSource()) || "3".equals(reqBO.getPageSource())) {
                message.append("\n\u5f02\u5e38\u65f6\u95f4\u70b9\uff1a").append(reqBO.getPartStartTime()).append(" - ").append(reqBO.getPartEndTime());
            }
            if ((userInfo = this.userSettingHelper.getUserInfo(reqBO.getUserId())) != null && StringUtils.isNotEmpty((CharSequence)userInfo.getPhone())) {
                message.append("\n\u5e73\u53f0\u6ce8\u518c\u624b\u673a\u53f7\uff1a").append(userInfo.getPhone());
            }
            if ("3".equals(reqBO.getPageSource())) {
                message.append("\n\u3010\u540e\u53f0\u4e0a\u62a5\u3011");
            }
            String origin = "tdh-portal";
            if ("2".equals(reqBO.getPageSource())) {
                origin = "tdh-admin";
            }
            DingtalkUtil.sendMessageSuggestion(message.toString(), origin);
        }
        catch (Exception e) {
            log.error("\u9489\u9489\u63a8\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7: {}", (Object)reqBO.getPhone(), (Object)e);
            throw new RuntimeException("\u6d88\u606f\u63a8\u9001\u5931\u8d25", e);
        }
    }

    public Rsp<?> getSuggestionByBusiId(UserVideoIssuesReqBo reqBO) {
        log.info("\u6839\u636e\u4e1a\u52a1ID\u67e5\u8be2\u5efa\u8bae\uff0cbusiId: {}", (Object)reqBO.getBusiId());
        if (StringUtils.isBlank((CharSequence)reqBO.getBusiId())) {
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u9519\u8bef");
        }
        UserSuggestion userSuggestion = new UserSuggestion();
        BeanUtils.copyProperties((Object)reqBO, (Object)userSuggestion);
        UserSuggestion rspBO = this.userSuggestionMapper.selectByBusiId(reqBO.getBusiId());
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }
}

