/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.user.api.UserBaseInfoApi;
import com.tydic.nbchat.user.api.UserVideoIssuesApi;
import com.tydic.nbchat.user.api.bo.SendSmsRequest;
import com.tydic.nbchat.user.api.bo.eums.SmsHelperType;
import com.tydic.nbchat.user.api.bo.eums.SmsTemplateEnum;
import com.tydic.nbchat.user.api.bo.suggestion.UserSuggestionRspBO;
import com.tydic.nbchat.user.api.bo.suggestion.UserSuggestionStatsBO;
import com.tydic.nbchat.user.api.bo.suggestion.UserVideoIssuesBO;
import com.tydic.nbchat.user.api.bo.suggestion.UserVideoIssuesReqBo;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRechargeReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRefundReqBO;
import com.tydic.nbchat.user.api.bo.user.UserBaseInfo;
import com.tydic.nbchat.user.api.trade.TradeBalanceApi;
import com.tydic.nbchat.user.core.enmus.SuggestionStateEnum;
import com.tydic.nbchat.user.core.utils.NbchatSmsProxyHelper;
import com.tydic.nbchat.user.mapper.UserSuggestionMapper;
import com.tydic.nbchat.user.mapper.po.UserSuggestion;
import com.tydic.nbchat.user.mapper.po.UserVideoIssuesCondition;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserVideoIssuesServiceImpl
implements UserVideoIssuesApi {
    private static final Logger log = LoggerFactory.getLogger(UserVideoIssuesServiceImpl.class);
    @Resource
    private UserSuggestionMapper userSuggestionMapper;
    @Resource
    private TradeBalanceApi tradeBalanceApi;
    @Resource
    private NbchatSmsProxyHelper nbchatSmsProxyHelper;
    @Resource
    private UserBaseInfoApi userBaseInfoApi;

    public RspList<UserVideoIssuesBO> getVideoIssuesList(UserVideoIssuesReqBo queryReqBO) {
        log.info("\u8fd0\u8425\u5e73\u53f0\u7528\u6237\u89c6\u9891\u95ee\u9898\u53cd\u9988\u5217\u8868\u67e5\u8be2:{}", (Object)queryReqBO);
        UserVideoIssuesCondition condition = new UserVideoIssuesCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        List resultList = this.userSuggestionMapper.selectWithCreationTask(condition);
        ArrayList list = Lists.newArrayList();
        NiccCommonUtil.copyList((List)resultList, (List)list, UserVideoIssuesBO.class);
        for (UserVideoIssuesBO bo : list) {
            if (bo.getStartTime() != null && bo.getEndTime() != null) {
                bo.setDuration(Long.valueOf((bo.getEndTime().getTime() - bo.getStartTime().getTime()) / 1000L));
                continue;
            }
            if (bo.getStartTime() == null) continue;
            bo.setDuration(Long.valueOf((System.currentTimeMillis() - bo.getStartTime().getTime()) / 1000L));
        }
        return BaseRspUtils.createSuccessRspList((List)list, (long)page.getTotal());
    }

    public RspList<UserVideoIssuesBO> getSuggestionList(UserVideoIssuesReqBo queryReqBO) {
        log.info("\u8fd0\u8425\u5e73\u53f0\u7528\u6237\u95ee\u9898\u53cd\u9988\u5217\u8868\u67e5\u8be2:{}", (Object)queryReqBO);
        UserVideoIssuesCondition condition = new UserVideoIssuesCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        List resultList = this.userSuggestionMapper.selectGetSuggestionList(condition);
        ArrayList list = Lists.newArrayList();
        NiccCommonUtil.copyList((List)resultList, (List)list, UserVideoIssuesBO.class);
        return BaseRspUtils.createSuccessRspList((List)list, (long)page.getTotal());
    }

    public RspList<UserVideoIssuesBO> selectVideoCostByBizId(UserVideoIssuesReqBo queryReqBO) {
        log.info("\u7528\u6237\u53cd\u9988\u89c6\u9891\u7b97\u529b\u70b9\u6d88\u8017\u67e5\u8be2:{}", (Object)queryReqBO.getBizId());
        if (StringUtils.isEmpty((String)queryReqBO.getBizId())) {
            return BaseRspUtils.createErrorRspList((String)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List resultList = this.userSuggestionMapper.selectVideoCostByBizId(queryReqBO.getBizId());
        ArrayList boList = Lists.newArrayList();
        NiccCommonUtil.copyList((List)resultList, (List)boList, UserVideoIssuesBO.class);
        return BaseRspUtils.createSuccessRspList((List)boList);
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp adminAuditVideoIssues(UserVideoIssuesReqBo reqBO) {
        log.info("\u89c6\u9891\u95ee\u9898\u53cd\u9988\u5ba1\u6838\u5e76\u9000\u8fd8\u7b97\u529b\u70b9, reqBO={}", (Object)reqBO);
        UserSuggestion currentSuggestion = this.userSuggestionMapper.selectById(reqBO.getSuggestId());
        if (!SuggestionStateEnum.PENDING.getCode().equals(currentSuggestion.getSuggestionState())) {
            return BaseRspUtils.createErrorRsp((String)"\u53ea\u6709\u5f85\u67e5\u770b\u72b6\u6001\u53ef\u64cd\u4f5c");
        }
        String newStatus = reqBO.getSuggestionState();
        if (SuggestionStateEnum.ACCEPTED.getCode().equals(newStatus)) {
            if (reqBO.isNeedRefund()) {
                if (reqBO.getScore() == null || reqBO.getScore() <= 0) {
                    return BaseRspUtils.createErrorRsp((String)"\u9000\u8fd8\u7684\u7b97\u529b\u70b9\u5fc5\u987b\u5927\u4e8e0");
                }
                UserVideoIssuesReqBo costReq = new UserVideoIssuesReqBo();
                costReq.setBizId(reqBO.getBizId());
                RspList<UserVideoIssuesBO> costRsp = this.selectVideoCostByBizId(costReq);
                if (!costRsp.isSuccess() || CollectionUtils.isEmpty((Collection)costRsp.getRows())) {
                    return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8be5\u4efb\u52a1\u7684\u6d88\u8017\u8bb0\u5f55");
                }
                Integer totalConsumedScore = ((UserVideoIssuesBO)costRsp.getRows().get(0)).getScore();
                if (totalConsumedScore == null) {
                    return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1\u6d88\u8017\u79ef\u5206\u6570\u636e\u5f02\u5e38");
                }
                if (reqBO.getScore() > totalConsumedScore) {
                    return BaseRspUtils.createErrorRsp((String)"\u9000\u8fd8\u7684\u7b97\u529b\u70b9\u4e0d\u80fd\u5927\u4e8e\u5df2\u6d88\u8017\u7684\u7b97\u529b\u70b9");
                }
                UserBalanceRefundReqBO refundReqBO = new UserBalanceRefundReqBO();
                refundReqBO.setBizId(reqBO.getBizId());
                refundReqBO.setTradeId(reqBO.getTradeId());
                refundReqBO.setRefundScore(reqBO.getScore());
                refundReqBO.setRemark(reqBO.getRemark());
                Rsp refundResult = this.tradeBalanceApi.refund(refundReqBO);
                if (!refundResult.isSuccess()) {
                    return BaseRspUtils.createErrorRsp((String)"\u9000\u6b3e\u5931\u8d25");
                }
                UserVideoIssuesBO smsBO = new UserVideoIssuesBO();
                smsBO.setPhone(reqBO.getPhone());
                smsBO.setRefundScore(reqBO.getScore());
                smsBO.setCreationName(reqBO.getCreationName());
                this.sendRefundSuccessSms(smsBO);
            }
            UserSuggestion userSuggestion = new UserSuggestion();
            userSuggestion.setSuggestId(reqBO.getSuggestId());
            userSuggestion.setSuggestionState(SuggestionStateEnum.ACCEPTED.getCode());
            userSuggestion.setAuditTime(new Date());
            userSuggestion.setOrderNo(reqBO.getTradeId());
            int updateSuccess = this.userSuggestionMapper.updateSuggestion(userSuggestion);
            if (updateSuccess <= 0) {
                return BaseRspUtils.createErrorRsp((String)"\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        if (SuggestionStateEnum.EXPIRED.getCode().equals(newStatus)) {
            UserSuggestion userSuggestion = new UserSuggestion();
            userSuggestion.setSuggestId(reqBO.getSuggestId());
            userSuggestion.setSuggestionState(SuggestionStateEnum.EXPIRED.getCode());
            userSuggestion.setAuditTime(new Date());
            this.userSuggestionMapper.updateSuggestion(userSuggestion);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp adminGiveVideoIssues(UserVideoIssuesReqBo reqBO) {
        log.info("\u7ba1\u7406\u5458\u8d60\u9001\u89c6\u9891\u95ee\u9898\u53cd\u9988\u7b97\u529b\u70b9, reqBO={}", (Object)reqBO);
        UserSuggestion suggestion = this.userSuggestionMapper.selectById(reqBO.getSuggestId());
        if (suggestion == null) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u53cd\u9988\u8bb0\u5f55");
        }
        if (!SuggestionStateEnum.PENDING.getCode().equals(suggestion.getSuggestionState())) {
            return BaseRspUtils.createErrorRsp((String)"\u53ea\u6709\u5f85\u5904\u7406\u72b6\u6001\u7684\u53cd\u9988\u624d\u53ef\u4ee5\u64cd\u4f5c");
        }
        String newStatus = reqBO.getSuggestionState();
        if (SuggestionStateEnum.ACCEPTED.getCode().equals(newStatus)) {
            if (reqBO.isNeedGive()) {
                if (reqBO.getScore() == null || reqBO.getScore() <= 0) {
                    return BaseRspUtils.createErrorRsp((String)"\u8d60\u9001\u7684\u7b97\u529b\u70b9\u5fc5\u987b\u5927\u4e8e0");
                }
                UserBalanceRechargeReqBO rechargeReqBO = new UserBalanceRechargeReqBO();
                rechargeReqBO.setTenantCode(suggestion.getTenantCode());
                rechargeReqBO.setUserId(suggestion.getUserId());
                rechargeReqBO.setScore(reqBO.getScore());
                rechargeReqBO.setBizId(suggestion.getBusiId());
                rechargeReqBO.setExpireTime(reqBO.getExpireTime());
                rechargeReqBO.setRemark(reqBO.getRemark());
                Rsp rechargeResult = this.tradeBalanceApi.recharge(rechargeReqBO);
                if (!rechargeResult.isSuccess()) {
                    return BaseRspUtils.createErrorRsp((String)("\u8d60\u9001\u5931\u8d25\uff1a" + rechargeResult.getRspDesc()));
                }
                this.sendGiveSuccessSms(suggestion, reqBO.getScore());
            }
            UserSuggestion updateParam = new UserSuggestion();
            updateParam.setSuggestId(reqBO.getSuggestId());
            updateParam.setSuggestionState(SuggestionStateEnum.ACCEPTED.getCode());
            updateParam.setAuditTime(new Date());
            int updateCount = this.userSuggestionMapper.updateSuggestion(updateParam);
            if (updateCount <= 0) {
                return BaseRspUtils.createErrorRsp((String)"\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        if (SuggestionStateEnum.EXPIRED.getCode().equals(newStatus) || SuggestionStateEnum.PROCESSED.getCode().equals(newStatus)) {
            UserSuggestion updateParam = new UserSuggestion();
            updateParam.setSuggestId(reqBO.getSuggestId());
            updateParam.setSuggestionState(newStatus);
            updateParam.setAuditTime(new Date());
            this.userSuggestionMapper.updateSuggestion(updateParam);
            return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public Rsp<UserSuggestionRspBO> selectSuggestionStats(UserVideoIssuesReqBo reqBO) {
        log.info("\u89c6\u9891\u4e0a\u62a5\u3001\u610f\u89c1\u53cd\u9988\u3001\u5ba1\u6838\u72b6\u6001\u8fd1\u4e09\u5341\u5929\u7edf\u8ba1, reqBO={}", (Object)reqBO);
        UserSuggestionRspBO repVo = new UserSuggestionRspBO();
        UserVideoIssuesCondition condition = new UserVideoIssuesCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        condition.setDays(reqBO.getDays());
        condition.setProductModule(reqBO.getProductModule());
        condition.setPageSource(reqBO.getPageSource());
        List statsList = this.userSuggestionMapper.selectSuggestionStats(condition);
        ArrayList boList = Lists.newArrayList();
        NiccCommonUtil.copyList((List)statsList, (List)boList, UserSuggestionStatsBO.class);
        this.loadReportData(boList, repVo);
        return BaseRspUtils.createSuccessRsp((Object)repVo);
    }

    private void loadReportData(List<UserSuggestionStatsBO> list, UserSuggestionRspBO repVo) {
        if (!CollectionUtils.isEmpty(list)) {
            Integer totalCount = 0;
            for (UserSuggestionStatsBO item : list) {
                totalCount = totalCount + item.getRecordCount();
            }
            repVo.setTotalRecords(totalCount);
            DecimalFormat df = new DecimalFormat("0.00");
            ArrayList<UserSuggestionStatsBO> result = new ArrayList<UserSuggestionStatsBO>();
            for (UserSuggestionStatsBO item : list) {
                double percentage = totalCount != 0 ? (double)item.getRecordCount().intValue() / (double)totalCount.intValue() * 100.0 : 0.0;
                item.setPercentage(df.format(percentage) + "%");
                result.add(item);
            }
            repVo.setItems(result);
        }
    }

    private void sendRefundSuccessSms(UserVideoIssuesBO bo) {
        String phone = bo.getPhone();
        String creationName = bo.getCreationName();
        Integer refundScore = bo.getRefundScore();
        if (StringUtils.isBlank((CharSequence)phone) || StringUtils.isBlank((CharSequence)creationName) || refundScore == null || refundScore <= 0) {
            log.warn("\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1");
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("creationName", creationName);
        params.put("refundScore", refundScore.toString());
        SendSmsRequest smsReq = SendSmsRequest.builder().templateCode(SmsTemplateEnum.VIDEO_ISSUES_AUDIT_REFUND.getTemplateID()).phone(phone).signName("\u5317\u4eac\u5929\u6e90\u8fea\u79d1").templateParam(params).build();
        Rsp smsResult = this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, smsReq);
        if (!smsResult.isSuccess()) {
            log.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7\uff1a{}", (Object)smsReq.getPhone());
        }
    }

    private void sendGiveSuccessSms(UserSuggestion suggestion, Integer giveScore) {
        String userId = suggestion.getUserId();
        String tenantCode = suggestion.getTenantCode();
        Rsp userBaseInfoRsp = this.userBaseInfoApi.getByUserId(tenantCode, userId);
        UserBaseInfo userBaseInfo = (UserBaseInfo)userBaseInfoRsp.getData();
        String phone = userBaseInfo.getPhone();
        if (StringUtils.isBlank((CharSequence)phone)) {
            log.error("\u7528\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff0cuserId={}, tenantCode={}", (Object)userId, (Object)tenantCode);
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("score", giveScore.toString());
        SendSmsRequest smsReq = SendSmsRequest.builder().templateCode(SmsTemplateEnum.VIDEO_ISSUES_GIVE.getTemplateID()).phone(phone).signName("\u5317\u4eac\u5929\u6e90\u8fea\u79d1").templateParam(params).build();
        Rsp smsResult = this.nbchatSmsProxyHelper.send(SmsHelperType.ALI, smsReq);
        if (!smsResult.isSuccess()) {
            log.error("\u8d60\u9001\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7\uff1a{}", (Object)smsReq.getPhone());
        }
    }
}

