/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.tydic.nbchat.user.api.UserVipRightsApi;
import com.tydic.nbchat.user.api.bo.vip.NbchatUserVipRightsBO;
import com.tydic.nbchat.user.mapper.NbchatUserVipRightsMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserVipRights;
import com.tydic.nicc.common.bo.BaseInfo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class UserVipRightsServiceImpl
implements UserVipRightsApi {
    private static final Logger log = LoggerFactory.getLogger(UserVipRightsServiceImpl.class);
    @Resource
    NbchatUserVipRightsMapper nbchatUserVipRightsMapper;

    public RspList query(NbchatUserVipRightsBO request) {
        log.info("\u67e5\u8be2\u7528\u6237\u6743\u76ca:{}", (Object)request);
        NbchatUserVipRights cond = new NbchatUserVipRights();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        List rights = this.nbchatUserVipRightsMapper.selectAll(cond);
        ArrayList res = new ArrayList();
        NiccCommonUtil.copyList((List)rights, res, NbchatUserVipRightsBO.class);
        return BaseRspUtils.createSuccessRspList(res);
    }

    public Rsp saveRights(NbchatUserVipRightsBO request) {
        NbchatUserVipRights cond = new NbchatUserVipRights();
        cond.setUserId(request.getUserId());
        cond.setTenantCode(request.getTenantCode());
        cond.setRightsType(request.getRightsType());
        NbchatUserVipRights vipRights = this.nbchatUserVipRightsMapper.queryRightsByType(cond);
        NbchatUserVipRights po = new NbchatUserVipRights();
        BeanUtils.copyProperties((Object)request, (Object)po);
        if (ObjectUtils.isEmpty((Object)vipRights)) {
            if (StringUtils.isNotEmpty((CharSequence)request.getTargetTenantCode())) {
                po.setUserId(request.getTargetTenantCode());
            }
            if (ObjectUtils.allNull((Object[])new Object[]{po.getStartTime(), po.getEndTime()})) {
                po.setStartTime(new Date());
                po.setEndTime(DateTimeUtil.DateAddYear((int)1));
            }
            if (request.getRightsCount() == null) {
                po.setRightsCount(request.getAddCount());
                po.setUsableCount(request.getAddCount());
            }
            this.nbchatUserVipRightsMapper.insertSelective(po);
        } else {
            if (ObjectUtils.isNotEmpty((Object)request.getAddCount())) {
                po.setRightsCount(Integer.valueOf(vipRights.getRightsCount() + request.getAddCount()));
                po.setUsableCount(Integer.valueOf(vipRights.getUsableCount() + request.getAddCount()));
            }
            po.setId(vipRights.getId());
            po.setRightsStatus("0");
            po.setEndTime(DateTimeUtil.DateAddYear((int)1));
            this.nbchatUserVipRightsMapper.update(po);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u66f4\u65b0\u7528\u6237VIP\u6743\u76ca\u6210\u529f");
    }

    public Rsp queryTenantRights(NbchatUserVipRightsBO request) {
        NbchatUserVipRights po = new NbchatUserVipRights();
        po.setTenantCode(request.getTargetTenantCode());
        po.setUserId(request.getTargetTenantCode());
        po.setCustomizeType(request.getCustomizeType());
        NbchatUserVipRights right = this.nbchatUserVipRightsMapper.queryRights(po);
        NbchatUserVipRightsBO rsp = new NbchatUserVipRightsBO();
        if (ObjectUtils.isEmpty((Object)right)) {
            rsp.setRightsCount(Integer.valueOf(0));
            rsp.setUsedCount(Integer.valueOf(0));
            return BaseRspUtils.createSuccessRsp((Object)rsp);
        }
        BeanUtils.copyProperties((Object)right, (Object)rsp);
        rsp.setUsableCount(Integer.valueOf(right.getRightsCount() - right.getUsedCount()));
        return BaseRspUtils.createSuccessRsp((Object)rsp);
    }

    public Rsp deductRights(NbchatUserVipRightsBO request) {
        NbchatUserVipRights right;
        log.info("\u66f4\u65b0\u7528\u6237VIP\u6743\u76ca:{}", (Object)request);
        NbchatUserVipRights po = new NbchatUserVipRights();
        po.setUserId(request.getUserId());
        po.setTenantCode(request.getTenantCode());
        po.setRightsType(request.getRightsType());
        if (!"00000000".equals(request.getTenantCode())) {
            po.setUserId(request.getTenantCode());
        }
        if (ObjectUtils.isEmpty((Object)(right = this.nbchatUserVipRightsMapper.queryRights(po))) || right.getUsableCount() <= 0) {
            log.warn("\u672a\u627e\u5230\u7528\u6237\u6709\u6548\u6743\u76ca\uff1a{}", (Object)request);
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u65e0\u6743\u76ca");
        }
        po.setId(right.getId());
        int i = this.nbchatUserVipRightsMapper.updateRightsUsed(po);
        return BaseRspUtils.createSuccessRsp((Object)"\u66f4\u65b0\u7528\u6237VIP\u6743\u76ca\u6210\u529f");
    }

    public RspList queryRights(NbchatUserVipRightsBO request) {
        log.info("\u67e5\u8be2\u6743\u76ca:{}", (Object)request);
        NbchatUserVipRights po = new NbchatUserVipRights();
        po.setTenantCode(request.getTargetTenantCode());
        po.setUserId(request.getTargetTenantCode());
        List rights = this.nbchatUserVipRightsMapper.queryAllRights(po);
        if (CollectionUtils.isEmpty((Collection)rights)) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u627e\u5230\u6743\u76ca");
        }
        ArrayList res = new ArrayList();
        NiccCommonUtil.copyList((List)rights, res, NbchatUserVipRightsBO.class);
        return BaseRspUtils.createSuccessRspList(res);
    }

    public Rsp getRightsFree(BaseInfo request) {
        if (!"00000000".equals(request.getTenantCode())) {
            request.set_userId(request.getTenantCode());
        }
        List rights = this.nbchatUserVipRightsMapper.countFreeRights(request.getTenantCode(), request.get_userId());
        Map map = rights.stream().collect(HashMap::new, (m, v) -> m.put(v.getType(), v.getFree()), HashMap::putAll);
        return BaseRspUtils.createSuccessRsp((Object)map);
    }
}

