/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.user.api.UserVipApi;
import com.tydic.nbchat.user.api.bo.eums.ScoreTaskType;
import com.tydic.nbchat.user.api.bo.vip.UserVipBO;
import com.tydic.nbchat.user.api.bo.vip.UserVipGiveDouBO;
import com.tydic.nbchat.user.api.bo.vip.UserVipQueryReqBO;
import com.tydic.nbchat.user.core.busi.UserVipService;
import com.tydic.nbchat.user.mapper.NbchatUserScoreTaskMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserScoreTaskCondition;
import com.tydic.nbchat.user.mapper.po.NbchatUserVip;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=2000)
public class UserVipServiceImpl
implements UserVipApi {
    private static final Logger log = LoggerFactory.getLogger(UserVipServiceImpl.class);
    private final UserVipService userVipService;
    @Resource
    private NbchatUserScoreTaskMapper nbchatUserScoreTaskMapper;

    public UserVipServiceImpl(UserVipService userVipService) {
        this.userVipService = userVipService;
    }

    public Rsp<UserVipBO> getUserVip(UserVipQueryReqBO userVipReqBO) {
        List<NbchatUserVip> vips = this.userVipService.getVipInfo(userVipReqBO.getTenantCode(), userVipReqBO.get_userId());
        if (CollectionUtils.isNotEmpty(vips)) {
            NbchatUserVip vip = vips.get(0);
            UserVipBO userVipBO = new UserVipBO();
            BeanUtils.copyProperties((Object)vip, (Object)userVipBO);
            ArrayList bos = new ArrayList();
            NiccCommonUtil.copyList(vips, bos, UserVipBO.class);
            userVipBO.setVipList(bos);
            return BaseRspUtils.createSuccessRsp((Object)userVipBO);
        }
        return BaseRspUtils.createSuccessRsp(null, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237VIP\u4fe1\u606f");
    }

    public RspList<UserVipGiveDouBO> getVipGiveDouList(UserVipQueryReqBO userVipReqBO) {
        ArrayList list = new ArrayList();
        NbchatUserScoreTaskCondition condition = new NbchatUserScoreTaskCondition();
        condition.setUserId(userVipReqBO.get_userId());
        condition.setTenantCode(userVipReqBO.getTenantCode());
        condition.setTaskType(ScoreTaskType.RECHARGE.getCode());
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        condition.setKeyword("\u4f1a\u5458");
        Page page = PageHelper.startPage((int)userVipReqBO.getPage(), (int)userVipReqBO.getLimit());
        this.nbchatUserScoreTaskMapper.selectByCondition(condition);
        NiccCommonUtil.copyList((List)page.getResult(), list, UserVipGiveDouBO.class);
        return BaseRspUtils.createSuccessRspList(list, (long)page.getTotal());
    }
}

