/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.service.sms;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.tydic.nbchat.user.api.NbChatSmsHelper;
import com.tydic.nbchat.user.api.bo.BaseSmsRequest;
import com.tydic.nbchat.user.api.bo.SendBatchSmsRequest;
import com.tydic.nbchat.user.api.bo.SendSmsRequest;
import com.tydic.nbchat.user.api.bo.eums.SmsHelperType;
import com.tydic.nbchat.user.api.bo.utils.PhoneNumberUtils;
import com.tydic.nbchat.user.core.config.SmsConfigProperties;
import com.tydic.nbchat.user.core.service.sms.SmsTemplateService;
import com.tydic.nbchat.user.core.utils.SmsRedisUtils;
import com.tydic.nbchat.user.core.vo.SmsResultVO;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="aliSmsService")
public class AliSmsHelperImpl
implements NbChatSmsHelper {
    private static final Logger log = LoggerFactory.getLogger(AliSmsHelperImpl.class);
    private final SmsConfigProperties smsConfigProperties;
    private final SmsRedisUtils smsRedisUtils;
    private final SmsTemplateService smsTemplateService;
    private IAcsClient client;

    public AliSmsHelperImpl(SmsConfigProperties smsConfigProperties, SmsRedisUtils smsRedisUtils, SmsTemplateService smsTemplateService) {
        this.smsConfigProperties = smsConfigProperties;
        this.smsRedisUtils = smsRedisUtils;
        this.smsTemplateService = smsTemplateService;
        DefaultProfile profile = DefaultProfile.getProfile((String)smsConfigProperties.getRegion(), (String)smsConfigProperties.getAccessKeyId(), (String)smsConfigProperties.getAccessKeySecret());
        this.client = new DefaultAcsClient((IClientProfile)profile);
    }

    public String type() {
        return SmsHelperType.ALI.getCode();
    }

    @MethodParamVerifyEnable
    public Rsp sendSms(SendSmsRequest sendSmsRequest) {
        String originalTemplateCode;
        log.info("\u77ed\u4fe1\u53d1\u9001-\u5f00\u59cb:{}", (Object)sendSmsRequest);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(this.smsConfigProperties.getEndpointOverride());
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        String phone = sendSmsRequest.getPhone();
        String areaCode = PhoneNumberUtils.extractAreaCode((String)phone);
        String templateCode = originalTemplateCode = sendSmsRequest.getTemplateCode();
        String templateCodeOrId = this.smsTemplateService.getTemplateCode(originalTemplateCode);
        if (!"86".equals(areaCode) && !originalTemplateCode.equals(templateCode = this.smsTemplateService.getTemplateIdByAreaCode(areaCode, templateCodeOrId))) {
            log.info("\u77ed\u4fe1\u53d1\u9001-\u533a\u53f7\u6a21\u677f\u9009\u62e9: \u533a\u53f7={}, \u539f\u59cb\u6a21\u677f={}, \u9009\u62e9\u6a21\u677f={}", new Object[]{areaCode, originalTemplateCode, templateCode});
        }
        if (!"86".equals(areaCode) && !templateCodeOrId.equals("LOGIN")) {
            log.info("\u8df3\u8fc7\u53d1\u9001\u975eLOGIN\u77ed\u4fe1\u5230\u56fd\u9645\u53f7\u7801: \u533a\u53f7={}, \u624b\u673a\u53f7={}, \u6a21\u677f\u4ee3\u7801={}", new Object[]{areaCode, PhoneNumberUtils.maskPhoneNum((String)phone), templateCode});
            return BaseRspUtils.createSuccessRsp((Object)"\u56fd\u9645\u53f7\u7801\u4ec5\u652f\u6301\u767b\u5f55\u9a8c\u8bc1\u7801\u77ed\u4fe1");
        }
        request.putQueryParameter("PhoneNumbers", phone);
        if (StringUtils.isNotBlank((CharSequence)sendSmsRequest.getSignName())) {
            request.putQueryParameter("SignName", sendSmsRequest.getSignName());
        } else {
            request.putQueryParameter("SignName", this.smsConfigProperties.getSignName());
        }
        request.putQueryParameter("TemplateCode", templateCode);
        request.putQueryParameter("TemplateParam", JSONObject.toJSONString((Object)sendSmsRequest.getTemplateParam()));
        try {
            CommonResponse response = this.client.getCommonResponse(request);
            log.info("\u77ed\u4fe1\u53d1\u9001-\u8bf7\u6c42\u7ed3\u679c: {}|{}", (Object)request, (Object)response.getData());
            SmsResultVO smsResultVO = (SmsResultVO)JSON.parseObject((String)response.getData(), SmsResultVO.class);
            String code = smsResultVO.getCode();
            if (StringUtils.isNotEmpty((CharSequence)code) && "OK".equals(code)) {
                log.info("\u77ed\u4fe1\u53d1\u9001-\u6210\u529f: {}|{}", (Object)sendSmsRequest, (Object)response.getData());
                if (StringUtils.isNotBlank((CharSequence)sendSmsRequest.getCode())) {
                    this.smsRedisUtils.sendSms(sendSmsRequest);
                }
                return BaseRspUtils.createSuccessRsp((Object)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
            }
            log.error("\u77ed\u4fe1\u53d1\u9001-\u5931\u8d25: {}|{}", (Object)sendSmsRequest, (Object)response.getData());
            return BaseRspUtils.createErrorRsp((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u53d1\u9001-\u5f02\u5e38: {}", (Object)sendSmsRequest, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
    }

    public RspList<String> sendBatchSms(SendBatchSmsRequest sendBatchSmsRequest) {
        log.info("\u6279\u91cf\u77ed\u4fe1\u53d1\u9001-\u5f00\u59cb:{}", (Object)sendBatchSmsRequest);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(this.smsConfigProperties.getEndpointOverride());
        request.setVersion("2017-05-25");
        request.setAction("SendBatchSms");
        ArrayList successPhone = new ArrayList();
        AliSmsHelperImpl.partitionCollection(sendBatchSmsRequest.getBaseSms(), 100).forEach(baseSmsRequests -> {
            List baseSmsList = baseSmsRequests.stream().filter(o -> {
                String areaCode = PhoneNumberUtils.extractAreaCode((String)o.getPhone());
                return "86".equals(areaCode);
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(baseSmsList)) {
                log.warn("\u56fd\u9645\u53f7\u7801\u4ec5\u652f\u6301\u767b\u5f55\u9a8c\u8bc1\u7801\u77ed\u4fe1\uff0c\u6279\u91cf\u53d1\u9001\u7684\u624b\u673a\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\u975e\u56fd\u9645\u53f7\u7801");
                return;
            }
            List sendSmsPhone = baseSmsList.stream().map(BaseSmsRequest::getPhone).collect(Collectors.toList());
            request.putQueryParameter("PhoneNumberJson", JSON.toJSONString(sendSmsPhone));
            request.putQueryParameter("SignNameJson", JSON.toJSONString(baseSmsList.stream().map(baseSmsRequest -> {
                if (StringUtils.isBlank((CharSequence)baseSmsRequest.getSignName())) {
                    return this.smsConfigProperties.getSignName();
                }
                return baseSmsRequest.getSignName();
            }).collect(Collectors.toList())));
            request.putQueryParameter("TemplateCode", sendBatchSmsRequest.getTemplateCode());
            request.putQueryParameter("TemplateParamJson", JSON.toJSONString(baseSmsList.stream().map(BaseSmsRequest::getTemplateParam).collect(Collectors.toList())));
            try {
                CommonResponse response = this.client.getCommonResponse(request);
                log.info("\u6279\u91cf\u77ed\u4fe1\u53d1\u9001-\u8bf7\u6c42\u7ed3\u679c: {}|{}", (Object)request, (Object)response.getData());
                SmsResultVO smsResultVO = (SmsResultVO)JSON.parseObject((String)response.getData(), SmsResultVO.class);
                if (StringUtils.isNotEmpty((CharSequence)smsResultVO.getCode()) && "OK".equals(smsResultVO.getCode())) {
                    log.info("\u6279\u91cf\u77ed\u4fe1\u53d1\u9001-\u6210\u529f: {}|{}", (Object)sendBatchSmsRequest, (Object)response.getData());
                    successPhone.addAll(sendSmsPhone);
                    return;
                }
                log.error("\u6279\u91cf\u77ed\u4fe1\u53d1\u9001-\u5931\u8d25: {}|{}", (Object)sendBatchSmsRequest, (Object)response.getData());
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u77ed\u4fe1\u53d1\u9001-\u5f02\u5e38: {}", (Object)sendBatchSmsRequest, (Object)e);
            }
        });
        return BaseRspUtils.createSuccessRspList(successPhone);
    }

    private static <T> List<List<T>> partitionCollection(Collection<T> collections, int size) {
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        ArrayList<T> partition = new ArrayList<T>();
        for (T item : collections) {
            partition.add(item);
            if (partition.size() != size) continue;
            partitions.add(partition);
            partition = new ArrayList();
        }
        if (!partition.isEmpty()) {
            partitions.add(partition);
        }
        return partitions;
    }
}

